/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game.crazyeights;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardPlay;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.game.DrawSlot;
import dev.lucaargolo.charta.game.GameOption;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.game.PlaySlot;
import dev.lucaargolo.charta.game.Rank;
import dev.lucaargolo.charta.game.Suit;
import dev.lucaargolo.charta.game.crazyeights.CrazyEightsMenu;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import dev.lucaargolo.charta.sound.ModSounds;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;

public class CrazyEightsGame
extends CardGame<CrazyEightsGame> {
    private final GameOption.Number AVAILABLE_DRAWS = new GameOption.Number(3, 1, 5, (Component)Component.translatable((String)"rule.charta.available_draws"), (Component)Component.translatable((String)"rule.charta.available_draws.description"));
    private final PlaySlot playPile;
    private final DrawSlot drawPile;
    public final GameSlot suits = new GameSlot(this){

        @Override
        public boolean removeAll() {
            return false;
        }
    };
    public boolean isChoosingWild;
    public Suit currentSuit;
    public int drawsLeft = (Integer)this.AVAILABLE_DRAWS.get();

    public CrazyEightsGame(List<CardPlayer> players, Deck deck) {
        super(players, deck);
        this.drawPile = this.addSlot(new DrawSlot(this, new LinkedList<Card>(), 47.5f, 62.5f, 0.0f, 0.0f, () -> this.drawsLeft > 0));
        this.playPile = this.addSlot(new PlaySlot(this, new LinkedList<Card>(), 87.5f, 62.5f, 0.0f, 0.0f, this.drawPile));
    }

    @Override
    public GameSlot getPlayerHand(CardPlayer player) {
        return player == this.getCurrentPlayer() && this.isChoosingWild ? this.suits : super.getPlayerHand(player);
    }

    @Override
    protected GameSlot createPlayerHand(CardPlayer player) {
        return new GameSlot(player.hand()){

            @Override
            public void onInsert(CardPlayer player, List<Card> cards, int index) {
                super.onInsert(player, cards, index);
                if (CrazyEightsGame.this.drawPile.isDraw()) {
                    player.play(null);
                    CrazyEightsGame.this.drawPile.setDraw(false);
                }
            }

            @Override
            public boolean removeAll() {
                return false;
            }
        };
    }

    @Override
    public List<GameOption<?>> getOptions() {
        return List.of(this.AVAILABLE_DRAWS);
    }

    @Override
    public AbstractCardMenu<CrazyEightsGame> createMenu(int containerId, Inventory playerInventory, ServerLevel level, BlockPos pos, Deck deck) {
        return new CrazyEightsMenu(containerId, playerInventory, ContainerLevelAccess.create((Level)level, (BlockPos)pos), deck, this.players.stream().mapToInt(CardPlayer::getId).toArray(), this.getRawOptions());
    }

    @Override
    public Predicate<Deck> getDeckPredicate() {
        return deck -> deck.getCards().size() >= 52 && Charta.DEFAULT_SUITS.containsAll((Collection<?>)deck.getUniqueSuits()) && deck.getUniqueSuits().containsAll(Charta.DEFAULT_SUITS);
    }

    @Override
    public Predicate<Card> getCardPredicate() {
        return card -> Charta.DEFAULT_SUITS.contains(card.suit()) && Charta.DEFAULT_RANKS.contains(card.rank());
    }

    private CardPlayer getNextPlayer() {
        if (this.currentPlayer == null) {
            return this.getPlayers().getFirst();
        }
        int indexOf = this.getPlayers().indexOf(this.currentPlayer);
        return this.getPlayers().get((indexOf + 1) % this.players.size());
    }

    @Override
    public void startGame() {
        this.drawPile.clear();
        this.playPile.clear();
        this.drawPile.addAll(this.gameDeck);
        this.drawPile.shuffle();
        for (Object player : this.players) {
            player.resetPlay();
            this.getPlayerHand((CardPlayer)player).clear();
            this.getCensoredHand((CardPlayer)player).clear();
        }
        for (int i = 0; i < 5; ++i) {
            for (CardPlayer player : this.players) {
                this.scheduledActions.add(() -> {
                    player.playSound((SoundEvent)ModSounds.CARD_DRAW.get());
                    this.dealCards(this.drawPile, player, 1);
                });
                this.scheduledActions.add(() -> {});
            }
        }
        Card last = this.drawPile.removeLast();
        while (last != null && last.rank() == Rank.EIGHT) {
            this.drawPile.add(last);
            this.drawPile.shuffle();
            last = this.drawPile.removeLast();
        }
        assert (last != null);
        last.flip();
        Card startingCard = last;
        this.scheduledActions.add(() -> {
            this.playPile.addLast(startingCard);
            this.currentSuit = startingCard.suit();
        });
        this.currentPlayer = this.getNextPlayer();
        this.isChoosingWild = false;
        this.isGameReady = false;
        this.isGameOver = false;
        this.table((Component)Component.translatable((String)"message.charta.game_started"));
        this.table((Component)Component.translatable((String)"message.charta.its_player_turn", (Object[])new Object[]{this.currentPlayer.getColoredName()}));
    }

    @Override
    public void runGame() {
        if (!this.isGameReady) {
            return;
        }
        if (this.drawPile.isEmpty()) {
            if (this.playPile.size() > 1) {
                Card lastCard = this.playPile.removeLast();
                this.playPile.forEach(Card::flip);
                this.drawPile.addAll(this.playPile);
                this.drawPile.shuffle();
                this.playPile.clear();
                this.playPile.add(lastCard);
                this.table((Component)Component.translatable((String)"message.charta.piles_shuffled"));
            } else {
                this.endGame();
            }
        }
        this.currentPlayer.afterPlay(play -> {
            this.currentPlayer.resetPlay();
            if (play == null) {
                if (this.drawsLeft > 0) {
                    --this.drawsLeft;
                    this.play(this.currentPlayer, (Component)Component.translatable((String)"message.charta.drew_a_card"));
                    if (this.currentPlayer.shouldCompute()) {
                        this.dealCards(this.drawPile, this.currentPlayer, 1);
                        this.currentPlayer.playSound((SoundEvent)ModSounds.CARD_DRAW.get());
                    }
                    if (this.drawsLeft == 0 && this.getBestPlay(this.currentPlayer) == null) {
                        this.nextPlayerAndRunGame();
                    } else {
                        this.runGame();
                    }
                } else {
                    this.nextPlayerAndRunGame();
                }
            } else if (!this.currentPlayer.shouldCompute() || this.canPlay(this.currentPlayer, (CardPlay)play)) {
                Card card = play.cards().getLast();
                this.currentPlayer.playSound((SoundEvent)ModSounds.CARD_PLAY.get());
                this.currentSuit = card.suit();
                if (this.isChoosingWild) {
                    this.play(this.currentPlayer, (Component)Component.translatable((String)"message.charta.chose_a_suit", (Object[])new Object[]{Component.translatable((String)this.deck.getSuitTranslatableKey(this.currentSuit)).withColor(this.deck.getSuitColor(this.currentSuit))}));
                    if (!this.currentPlayer.shouldCompute()) {
                        this.playPile.removeLast();
                    }
                    this.isChoosingWild = false;
                } else {
                    this.play(this.currentPlayer, (Component)Component.translatable((String)"message.charta.played_a_card", (Object[])new Object[]{Component.translatable((String)this.deck.getCardTranslatableKey(card)).withColor(this.deck.getCardColor(card))}));
                }
                if (this.currentPlayer.shouldCompute() && this.getPlayerHand(this.currentPlayer).remove(card)) {
                    this.getCensoredHand(this.currentPlayer).removeLast();
                    this.playPile.addLast(card);
                }
                if (this.getFullHand(this.currentPlayer).findAny().isEmpty()) {
                    this.endGame();
                } else if (card.rank() == Rank.EIGHT) {
                    if (this.currentPlayer.shouldCompute()) {
                        this.currentSuit = this.getMostFrequentSuit(this.currentPlayer);
                        this.play(this.currentPlayer, (Component)Component.translatable((String)"message.charta.chose_a_suit", (Object[])new Object[]{Component.translatable((String)this.deck.getSuitTranslatableKey(this.currentSuit))}));
                        this.nextPlayerAndRunGame();
                    } else {
                        this.isChoosingWild = true;
                        this.suits.clear();
                        this.suits.addAll(this.gameSuits.stream().map(s -> new Card((Suit)s, Rank.EIGHT)).toList());
                        this.drawsLeft = 0;
                        this.runGame();
                    }
                } else {
                    this.nextPlayerAndRunGame();
                }
            }
        });
    }

    public void nextPlayerAndRunGame() {
        this.drawsLeft = (Integer)this.AVAILABLE_DRAWS.get();
        this.currentPlayer = this.getNextPlayer();
        this.table((Component)Component.translatable((String)"message.charta.its_player_turn", (Object[])new Object[]{this.currentPlayer.getColoredName()}));
        this.runGame();
    }

    @Override
    public void endGame() {
        if (this.getFullHand(this.currentPlayer).findAny().isEmpty()) {
            this.currentPlayer.sendTitle((Component)Component.translatable((String)"message.charta.you_won").withStyle(ChatFormatting.GREEN), (Component)Component.translatable((String)"message.charta.congratulations"));
            this.getPlayers().stream().filter(player -> player != this.currentPlayer).forEach(player -> player.sendTitle((Component)Component.translatable((String)"message.charta.you_lost").withStyle(ChatFormatting.RED), (Component)Component.translatable((String)"message.charta.won_the_match", (Object[])new Object[]{this.currentPlayer.getName()})));
        } else {
            this.getPlayers().forEach(player -> {
                player.sendTitle((Component)Component.translatable((String)"message.charta.draw").withStyle(ChatFormatting.YELLOW), (Component)Component.translatable((String)"message.charta.no_winner"));
                player.sendMessage((Component)Component.translatable((String)"message.charta.match_unable").withStyle(ChatFormatting.GOLD));
            });
        }
        this.isGameOver = true;
    }

    @Override
    public boolean canPlay(CardPlayer player, CardPlay play) {
        List<Card> cards = play.cards();
        if (cards.size() != 1) {
            return false;
        }
        Card card = cards.getLast();
        Card lastCard = this.playPile.getLast();
        return this.isGameReady && lastCard != null && (this.isChoosingWild && card.rank() == Rank.EIGHT || card.rank() == Rank.EIGHT || card.rank() == lastCard.rank() || card.suit() == this.currentSuit);
    }
}

