/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game;

import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardPlay;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.DrawSlot;
import dev.lucaargolo.charta.game.GameSlot;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PlaySlot
extends GameSlot {
    private final CardGame<?> game;
    @Nullable
    private final DrawSlot drawSlot;

    public PlaySlot(CardGame<?> game, List<Card> cards, float x, float y, float z, float angle, @Nullable DrawSlot drawSlot) {
        super(cards, x, y, z, angle);
        this.game = game;
        this.drawSlot = drawSlot;
    }

    @Override
    public boolean canInsertCard(CardPlayer player, List<Card> cards, int index) {
        if (this.drawSlot != null && this.drawSlot.isDraw()) {
            player.play(null);
            this.drawSlot.setDraw(false);
        }
        return player == this.game.getCurrentPlayer() && this.game.canPlay(player, new CardPlay(cards, this.getIndex()));
    }

    @Override
    public boolean canRemoveCard(CardPlayer player, int index) {
        return false;
    }

    @Override
    public void onInsert(CardPlayer player, List<Card> cards, int index) {
        player.play(cards, this.getIndex());
    }
}

