/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game;

import dev.lucaargolo.charta.blockentity.CardTableBlockEntity;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.sound.ModSounds;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public class GameSlot {
    private CardTableBlockEntity parent = null;
    private int index = -1;
    private List<Card> cards;
    private float lastX;
    private float x;
    private float lastY;
    private float y;
    private float lastZ;
    private float z;
    private float lastAngle;
    private float angle;
    private Direction stackDirection;
    private float maxStack;
    private boolean centered;
    public int highlightColor = 0xFFFFFF;
    public int highlightTime = 0;

    public GameSlot(List<Card> cards, float x, float y, float z, float angle, Direction stackDirection, float maxStack, boolean centered) {
        this.cards = cards;
        this.x = x;
        this.lastX = x;
        this.y = y;
        this.lastY = y;
        this.z = z;
        this.lastZ = z;
        this.angle = angle;
        this.lastAngle = angle;
        this.stackDirection = stackDirection;
        this.maxStack = maxStack;
        this.centered = centered;
    }

    public GameSlot(List<Card> cards, float x, float y, float z, float angle, Direction stackDirection, float maxStack) {
        this(cards, x, y, z, angle, stackDirection, maxStack, true);
    }

    public GameSlot(List<Card> cards, float x, float y, float z, float angle, Direction stackDirection) {
        this(cards, x, y, z, angle, stackDirection, 80.0f);
    }

    public GameSlot(List<Card> cards, float x, float y, float z, float angle) {
        this(cards, x, y, z, angle, Direction.UP);
    }

    public GameSlot(List<Card> cards) {
        this(cards, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public GameSlot() {
        this(new LinkedList<Card>());
    }

    public boolean removeAll() {
        return true;
    }

    public void onInsert(CardPlayer player, List<Card> cards, int index) {
        player.playSound((SoundEvent)ModSounds.CARD_PLAY.get());
    }

    public void onRemove(CardPlayer player, List<Card> cards, int index) {
        player.playSound((SoundEvent)ModSounds.CARD_DRAW.get());
    }

    public boolean canInsertCard(CardPlayer player, List<Card> cards, int index) {
        return true;
    }

    public boolean canRemoveCard(CardPlayer player, int index) {
        return !this.isEmpty();
    }

    public void setParent(CardTableBlockEntity parent) {
        this.parent = parent;
    }

    public void setDirty(boolean cards) {
        if (this.parent != null) {
            this.parent.setSlotDirty(this.index, cards);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Iterable<Card> getCards() {
        return this.cards;
    }

    public void setCards(List<Card> cards) {
        this.cards = cards;
        this.setDirty(true);
    }

    public float getX() {
        return this.x;
    }

    public float lerpX(float partialTicks) {
        float newX;
        this.lastX = newX = Mth.lerp((float)partialTicks, (float)this.lastX, (float)this.x);
        return newX;
    }

    public void setX(float x) {
        this.x = x;
        this.setDirty(false);
    }

    public float getY() {
        return this.y;
    }

    public float lerpY(float partialTicks) {
        float newY;
        this.lastY = newY = Mth.lerp((float)partialTicks, (float)this.lastY, (float)this.y);
        return newY;
    }

    public void setY(float y) {
        this.y = y;
        this.setDirty(false);
    }

    public float getZ() {
        return this.z;
    }

    public float lerpZ(float partialTicks) {
        float newZ;
        this.lastZ = newZ = Mth.lerp((float)partialTicks, (float)this.lastZ, (float)this.z);
        return newZ;
    }

    public void setZ(float z) {
        this.z = z;
        this.setDirty(false);
    }

    public float getAngle() {
        return this.angle;
    }

    public float lerpAngle(float partialTicks) {
        float newAngle;
        this.lastAngle = newAngle = Mth.lerp((float)partialTicks, (float)this.lastAngle, (float)this.angle);
        return newAngle;
    }

    public void setAngle(float angle) {
        this.angle = angle;
        this.setDirty(false);
    }

    public Direction getStackDirection() {
        return this.stackDirection;
    }

    public void setStackDirection(Direction stackDirection) {
        this.stackDirection = stackDirection;
    }

    public float getMaxStack() {
        return this.maxStack;
    }

    public void setMaxStack(float maxStack) {
        this.maxStack = maxStack;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setCentered(boolean centered) {
        this.centered = centered;
    }

    public boolean isEmpty() {
        return this.cards.isEmpty();
    }

    public int size() {
        return this.cards.size();
    }

    public Card get(int i) {
        return this.cards.get(i);
    }

    public Card getLast() {
        return this.cards.getLast();
    }

    public void add(Card card) {
        this.cards.add(card);
        this.setDirty(true);
    }

    public void addLast(Card card) {
        this.cards.add(card);
        this.setDirty(true);
    }

    public boolean addAll(GameSlot slot) {
        return this.addAll(slot.cards);
    }

    public boolean addAll(Collection<Card> collection) {
        boolean result = this.cards.addAll(collection);
        this.setDirty(true);
        return result;
    }

    public boolean addAll(int i, GameSlot slot) {
        boolean result = this.cards.addAll(i, slot.cards);
        this.setDirty(true);
        return result;
    }

    public Card remove(int i) {
        Card result = this.cards.remove(i);
        this.setDirty(true);
        return result;
    }

    public boolean remove(Card card) {
        boolean result = this.cards.remove(card);
        this.setDirty(true);
        return result;
    }

    public Card removeLast() {
        Card last = this.cards.removeLast();
        this.setDirty(true);
        return last;
    }

    public boolean contains(Card card) {
        return this.cards.contains(card);
    }

    public void clear() {
        this.cards.clear();
        this.setDirty(true);
    }

    public void shuffle() {
        Collections.shuffle(this.cards);
        this.setDirty(true);
    }

    public void reverse() {
        Collections.reverse(this.cards);
        this.setDirty(true);
    }

    public void forEach(Consumer<Card> consumer) {
        this.cards.forEach(consumer);
    }

    public Stream<Card> stream() {
        return this.cards.stream();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GameSlot)) {
            return false;
        }
        return this.cards.equals(((GameSlot)obj).cards);
    }

    public static GameSlot copyOf(GameSlot slot) {
        LinkedList<Card> cards = new LinkedList<Card>();
        for (Card c : slot.cards) {
            cards.add(c.copy());
        }
        return new GameSlot(cards, slot.x, slot.y, slot.z, slot.angle, slot.stackDirection, slot.maxStack);
    }
}

