/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GameOption<T> {
    private final Component title;
    private final Component description;
    @Nullable
    Consumer<T> consumer;
    private byte value;

    public GameOption(T value, Component title, Component description) {
        this.value = this.toByte(value);
        this.title = title;
        this.description = description;
    }

    protected abstract byte toByte(T var1);

    protected abstract T fromByte(byte var1);

    public Component getTitle() {
        return this.title;
    }

    public Component getDescription() {
        return this.description;
    }

    public T get() {
        return this.fromByte(this.value);
    }

    public void set(T value) {
        this.value = this.toByte(value);
        if (this.consumer != null) {
            this.consumer.accept(value);
        }
    }

    public byte getValue() {
        return this.value;
    }

    public void setValue(byte value) {
        this.value = value;
        if (this.consumer != null) {
            this.consumer.accept(this.get());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract Widget getWidget(Consumer<T> var1, Font var2, int var3, int var4, boolean var5);

    public static class Number
    extends GameOption<Integer> {
        private final int min;
        private final int max;

        public Number(int value, int min, int max, Component title, Component description) {
            super(value, title, description);
            this.min = min;
            this.max = max;
        }

        @Override
        protected byte toByte(Integer value) {
            return value.byteValue();
        }

        @Override
        protected Integer fromByte(byte value) {
            return value;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Widget getWidget(Consumer<Integer> consumer, Font font, int width, int height, final boolean showcase) {
            final Function<Integer, Component> message = i -> this.getTitle().copy().append(": ").append(Integer.toString(i));
            AbstractSliderButton slider = new AbstractSliderButton(0, 0, width, height, message.apply((Integer)this.get()), (double)((Integer)this.get()).intValue() * (1.0 / (double)(this.max - this.min))){
                private static final ResourceLocation SLIDER_HANDLE_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_handle");

                @NotNull
                protected ResourceLocation getHandleSprite() {
                    return showcase ? SLIDER_HANDLE_SPRITE : super.getHandleSprite();
                }

                protected void updateMessage() {
                    this.setMessage((Component)message.apply((Integer)this.get()));
                }

                protected void applyValue() {
                    this.set(Mth.floor((double)Mth.lerp((double)this.value, (double)min, (double)max)));
                }

                protected void renderScrollingString(@NotNull GuiGraphics guiGraphics, @NotNull Font font, int width, int color) {
                    super.renderScrollingString(guiGraphics, font, width, 0xFFFFFF | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
                }
            };
            slider.setTooltip(Tooltip.create((Component)this.getDescription()));
            this.consumer = i -> {
                slider.setValue((double)i.intValue() * (1.0 / (double)(this.max - this.min)));
                consumer.accept((Integer)i);
            };
            slider.active = !showcase;
            return new Widget((AbstractWidget)slider);
        }
    }

    public static class Bool
    extends GameOption<Boolean> {
        public Bool(boolean value, Component title, Component description) {
            super(value, title, description);
        }

        @Override
        protected byte toByte(Boolean value) {
            return value != false ? (byte)1 : 0;
        }

        @Override
        protected Boolean fromByte(byte value) {
            return value == 1;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Widget getWidget(Consumer<Boolean> consumer, Font font, int width, int height, boolean showcase) {
            Checkbox.Builder builder = Checkbox.builder((Component)this.getTitle(), (Font)font);
            builder.tooltip(Tooltip.create((Component)this.getDescription()));
            builder.maxWidth(width);
            builder.selected(((Boolean)this.get()).booleanValue());
            builder.onValueChange((checkbox, value) -> this.set(value));
            Checkbox checkbox2 = builder.build();
            this.consumer = b -> {
                if (b.booleanValue() != checkbox2.selected()) {
                    checkbox2.onPress();
                }
                consumer.accept((Boolean)this.get());
            };
            checkbox2.active = !showcase;
            return new Widget((AbstractWidget)checkbox2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Widget
    extends ContainerObjectSelectionList.Entry<Widget> {
        private final AbstractWidget widget;

        public Widget(AbstractWidget widget) {
            this.widget = widget;
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return List.of(this.widget);
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return List.of(this.widget);
        }

        public void render(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.widget.setX(left);
            this.widget.setY(top);
            this.widget.render(guiGraphics, mouseX, mouseY, partialTick);
        }

        @Nullable
        public Tooltip getTooltip() {
            return this.widget.getTooltip();
        }

        public void setTooltip(@Nullable Tooltip tooltip) {
            this.widget.setTooltip(tooltip);
        }
    }
}

