/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.ChartaClient;
import dev.lucaargolo.charta.compat.IrisCompat;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.Rank;
import dev.lucaargolo.charta.game.Suit;
import dev.lucaargolo.charta.game.fun.FunGame;
import dev.lucaargolo.charta.utils.CardImageUtils;
import dev.lucaargolo.charta.utils.ExpandedStreamCodec;
import dev.lucaargolo.charta.utils.SuitImage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.phys.Vec3;

public class Deck {
    public static final Deck EMPTY = new Deck(Rarity.COMMON, false, List.of(), s -> Charta.MISSING_SUIT, s -> "suit.charta.unknown", c -> Charta.MISSING_CARD, c -> "card.charta.unknown", () -> Charta.MISSING_DECK, () -> "deck.charta.unknown");
    public static final StreamCodec<ByteBuf, Deck> STREAM_CODEC = ExpandedStreamCodec.composite(Rarity.STREAM_CODEC, Deck::getRarity, ByteBufCodecs.BOOL, Deck::isTradeable, ByteBufCodecs.collection(ArrayList::new, Card.STREAM_CODEC), Deck::getCards, ByteBufCodecs.map(HashMap::new, Suit.STREAM_CODEC, (StreamCodec)ResourceLocation.STREAM_CODEC), Deck::getSuitsLocation, ByteBufCodecs.map(HashMap::new, Suit.STREAM_CODEC, (StreamCodec)ByteBufCodecs.STRING_UTF8), Deck::getSuitsTranslatableKeys, ByteBufCodecs.map(HashMap::new, Card.STREAM_CODEC, (StreamCodec)ResourceLocation.STREAM_CODEC), Deck::getCardsLocation, ByteBufCodecs.map(HashMap::new, Card.STREAM_CODEC, (StreamCodec)ByteBufCodecs.STRING_UTF8), Deck::getCardsTranslatableKeys, ResourceLocation.STREAM_CODEC, Deck::getDeckLocation, ByteBufCodecs.STRING_UTF8, Deck::getDeckTranslatableKey, (x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8) -> new Deck((Rarity)x$0, (boolean)x$1, (List<Card>)((List)x$2), (Map<Suit, ResourceLocation>)x$3, (Map<Suit, String>)x$4, (Map<Card, ResourceLocation>)x$5, (Map<Card, String>)x$6, (ResourceLocation)x$7, (String)x$8));
    public static final Codec<Deck> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Rarity.CODEC.fieldOf("rarity").forGetter(Deck::getRarity), (App)Codec.BOOL.fieldOf("tradeable").forGetter(Deck::isTradeable), (App)Card.CODEC.listOf().fieldOf("cards").forGetter(Deck::getCards), (App)Codec.unboundedMap(Suit.CODEC, (Codec)ResourceLocation.CODEC).fieldOf("suits_images").forGetter(Deck::getSuitsLocation), (App)Codec.unboundedMap(Suit.CODEC, (Codec)Codec.STRING).fieldOf("suits_keys").forGetter(Deck::getSuitsTranslatableKeys), (App)Codec.unboundedMap(Card.CODEC, (Codec)ResourceLocation.CODEC).fieldOf("cards_images").forGetter(Deck::getCardsLocation), (App)Codec.unboundedMap(Card.CODEC, (Codec)Codec.STRING).fieldOf("cards_keys").forGetter(Deck::getCardsTranslatableKeys), (App)ResourceLocation.CODEC.fieldOf("deck_image").forGetter(Deck::getDeckLocation), (App)Codec.STRING.fieldOf("deck_key").forGetter(Deck::getDeckTranslatableKey)).apply((Applicative)instance, Deck::new));
    private final Rarity rarity;
    private final boolean tradeable;
    private final ImmutableList<Card> cards;
    private final ImmutableSet<Card> uniqueCards;
    private final ImmutableSet<Suit> uniqueSuits;
    private final Function<Suit, ResourceLocation> suitsLocation;
    private final Function<Suit, String> suitsTranslatableKeys;
    private final Function<Card, ResourceLocation> cardsLocation;
    private final Function<Card, String> cardsTranslatableKeys;
    private final Supplier<ResourceLocation> deckLocation;
    private final Supplier<String> deckTranslatableKey;

    private Deck(Rarity rarity, boolean tradeable, List<Card> cards, Map<Suit, ResourceLocation> suitsLocation, Map<Suit, String> suitsTranslatableKey, Map<Card, ResourceLocation> cardsLocation, Map<Card, String> cardsTranslatableKey, ResourceLocation deckLocation, String deckTranslatableKey) {
        this(rarity, tradeable, cards, (Suit suit) -> suitsLocation.getOrDefault(suit, Charta.MISSING_SUIT), (Suit suit) -> suitsTranslatableKey.getOrDefault(suit, "suit.charta.unknown"), (Card card) -> cardsLocation.getOrDefault(card, Charta.MISSING_CARD), (Card card) -> cardsTranslatableKey.getOrDefault(card, "card.charta.unknown"), () -> deckLocation, () -> deckTranslatableKey);
    }

    public Deck(Rarity rarity, boolean tradeable, List<Card> cards, Function<Suit, ResourceLocation> suitsLocation, Function<Suit, String> suitsTranslatableKey, Function<Card, ResourceLocation> cardsLocation, Function<Card, String> cardsTranslatableKey, Supplier<ResourceLocation> deckLocation, Supplier<String> deckTranslatableKey) {
        this.rarity = rarity;
        this.tradeable = tradeable;
        this.cards = ImmutableList.copyOf(cards);
        this.uniqueCards = ImmutableSet.copyOf(cards);
        this.uniqueSuits = ImmutableSet.copyOf(cards.stream().map(Card::suit).iterator());
        this.suitsLocation = suitsLocation;
        this.suitsTranslatableKeys = suitsTranslatableKey;
        this.cardsLocation = cardsLocation;
        this.cardsTranslatableKeys = cardsTranslatableKey;
        this.deckLocation = deckLocation;
        this.deckTranslatableKey = deckTranslatableKey;
    }

    public Component getName() {
        return Component.translatable((String)this.deckTranslatableKey.get());
    }

    public ResourceLocation getSuitTexture(Suit suit, boolean glow) {
        if (glow && IrisCompat.isPresent()) {
            return IrisCompat.getSuitGlowTexture(this.suitsLocation.apply(suit));
        }
        return ChartaClient.getSuitTexture(this.suitsLocation.apply(suit));
    }

    public String getSuitTranslatableKey(Suit suit) {
        return this.suitsTranslatableKeys.apply(suit);
    }

    public ResourceLocation getCardTexture(Card card, boolean glow) {
        if (glow && IrisCompat.isPresent()) {
            return IrisCompat.getCardGlowTexture(this.cardsLocation.apply(card));
        }
        return ChartaClient.getCardTexture(this.cardsLocation.apply(card));
    }

    public String getCardTranslatableKey(Card card) {
        return this.cardsTranslatableKeys.apply(card);
    }

    public ResourceLocation getDeckTexture(boolean glow) {
        if (glow && IrisCompat.isPresent()) {
            return IrisCompat.getDeckGlowTexture(this.deckLocation.get());
        }
        return ChartaClient.getDeckTexture(this.deckLocation.get());
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public boolean isTradeable() {
        return this.tradeable;
    }

    public ImmutableList<Card> getCards() {
        return this.cards;
    }

    public ImmutableSet<Card> getUniqueCards() {
        return this.uniqueCards;
    }

    public ImmutableSet<Suit> getUniqueSuits() {
        return this.uniqueSuits;
    }

    private Map<Suit, ResourceLocation> getSuitsLocation() {
        return Maps.asMap(this.uniqueSuits, this.suitsLocation::apply);
    }

    private Map<Suit, String> getSuitsTranslatableKeys() {
        return Maps.asMap(this.uniqueSuits, this.suitsTranslatableKeys::apply);
    }

    private Map<Card, ResourceLocation> getCardsLocation() {
        return Maps.asMap(this.uniqueCards, this.cardsLocation::apply);
    }

    private Map<Card, String> getCardsTranslatableKeys() {
        return Maps.asMap(this.uniqueCards, this.cardsTranslatableKeys::apply);
    }

    public ResourceLocation getDeckLocation() {
        return this.deckLocation.get();
    }

    public String getDeckTranslatableKey() {
        return this.deckTranslatableKey.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Deck deck = (Deck)o;
        return this.rarity == deck.rarity && Objects.equals(this.cards, deck.cards) && Objects.equals(this.getSuitsLocation(), deck.getSuitsLocation()) && Objects.equals(this.getSuitsTranslatableKeys(), deck.getSuitsTranslatableKeys()) && Objects.equals(this.getCardsLocation(), deck.getCardsLocation()) && Objects.equals(this.getCardsTranslatableKeys(), deck.getCardsTranslatableKeys()) && Objects.equals(this.deckLocation.get(), deck.deckLocation.get()) && Objects.equals(this.deckTranslatableKey.get(), deck.deckTranslatableKey.get());
    }

    public int hashCode() {
        return Objects.hash(this.rarity, this.cards, this.getSuitsLocation(), this.getSuitsTranslatableKeys(), this.getCardsLocation(), this.getCardsTranslatableKeys(), this.deckLocation.get(), this.deckTranslatableKey.get());
    }

    public static Deck simple(Rarity rarity, boolean canBeTraded, ResourceLocation cardLocation, ResourceLocation deckLocation) {
        return Deck.simple(rarity, canBeTraded, cardLocation, cardLocation, deckLocation);
    }

    public static Deck simple(Rarity rarity, boolean canBeTraded, ResourceLocation suitLocation, ResourceLocation cardLocation, ResourceLocation deckLocation) {
        ArrayList<Card> deck = new ArrayList<Card>();
        for (Suit suit2 : Charta.DEFAULT_SUITS) {
            for (Rank rank : Charta.DEFAULT_RANKS) {
                deck.add(new Card(suit2, rank));
            }
        }
        String translatableKey = "deck." + deckLocation.getNamespace() + "." + cardLocation.getPath().replace("/", ".");
        if (!cardLocation.getPath().equals(deckLocation.getPath())) {
            translatableKey = "deck." + deckLocation.getNamespace() + "." + deckLocation.getPath().replace("/", ".");
        }
        String deckTranslatableKey = translatableKey;
        return new Deck(rarity, canBeTraded, deck, suit -> suitLocation.withSuffix("/" + suit.location().getPath()), suit -> "suit.charta." + suit.location().getPath(), card -> cardLocation.withSuffix("/" + card.suit().location().getPath() + "_" + card.rank().location().getPath()), card -> "card.charta." + card.suit().location().getPath() + "." + card.rank().location().getPath(), () -> deckLocation, () -> deckTranslatableKey);
    }

    public static Deck fun(Rarity rarity, boolean canBeTraded, ResourceLocation cardLocation, ResourceLocation deckLocation) {
        return Deck.fun(rarity, canBeTraded, cardLocation, cardLocation, deckLocation);
    }

    public static Deck fun(Rarity rarity, boolean canBeTraded, ResourceLocation suitLocation, ResourceLocation cardLocation, ResourceLocation deckLocation) {
        ArrayList<Card> deck = new ArrayList<Card>();
        for (Suit suit2 : FunGame.SUITS) {
            for (Rank rank : FunGame.RANKS) {
                deck.add(new Card(suit2, rank));
                if (rank == Rank.WILD || rank == Rank.WILD_PLUS_4 || rank == Rank.ZERO) continue;
                deck.add(new Card(suit2, rank));
            }
        }
        String translatableKey = "deck." + deckLocation.getNamespace() + "." + cardLocation.getPath().replace("/", ".");
        if (!cardLocation.getPath().equals(deckLocation.getPath())) {
            translatableKey = "deck." + deckLocation.getNamespace() + "." + deckLocation.getPath().replace("/", ".");
        }
        String deckTranslatableKey = translatableKey;
        return new Deck(rarity, canBeTraded, deck, suit -> suitLocation.withSuffix("/" + suit.location().getPath()), suit -> "suit.charta." + suit.location().getPath(), card -> cardLocation.withSuffix("/" + card.suit().location().getPath() + "_" + card.rank().location().getPath()), card -> card.rank() == Rank.WILD || card.rank() == Rank.WILD_PLUS_4 ? "card.charta." + card.rank().location().getPath() : "card.charta." + card.suit().location().getPath() + "." + card.rank().location().getPath(), () -> deckLocation, () -> deckTranslatableKey);
    }

    public int getCardColor(Card card) {
        return this.getSuitColor(card.suit());
    }

    public int getSuitColor(Suit suit) {
        SuitImage image = Charta.SUIT_IMAGES.getImages().getOrDefault(this.suitsLocation.apply(suit), CardImageUtils.EMPTY_SUIT);
        if (image == CardImageUtils.EMPTY_SUIT) {
            return 0xFFFFFF;
        }
        int color = image.getAverageColor();
        Vec3 col = Vec3.fromRGB24((int)color);
        double brightness = 0.299 * col.x + 0.587 * col.y + 0.114 * col.z;
        if (brightness < 0.5) {
            double factor = 637.5;
            int r = Math.min(255, (int)(col.x * factor));
            int g = Math.min(255, (int)(col.y * factor));
            int b = Math.min(255, (int)(col.z * factor));
            return r << 16 | g << 8 | b;
        }
        return color;
    }
}

