/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game;

import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardPlay;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.utils.CardPlayerHead;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.Nullable;

public interface CardPlayer {
    public LinkedList<Card> hand();

    public void play(CardPlay var1);

    public void afterPlay(Consumer<CardPlay> var1);

    public void resetPlay();

    public void tick(CardGame<?> var1);

    public boolean shouldCompute();

    public void openScreen(CardGame<?> var1, BlockPos var2, Deck var3);

    public void sendMessage(Component var1);

    public void sendTitle(Component var1, @Nullable Component var2);

    public Component getName();

    default public Component getColoredName() {
        return this.getName().copy().withColor(this.getColor().getTextureDiffuseColor());
    }

    public DyeColor getColor();

    public int getId();

    default public void play(List<Card> cards, int slot) {
        this.play(new CardPlay(cards, slot));
    }

    @Nullable
    default public LivingEntity getEntity() {
        return null;
    }

    default public CardPlayerHead getHead() {
        return CardPlayerHead.UNKNOWN;
    }

    default public void playSound(SoundEvent sound) {
        LivingEntity entity = this.getEntity();
        if (entity != null) {
            entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), sound, SoundSource.PLAYERS, 1.0f, entity.getRandom().nextFloat() * 0.5f + 0.7f);
        }
    }
}

