/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.blockentity.CardTableBlockEntity;
import dev.lucaargolo.charta.blockentity.ModBlockEntityTypes;
import dev.lucaargolo.charta.game.AutoPlayer;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.game.GameOption;
import dev.lucaargolo.charta.game.crazyeights.CrazyEightsGame;
import dev.lucaargolo.charta.game.fun.FunGame;
import dev.lucaargolo.charta.game.solitaire.SolitaireGame;
import dev.lucaargolo.charta.mixed.LivingEntityMixed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public class CardGames {
    private static final Map<ResourceLocation, Factory<?>> factories = new HashMap();
    public static final Factory<CrazyEightsGame> CRAZY_EIGHTS = CardGames.register(Charta.id("crazy_eights"), CrazyEightsGame::new);
    public static final Factory<FunGame> FUN = CardGames.register(Charta.id("fun"), FunGame::new);
    public static final Factory<SolitaireGame> SOLITAIRE = CardGames.register(Charta.id("solitaire"), SolitaireGame::new);

    public static <G extends CardGame<G>> Factory<G> register(ResourceLocation location, Factory<G> factory) {
        if (factories.containsKey(location)) {
            throw new IllegalArgumentException("Duplicate key: " + String.valueOf(location));
        }
        factories.put(location, factory);
        return factory;
    }

    public static Map<ResourceLocation, Factory<?>> getGames() {
        return factories;
    }

    @Nullable
    public static Factory<?> getGame(ResourceLocation gameId) {
        return factories.get(gameId);
    }

    public static ResourceLocation getGameId(Factory<?> factory) {
        return factories.entrySet().stream().filter(entry -> entry.getValue() == factory).map(Map.Entry::getKey).findFirst().orElse(Charta.MISSING_GAME);
    }

    public static <G extends CardGame<G>> G getGameForMenu(Factory<G> factory, ContainerLevelAccess access, Deck deck, int[] players, byte[] options) {
        try {
            return (G)access.evaluate((level, pos) -> (CardTableBlockEntity)((Object)((Object)level.getBlockEntity(pos, (BlockEntityType)ModBlockEntityTypes.CARD_TABLE.get()).get()))).map(table -> table.getGame()).get();
        }
        catch (Exception e) {
            ArrayList<CardPlayer> cardPlayers = new ArrayList<CardPlayer>();
            for (int entityId : players) {
                CardPlayer player = access.evaluate((level, pos) -> {
                    Entity entity;
                    if (entityId >= 0 && (entity = level.getEntity(entityId)) instanceof LivingEntityMixed) {
                        LivingEntityMixed mixed = (LivingEntityMixed)entity;
                        return mixed.charta_getCardPlayer();
                    }
                    return new AutoPlayer(1.0f);
                }).orElse(new AutoPlayer(1.0f));
                cardPlayers.add(player);
            }
            G game = factory.create(cardPlayers, deck);
            ((CardGame)game).setRawOptions(options);
            return game;
        }
    }

    public static <G extends CardGame<G>> boolean areOptionsChanged(Factory<G> factory, G game) {
        G defaultGame = factory.create(List.of(), Deck.EMPTY);
        for (int i = 0; i < ((CardGame)defaultGame).getOptions().size(); ++i) {
            GameOption<?> defaultOption = ((CardGame)defaultGame).getOptions().get(i);
            GameOption<?> modifiedOption = game.getOptions().get(i);
            if (modifiedOption.getValue() == defaultOption.getValue()) continue;
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface Factory<G extends CardGame<G>> {
        public G create(List<CardPlayer> var1, Deck var2);
    }
}

