/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game;

import com.mojang.datafixers.util.Either;
import dev.lucaargolo.charta.game.AutoPlayer;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardPlay;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.game.GameOption;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.game.Suit;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import dev.lucaargolo.charta.network.CardPlayPayload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public abstract class CardGame<G extends CardGame<G>> {
    public static CardPlayer TABLE = new AutoPlayer(0.0f){

        @Override
        public Component getName() {
            return Component.empty();
        }
    };
    protected final Map<CardPlayer, GameSlot> hands = new HashMap<CardPlayer, GameSlot>();
    protected final Map<CardPlayer, GameSlot> censoredHands = new HashMap<CardPlayer, GameSlot>();
    protected final List<Runnable> scheduledActions = new ArrayList<Runnable>();
    private final List<GameSlot> gameSlots = new ArrayList<GameSlot>();
    protected final List<CardPlayer> players;
    protected final Deck deck;
    protected final List<Card> gameDeck;
    protected final Set<Suit> gameSuits;
    protected CardPlayer currentPlayer;
    protected boolean isGameReady;
    protected boolean isGameOver;

    public CardGame(List<CardPlayer> players, Deck deck) {
        this.players = players;
        this.deck = deck;
        this.gameDeck = deck.getCards().stream().filter(c -> this.getCardPredicate().test((Card)c)).map(Card::copy).collect(Collectors.toList());
        this.gameDeck.forEach(Card::flip);
        this.gameSuits = this.gameDeck.stream().map(Card::suit).collect(Collectors.toSet());
    }

    public abstract AbstractCardMenu<G> createMenu(int var1, Inventory var2, ServerLevel var3, BlockPos var4, Deck var5);

    public abstract Predicate<Deck> getDeckPredicate();

    public abstract Predicate<Card> getCardPredicate();

    public Either<CardGame<?>, Component> playerPredicate(List<CardPlayer> players) {
        return Either.left((Object)this);
    }

    public abstract boolean canPlay(CardPlayer var1, CardPlay var2);

    public abstract void startGame();

    public abstract void runGame();

    public abstract void endGame();

    public abstract List<GameOption<?>> getOptions();

    public void preUpdate() {
    }

    public void postUpdate() {
    }

    public final byte[] getRawOptions() {
        List<GameOption<?>> options = this.getOptions();
        byte[] byteArray = new byte[options.size()];
        for (int i = 0; i < options.size(); ++i) {
            byteArray[i] = options.get(i).getValue();
        }
        return byteArray;
    }

    public void setRawOptions(byte[] options) {
        List<GameOption<?>> o = this.getOptions();
        for (int i = 0; i < o.size(); ++i) {
            if (i >= options.length) continue;
            o.get(i).setValue(options[i]);
        }
    }

    public List<CardPlayer> getPlayers() {
        return this.players;
    }

    public List<GameSlot> getSlots() {
        return this.gameSlots;
    }

    public GameSlot getSlot(int index) {
        return this.gameSlots.get(index);
    }

    protected <S extends GameSlot> S addSlot(S slot) {
        slot.setIndex(this.gameSlots.size());
        this.gameSlots.add(slot);
        return slot;
    }

    public boolean isGameReady() {
        return this.isGameReady;
    }

    public boolean isGameOver() {
        return this.isGameOver;
    }

    protected GameSlot createPlayerHand(CardPlayer player) {
        return new GameSlot(player.hand());
    }

    public GameSlot getPlayerHand(CardPlayer player) {
        return this.hands.computeIfAbsent(player, this::createPlayerHand);
    }

    protected GameSlot createCensoredHand(CardPlayer player) {
        LinkedList list = new LinkedList();
        this.getPlayerHand(player).stream().map(c -> Card.BLANK).forEach(list::add);
        return new GameSlot(this, list){

            @Override
            public boolean canInsertCard(CardPlayer player, List<Card> cards, int index) {
                return false;
            }

            @Override
            public boolean canRemoveCard(CardPlayer player, int index) {
                return false;
            }
        };
    }

    public GameSlot getCensoredHand(@Nullable CardPlayer viewer, CardPlayer player) {
        if (viewer == player && player.getEntity() instanceof ServerPlayer) {
            return this.hands.getOrDefault(player, new GameSlot());
        }
        return this.censoredHands.computeIfAbsent(player, this::createCensoredHand);
    }

    public GameSlot getCensoredHand(CardPlayer player) {
        return this.getCensoredHand(null, player);
    }

    public CardPlayer getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void setCurrentPlayer(int index) {
        this.currentPlayer = this.getPlayers().get(index);
    }

    protected Stream<Card> getFullHand(CardPlayer player) {
        LivingEntity entity = player.getEntity();
        if (entity instanceof ServerPlayer) {
            AbstractCardMenu menu;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
            if (abstractContainerMenu instanceof AbstractCardMenu && !(menu = (AbstractCardMenu)abstractContainerMenu).getCarriedCards().isEmpty()) {
                return Stream.concat(this.getPlayerHand(player).stream(), menu.getCarriedCards().stream());
            }
        }
        return this.getPlayerHand(player).stream();
    }

    protected Suit getMostFrequentSuit(CardPlayer player) {
        HashMap<Suit, Integer> suitCountMap = new HashMap<Suit, Integer>();
        for (Card c : this.getPlayerHand(player).getCards()) {
            Suit suit = c.suit();
            suitCountMap.put(suit, suitCountMap.getOrDefault(suit, 0) + 1);
        }
        Suit mostFrequentSuit = null;
        int maxCount = 0;
        for (Map.Entry entry : suitCountMap.entrySet()) {
            if ((Integer)entry.getValue() <= maxCount) continue;
            mostFrequentSuit = (Suit)entry.getKey();
            maxCount = (Integer)entry.getValue();
        }
        return mostFrequentSuit;
    }

    @Nullable
    public CardPlay getBestPlay(CardPlayer player) {
        int i = 0;
        while (i < this.gameSlots.size()) {
            int slot = i++;
            Optional<Card> card = this.getFullHand(player).filter(c -> this.canPlay(player, new CardPlay(List.of(c), slot))).findFirst();
            if (!card.isPresent()) continue;
            return new CardPlay(List.of(card.get()), slot);
        }
        return null;
    }

    public void openScreen(ServerPlayer serverPlayer, final ServerLevel level, final BlockPos pos, final Deck deck) {
        serverPlayer.openMenu(new MenuProvider(){

            @NotNull
            public Component getDisplayName() {
                return Component.empty();
            }

            @NotNull
            public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
                return CardGame.this.createMenu(containerId, playerInventory, level, pos, deck);
            }
        }, buf -> {
            buf.writeBlockPos(pos);
            Deck.STREAM_CODEC.encode(buf, (Object)deck);
            buf.writeVarIntArray(this.getPlayers().stream().mapToInt(CardPlayer::getId).toArray());
            buf.writeByteArray(this.getRawOptions());
        });
    }

    public void tick() {
        if (!this.isGameReady) {
            if (!this.scheduledActions.isEmpty()) {
                this.scheduledActions.removeFirst().run();
            } else {
                this.isGameReady = true;
                this.runGame();
            }
        } else {
            this.getPlayers().forEach(p -> p.tick(this));
        }
    }

    public int getMinPlayers() {
        return 2;
    }

    public int getMaxPlayers() {
        return 8;
    }

    protected void dealCards(GameSlot drawSlot, CardPlayer player, int count) {
        for (int i = 0; i < count; ++i) {
            Card card = drawSlot.removeLast();
            card.flip();
            this.getPlayerHand(player).add(card);
            this.getCensoredHand(player).add(Card.BLANK);
        }
    }

    protected void table(Component play) {
        this.play(TABLE, (Component)play.copy().withStyle(ChatFormatting.GRAY));
    }

    protected void play(CardPlayer player, Component play) {
        for (CardPlayer p : this.getPlayers()) {
            LivingEntity entity = p.getEntity();
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new CardPlayPayload((Component)(player.getName().equals((Object)Component.empty()) ? Component.empty() : player.getColoredName()), this.getPlayerHand(player).size(), play), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static boolean isValidDeck(CardGame<?> cardGame, Deck deck) {
        return cardGame.getDeckPredicate().test(deck);
    }
}

