/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.lucaargolo.charta.game.Rank;
import dev.lucaargolo.charta.game.Suit;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class Card
implements Comparable<Card> {
    public static final Codec<Card> CODEC = Codec.STRING.comapFlatMap(card -> {
        String[] elements = card.split("_");
        try {
            ResourceLocation suit = ResourceLocation.parse((String)elements[0]);
            ResourceLocation rank = elements[1].contains(":") ? ResourceLocation.parse((String)elements[1]) : ResourceLocation.fromNamespaceAndPath((String)suit.getNamespace(), (String)elements[1]);
            return DataResult.success((Object)new Card((Suit)Suit.load(suit).getOrThrow(), (Rank)Rank.load(rank).getOrThrow()));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Invalid card format: " + card);
        }
    }, Card::toString);
    public static final StreamCodec<ByteBuf, Card> STREAM_CODEC = StreamCodec.composite(Suit.STREAM_CODEC, Card::suit, Rank.STREAM_CODEC, Card::rank, (StreamCodec)ByteBufCodecs.BOOL, Card::flipped, Card::new);
    public static final Card BLANK = new Card(Suit.BLANK, Rank.BLANK, true);
    private final Suit suit;
    private final Rank rank;
    private boolean flipped;

    public Card(Suit suit, Rank rank) {
        this(suit, rank, false);
    }

    public Card(Suit suit, Rank rank, boolean flipped) {
        this.suit = suit;
        this.rank = rank;
        this.flipped = flipped;
    }

    public Suit suit() {
        return this.suit;
    }

    public Rank rank() {
        return this.rank;
    }

    public boolean flipped() {
        return this.flipped;
    }

    public void flip() {
        this.flipped = !this.flipped;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Card card = (Card)obj;
        return this.flipped == card.flipped && this.suit.equals(card.suit) && this.rank.equals(card.rank);
    }

    public int hashCode() {
        return Objects.hash(this.suit, this.rank, this.flipped);
    }

    @Override
    public int compareTo(Card other) {
        int suitComparison = this.suit.compareTo(other.suit);
        if (suitComparison != 0) {
            return suitComparison;
        }
        return this.rank.compareTo(other.rank);
    }

    public String toString() {
        if (this.suit.location().getNamespace().equals(this.rank.location().getNamespace())) {
            String namespace = this.suit.location().getNamespace();
            return namespace + ":" + this.suit.location().getPath() + "_" + this.rank.location().getPath();
        }
        return String.valueOf(this.suit) + "_" + String.valueOf(this.rank);
    }

    public Card copy() {
        return new Card(this.suit, this.rank, this.flipped);
    }
}

