/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.entity;

import dev.lucaargolo.charta.block.GameChairBlock;
import dev.lucaargolo.charta.block.SeatBlock;
import dev.lucaargolo.charta.entity.ModEntityTypes;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SeatEntity
extends Entity {
    public SeatEntity(EntityType<SeatEntity> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
    }

    public SeatEntity(Level level, BlockPos pos) {
        this((EntityType<SeatEntity>)((EntityType)ModEntityTypes.SEAT.get()), level);
        this.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.001, (double)pos.getZ() + 0.5);
    }

    public void tick() {
        boolean canSit;
        Block block;
        if (this.level().isClientSide) {
            return;
        }
        BlockState state = this.level().getBlockState(this.blockPosition());
        if (state.getBlock() instanceof GameChairBlock) {
            for (Entity entity : this.getPassengers()) {
                if (entity instanceof Player) continue;
                Direction facing = (Direction)state.getValue((Property)GameChairBlock.FACING);
                entity.lookAt(EntityAnchorArgument.Anchor.EYES, entity.getEyePosition().add(Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).multiply(2.0, 2.0, 2.0)));
            }
        }
        if ((block = state.getBlock()) instanceof SeatBlock) {
            SeatBlock seatBlock = (SeatBlock)block;
            canSit = seatBlock.isSittable(state);
        } else {
            canSit = false;
        }
        if (this.isVehicle() && canSit) {
            return;
        }
        this.discard();
        this.level().updateNeighbourForOutputSignal(this.blockPosition(), this.level().getBlockState(this.blockPosition()).getBlock());
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
    }

    @NotNull
    public Vec3 getPassengerRidingPosition(@NotNull Entity entity) {
        return this.position().add(new Vec3(0.0, this.getPassengersRidingOffset(), 0.0));
    }

    public double getPassengersRidingOffset() {
        List passengers = this.getPassengers();
        if (passengers.isEmpty()) {
            return 0.0;
        }
        double seatHeight = 0.0;
        BlockState state = this.level().getBlockState(this.blockPosition());
        Block block = state.getBlock();
        if (block instanceof SeatBlock) {
            SeatBlock seatBlock = (SeatBlock)block;
            seatHeight = seatBlock.seatHeight(state);
        }
        return seatHeight + SeatEntity.getEntitySeatOffset((Entity)passengers.getFirst());
    }

    public static double getEntitySeatOffset(Entity entity) {
        if (entity instanceof Slime) {
            return 0.25;
        }
        if (entity instanceof Parrot) {
            return 0.0625;
        }
        if (entity instanceof Skeleton) {
            return 0.125;
        }
        if (entity instanceof Creeper) {
            return 0.25;
        }
        if (entity instanceof Cat) {
            return 0.125;
        }
        if (entity instanceof Wolf) {
            return 0.0625;
        }
        return 0.0;
    }

    protected boolean canRide(@NotNull Entity entity) {
        return true;
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(@NotNull LivingEntity entity) {
        Direction[] offsets;
        Vec3 safeVec;
        BlockPos pos = this.blockPosition();
        BlockState state = this.level().getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof SeatBlock) {
            SeatBlock seatBlock = (SeatBlock)block;
            safeVec = DismountHelper.findSafeDismountLocation((EntityType)entity.getType(), (CollisionGetter)this.level(), (BlockPos)seatBlock.primaryDismountLocation(this.level(), state, pos), (boolean)false);
            if (safeVec != null) {
                return safeVec.add(0.0, 0.25, 0.0);
            }
        }
        Direction original = this.getDirection();
        for (Direction dir : offsets = new Direction[]{original, original.getClockWise(), original.getCounterClockWise(), original.getOpposite()}) {
            safeVec = DismountHelper.findSafeDismountLocation((EntityType)entity.getType(), (CollisionGetter)this.level(), (BlockPos)pos.relative(dir), (boolean)false);
            if (safeVec == null) continue;
            return safeVec.add(0.0, 0.25, 0.0);
        }
        return super.getDismountLocationForPassenger(entity);
    }

    protected void addPassenger(@NotNull Entity passenger) {
        BlockPos pos = this.blockPosition();
        BlockState state = this.level().getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof SeatBlock) {
            SeatBlock seatBlock = (SeatBlock)block;
            passenger.setYRot(seatBlock.setRiderRotation(state, passenger));
        }
        super.addPassenger(passenger);
    }

    protected void removePassenger(@NotNull Entity entity) {
        super.removePassenger(entity);
        if (entity instanceof TamableAnimal) {
            TamableAnimal ta = (TamableAnimal)entity;
            ta.setInSittingPose(false);
        }
    }
}

