/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.entity;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.block.BeerGlassBlock;
import dev.lucaargolo.charta.block.ModBlocks;
import dev.lucaargolo.charta.block.WineGlassBlock;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.item.DeckItem;
import dev.lucaargolo.charta.item.ModItems;
import java.util.List;
import java.util.Map;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.BasicItemListing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModItemListings {
    public static final VillagerTrades.ItemListing DRINKS = new VillagerTrades.ItemListing(){

        @Nullable
        public MerchantOffer getOffer(@NotNull Entity trader, @NotNull RandomSource random) {
            if (trader instanceof VillagerDataHolder) {
                VillagerDataHolder villagerdataholder = (VillagerDataHolder)trader;
                VillagerType type = villagerdataholder.getVillagerData().getType();
                if (type == VillagerType.DESERT) {
                    return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 2 + random.nextInt(7)), ((WineGlassBlock)((Object)ModBlocks.CACTUS_WINE_GLASS.get())).asItem().getDefaultInstance(), 32, 12, 1.0f);
                }
                if (type == VillagerType.SAVANNA) {
                    return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 2 + random.nextInt(7)), ((BeerGlassBlock)((Object)ModBlocks.SORGHUM_BEER_GLASS.get())).asItem().getDefaultInstance(), 32, 12, 1.0f);
                }
                if (type == VillagerType.TAIGA) {
                    return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 2 + random.nextInt(7)), ((WineGlassBlock)((Object)ModBlocks.BERRY_WINE_GLASS.get())).asItem().getDefaultInstance(), 32, 12, 1.0f);
                }
                return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 2 + random.nextInt(7)), ((BeerGlassBlock)((Object)ModBlocks.WHEAT_BEER_GLASS.get())).asItem().getDefaultInstance(), 32, 12, 1.0f);
            }
            return null;
        }
    };
    public static final VillagerTrades.ItemListing COMMON_DECKS = ModItemListings.getDecksByRarity(Rarity.COMMON);
    public static final VillagerTrades.ItemListing UNCOMMON_DECKS = ModItemListings.getDecksByRarity(Rarity.UNCOMMON);
    public static final VillagerTrades.ItemListing RARE_DECKS = ModItemListings.getDecksByRarity(Rarity.RARE);
    public static final VillagerTrades.ItemListing EPIC_DECKS = ModItemListings.getDecksByRarity(Rarity.EPIC);
    public static final VillagerTrades.ItemListing IRON_LEAD = new BasicItemListing(32, ((LeadItem)ModItems.IRON_LEAD.get()).getDefaultInstance(), 4, 50);

    private static VillagerTrades.ItemListing getDecksByRarity(Rarity rarity) {
        return (trader, random) -> {
            List<ItemStack> decks = Charta.CARD_DECKS.getDecks().entrySet().stream().filter(c -> ((Deck)c.getValue()).isTradeable() && ((Deck)c.getValue()).getRarity() == rarity).map(Map.Entry::getKey).map(DeckItem::getDeck).toList();
            return decks.isEmpty() ? null : new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, (6 + random.nextInt(11)) * (rarity.ordinal() + 1)), decks.get(random.nextInt(decks.size())), 4, 25, 1.0f);
        };
    }
}

