/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.datagen;

import dev.lucaargolo.charta.block.ModBlocks;
import dev.lucaargolo.charta.item.ModItems;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class ModRecipeProvider
extends RecipeProvider {
    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(@NotNull RecipeOutput recipeOutput, @NotNull HolderLookup.Provider holderLookup) {
        HolderLookup.RegistryLookup itemLookup = holderLookup.lookupOrThrow(Registries.ITEM);
        ModBlocks.CARD_TABLE_MAP.forEach((woodType, holder) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)holder.get()), (int)1).pattern("PSP").pattern("L L").define(Character.valueOf('P'), this.getPlanks((WoodType)woodType, (HolderLookup.RegistryLookup<Item>)itemLookup)).define(Character.valueOf('S'), this.getSlab((WoodType)woodType, (HolderLookup.RegistryLookup<Item>)itemLookup)).define(Character.valueOf('L'), this.getLog((WoodType)woodType, (HolderLookup.RegistryLookup<Item>)itemLookup)).unlockedBy("has_wood", ModRecipeProvider.has((ItemLike)this.getLog((WoodType)woodType, (HolderLookup.RegistryLookup<Item>)itemLookup))).save(recipeOutput));
        ModBlocks.GAME_CHAIR_MAP.forEach((woodType, holder) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)holder.get()), (int)1).pattern("P ").pattern("PS").pattern("LL").define(Character.valueOf('P'), this.getPlanks((WoodType)woodType, (HolderLookup.RegistryLookup<Item>)itemLookup)).define(Character.valueOf('S'), this.getSlab((WoodType)woodType, (HolderLookup.RegistryLookup<Item>)itemLookup)).define(Character.valueOf('L'), this.getLog((WoodType)woodType, (HolderLookup.RegistryLookup<Item>)itemLookup)).unlockedBy("has_wood", ModRecipeProvider.has((ItemLike)this.getLog((WoodType)woodType, (HolderLookup.RegistryLookup<Item>)itemLookup))).save(recipeOutput));
        ModBlocks.BAR_STOOL_MAP.forEach((woodType, holder) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)holder.get()), (int)1).pattern("SLS").pattern(" P ").define(Character.valueOf('P'), this.getPlanks((WoodType)woodType, (HolderLookup.RegistryLookup<Item>)itemLookup)).define(Character.valueOf('S'), this.getSlab((WoodType)woodType, (HolderLookup.RegistryLookup<Item>)itemLookup)).define(Character.valueOf('L'), this.getLog((WoodType)woodType, (HolderLookup.RegistryLookup<Item>)itemLookup)).unlockedBy("has_wood", ModRecipeProvider.has((ItemLike)this.getLog((WoodType)woodType, (HolderLookup.RegistryLookup<Item>)itemLookup))).save(recipeOutput));
        ModBlocks.BAR_SHELF_MAP.forEach((woodType, holder) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)holder.get()), (int)1).pattern("SLS").pattern("SLS").define(Character.valueOf('S'), this.getSlab((WoodType)woodType, (HolderLookup.RegistryLookup<Item>)itemLookup)).define(Character.valueOf('L'), this.getLog((WoodType)woodType, (HolderLookup.RegistryLookup<Item>)itemLookup)).unlockedBy("has_wood", ModRecipeProvider.has((ItemLike)this.getLog((WoodType)woodType, (HolderLookup.RegistryLookup<Item>)itemLookup))).save(recipeOutput));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.IRON_LEAD.get()), (int)1).pattern(" I ").pattern("ILI").pattern(" I ").define(Character.valueOf('I'), Tags.Items.NUGGETS_IRON).define(Character.valueOf('L'), (ItemLike)Items.LEAD).unlockedBy("has_lead", ModRecipeProvider.has((ItemLike)Items.LEAD)).save(recipeOutput);
    }

    private ItemLike getPlanks(WoodType woodType, HolderLookup.RegistryLookup<Item> itemLookup) {
        String wood = woodType.name();
        ResourceKey planksResource = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)(wood + "_planks")));
        return (ItemLike)((Holder.Reference)itemLookup.get(planksResource).orElseThrow()).value();
    }

    private ItemLike getSlab(WoodType woodType, HolderLookup.RegistryLookup<Item> itemLookup) {
        String wood = woodType.name();
        ResourceKey planksResource = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)(wood + "_slab")));
        return (ItemLike)((Holder.Reference)itemLookup.get(planksResource).orElseThrow()).value();
    }

    private ItemLike getLog(WoodType woodType, HolderLookup.RegistryLookup<Item> itemLookup) {
        String wood = woodType.name();
        ResourceKey logResource = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)(wood + "_log")));
        if (itemLookup.get(logResource).isEmpty() && itemLookup.get(logResource = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)(wood + "_stem")))).isEmpty()) {
            logResource = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)wood));
        }
        return (ItemLike)((Holder.Reference)itemLookup.get(logResource).orElseThrow()).value();
    }
}

