/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.datagen;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.datagen.DeckProvider;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.item.ModDataComponentTypes;
import dev.lucaargolo.charta.item.ModItems;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class ModChestLootProvider
implements LootTableSubProvider {
    public static final ResourceKey<LootTable> ABANDONED_MINESHAFT_DECKS = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Charta.id("chests/abandoned_mineshaft_decks"));
    public static final ResourceKey<LootTable> DESERT_PYRAMID_DECKS = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Charta.id("chests/desert_pyramid_decks"));
    public static final ResourceKey<LootTable> SIMPLE_DUNGEON_DECKS = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Charta.id("chests/simple_dungeon_decks"));

    public ModChestLootProvider(HolderLookup.Provider provider) {
    }

    public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        LootPool.Builder mineshaftPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(ModChestLootProvider.deck(DeckProvider.FUN_INVERTED, 0.75)).add(ModChestLootProvider.deck(DeckProvider.FUN_CLASSIC, 0.75)).add(ModChestLootProvider.deck(DeckProvider.FUN_NEON, 0.25)).add(ModChestLootProvider.deck(DeckProvider.FUN_MINIMAL_NEON, 0.25)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(50));
        ModChestLootProvider.addGroup(mineshaftPool, "metals", 1.25);
        ModChestLootProvider.addGroup(mineshaftPool, "gems", 1.0);
        ModChestLootProvider.addGroup(mineshaftPool, "neon", 0.25);
        consumer.accept(ABANDONED_MINESHAFT_DECKS, LootTable.lootTable().withPool(mineshaftPool));
        LootPool.Builder pyramidPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(ModChestLootProvider.deck(DeckProvider.FUN_INVERTED, 2.0)).add(ModChestLootProvider.deck(DeckProvider.FUN_CLASSIC, 2.0)).add(ModChestLootProvider.deck(DeckProvider.FUN_NEON, 0.75)).add(ModChestLootProvider.deck(DeckProvider.FUN_MINIMAL_NEON, 0.75)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(50));
        ModChestLootProvider.addGroup(pyramidPool, "metals", 0.25);
        ModChestLootProvider.addGroup(pyramidPool, "neon", 0.5);
        consumer.accept(DESERT_PYRAMID_DECKS, LootTable.lootTable().withPool(pyramidPool));
        LootPool.Builder dungeonPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(ModChestLootProvider.deck(DeckProvider.FUN_INVERTED, 0.5)).add(ModChestLootProvider.deck(DeckProvider.FUN_CLASSIC, 0.5)).add(ModChestLootProvider.deck(DeckProvider.FUN_NEON, 0.125)).add(ModChestLootProvider.deck(DeckProvider.FUN_MINIMAL_NEON, 0.125)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(50));
        ModChestLootProvider.addGroup(dungeonPool, "flags", 2.0);
        ModChestLootProvider.addGroup(dungeonPool, "metals", 0.5);
        ModChestLootProvider.addGroup(dungeonPool, "gems", 0.25);
        ModChestLootProvider.addGroup(dungeonPool, "neon", 0.25);
        consumer.accept(SIMPLE_DUNGEON_DECKS, LootTable.lootTable().withPool(dungeonPool));
    }

    private static void addGroup(LootPool.Builder pool, String group, double chanceMultiplier) {
        DeckProvider.GROUPS.getOrDefault(group, List.of()).forEach(key -> Optional.ofNullable(DeckProvider.DECKS.get(key)).ifPresent(deck -> pool.add(ModChestLootProvider.deck(deck, chanceMultiplier))));
    }

    private static LootPoolSingletonContainer.Builder<?> deck(Deck deck, double chanceMultiplier) {
        ResourceLocation id = DeckProvider.DECKS.entrySet().stream().filter(e -> ((Deck)e.getValue()).equals(deck)).map(Map.Entry::getKey).findFirst().orElse(Charta.id("missing"));
        return LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.DECK.get())).apply((LootItemFunction.Builder)SetComponentsFunction.setComponent((DataComponentType)((DataComponentType)ModDataComponentTypes.CARD_DECK.get()), (Object)id)).setWeight(Mth.ceil((double)((double)((3 - deck.getRarity().ordinal()) * 20) * chanceMultiplier)));
    }
}

