/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.datagen;

import dev.lucaargolo.charta.block.BarShelfBlock;
import dev.lucaargolo.charta.block.BeerGlassBlock;
import dev.lucaargolo.charta.block.CardTableBlock;
import dev.lucaargolo.charta.block.GameChairBlock;
import dev.lucaargolo.charta.block.ModBlocks;
import dev.lucaargolo.charta.block.WineGlassBlock;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "charta", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (DyeColor color : DyeColor.values()) {
            String centerClothPath = "block/" + String.valueOf(color) + "_card_table_center_cloth";
            String cornerClothPath = "block/" + String.valueOf(color) + "_card_table_corner_cloth";
            String sideClothPath = "block/" + String.valueOf(color) + "_card_table_side_cloth";
            String chairClothPath = "block/" + String.valueOf(color) + "_game_chair_cloth";
            String stoolClothPath = "block/" + String.valueOf(color) + "_bar_stool_cloth";
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(centerClothPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/card_table_center_cloth")))).texture("particle", this.mcLoc("block/" + String.valueOf(color) + "_wool"))).texture("cloth", this.mcLoc("block/" + String.valueOf(color) + "_wool"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(cornerClothPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/card_table_corner_cloth")))).texture("particle", this.mcLoc("block/" + String.valueOf(color) + "_wool"))).texture("cloth", this.mcLoc("block/" + String.valueOf(color) + "_wool"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(sideClothPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/card_table_side_cloth")))).texture("particle", this.mcLoc("block/" + String.valueOf(color) + "_wool"))).texture("cloth", this.mcLoc("block/" + String.valueOf(color) + "_wool"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(chairClothPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/game_chair_cloth")))).texture("particle", this.mcLoc("block/" + String.valueOf(color) + "_wool"))).texture("cloth", this.mcLoc("block/" + String.valueOf(color) + "_wool"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(stoolClothPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/bar_stool_cloth")))).texture("particle", this.mcLoc("block/" + String.valueOf(color) + "_wool"))).texture("cloth", this.mcLoc("block/" + String.valueOf(color) + "_wool"));
        }
        ModBlocks.CARD_TABLE_MAP.forEach((woodType, cardTable) -> {
            MultiPartBlockStateBuilder cardTableBuilder = this.getMultipartBuilder((Block)cardTable.get());
            String wood = woodType.name();
            String centerPath = "block/" + wood + "_card_table_center";
            String feetPath = "block/" + wood + "_card_table_feet";
            String cornerPath = "block/" + wood + "_card_table_corner";
            String sidePath = "block/" + wood + "_card_table_side";
            String itemPath = "item/" + wood + "_card_table";
            ResourceLocation logResource = this.getLogResource(wood);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(centerPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/card_table_center")))).texture("particle", this.mcLoc("block/" + wood + "_planks"))).texture("planks", this.mcLoc("block/" + wood + "_planks"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(feetPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/card_table_feet")))).texture("particle", logResource)).texture("log", logResource);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(cornerPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/card_table_corner")))).texture("particle", this.mcLoc("block/" + wood + "_planks"))).texture("planks", this.mcLoc("block/" + wood + "_planks"))).texture("log", logResource);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(sidePath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/card_table_side")))).texture("particle", this.mcLoc("block/" + wood + "_planks"))).texture("planks", this.mcLoc("block/" + wood + "_planks"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(itemPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("item/card_table")))).texture("particle", this.mcLoc("block/" + wood + "_planks"))).texture("planks", this.mcLoc("block/" + wood + "_planks"))).texture("log", logResource);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(centerPath), 0, null, null, null, null, null);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(feetPath), 0, null, false, false, null, null);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(feetPath), 90, null, null, false, false, null);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(feetPath), 180, null, null, null, false, false);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(feetPath), 270, null, false, null, null, false);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(cornerPath), 0, true, false, true, true, false);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(cornerPath), 90, true, false, false, true, true);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(cornerPath), 180, true, true, false, false, true);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(cornerPath), 270, true, true, true, false, false);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(sidePath), 0, true, true, true, true, false);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(sidePath), 90, true, false, true, true, true);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(sidePath), 180, true, true, false, true, true);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(sidePath), 270, true, true, true, false, true);
            for (DyeColor color : DyeColor.values()) {
                String centerClothPath = "block/" + String.valueOf(color) + "_card_table_center_cloth";
                String cornerClothPath = "block/" + String.valueOf(color) + "_card_table_corner_cloth";
                String sideClothPath = "block/" + String.valueOf(color) + "_card_table_side_cloth";
                this.addClothCardTablePart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(centerClothPath), 0, true, true, true, true, true, color);
                this.addClothCardTablePart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(cornerClothPath), 0, true, false, true, true, false, color);
                this.addClothCardTablePart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(cornerClothPath), 90, true, false, false, true, true, color);
                this.addClothCardTablePart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(cornerClothPath), 180, true, true, false, false, true, color);
                this.addClothCardTablePart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(cornerClothPath), 270, true, true, true, false, false, color);
                this.addClothCardTablePart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(sideClothPath), 0, true, true, true, true, false, color);
                this.addClothCardTablePart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(sideClothPath), 90, true, false, true, true, true, color);
                this.addClothCardTablePart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(sideClothPath), 180, true, true, false, true, true, color);
                this.addClothCardTablePart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(sideClothPath), 270, true, true, true, false, true, color);
            }
        });
        ModBlocks.GAME_CHAIR_MAP.forEach((woodType, cardTable) -> {
            MultiPartBlockStateBuilder gameChairBuilder = this.getMultipartBuilder((Block)cardTable.get());
            String wood = woodType.name();
            String chairPath = "block/" + wood + "_game_chair";
            String itemPath = "item/" + wood + "_game_chair";
            ResourceLocation logResource = this.getLogResource(wood);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(chairPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/game_chair")))).texture("particle", this.mcLoc("block/" + wood + "_planks"))).texture("planks", this.mcLoc("block/" + wood + "_planks"))).texture("log", logResource);
            ((BlockModelBuilder)this.models().getBuilder(itemPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc(chairPath)));
            int rot = 0;
            for (Direction d : Direction.Plane.HORIZONTAL) {
                ((MultiPartBlockStateBuilder.PartBuilder)gameChairBuilder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(chairPath))).rotationY(rot).addModel()).condition((Property)GameChairBlock.FACING, (Comparable[])new Direction[]{d});
                for (DyeColor color : DyeColor.values()) {
                    String chairClothPath = "block/" + String.valueOf(color) + "_game_chair_cloth";
                    ((MultiPartBlockStateBuilder.PartBuilder)gameChairBuilder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(chairClothPath))).rotationY(rot).addModel()).condition((Property)GameChairBlock.FACING, (Comparable[])new Direction[]{d}).condition((Property)GameChairBlock.CLOTH, (Comparable[])new Boolean[]{true}).condition((Property)GameChairBlock.COLOR, (Comparable[])new DyeColor[]{color});
                }
                rot += 90;
            }
        });
        ModBlocks.BAR_STOOL_MAP.forEach((woodType, barStool) -> {
            MultiPartBlockStateBuilder barStoolBuilder = this.getMultipartBuilder((Block)barStool.get());
            String wood = woodType.name();
            String stoolPath = "block/" + wood + "_bar_stool";
            String itemPath = "item/" + wood + "_bar_stool";
            ResourceLocation logResource = this.getLogResource(wood);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(stoolPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/bar_stool")))).texture("particle", this.mcLoc("block/" + wood + "_planks"))).texture("planks", this.mcLoc("block/" + wood + "_planks"))).texture("log", logResource);
            ((BlockModelBuilder)this.models().getBuilder(itemPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc(stoolPath)));
            barStoolBuilder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(stoolPath))).addModel();
            for (DyeColor color : DyeColor.values()) {
                String stoolClothPath = "block/" + String.valueOf(color) + "_bar_stool_cloth";
                ((MultiPartBlockStateBuilder.PartBuilder)barStoolBuilder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(stoolClothPath))).addModel()).condition((Property)GameChairBlock.CLOTH, (Comparable[])new Boolean[]{true}).condition((Property)GameChairBlock.COLOR, (Comparable[])new DyeColor[]{color});
            }
        });
        ModBlocks.BAR_SHELF_MAP.forEach((woodType, barShelf) -> {
            MultiPartBlockStateBuilder barShelfBuilder = this.getMultipartBuilder((Block)barShelf.get());
            String wood = woodType.name();
            String shelfPath = "block/" + wood + "_bar_shelf";
            String shelfUpPath = "block/" + wood + "_bar_shelf_up";
            String itemPath = "item/" + wood + "_bar_shelf";
            ResourceLocation logResource = this.getLogResource(wood);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(shelfPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/bar_shelf")))).texture("particle", this.mcLoc("block/" + wood + "_planks"))).texture("planks", this.mcLoc("block/" + wood + "_planks"))).texture("log", logResource);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(shelfUpPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/bar_shelf_up")))).texture("particle", this.mcLoc("block/" + wood + "_planks"))).texture("planks", this.mcLoc("block/" + wood + "_planks"));
            ((BlockModelBuilder)this.models().getBuilder(itemPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc(shelfPath)));
            int i = 0;
            for (Direction d : Direction.Plane.HORIZONTAL) {
                ((MultiPartBlockStateBuilder.PartBuilder)barShelfBuilder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(shelfPath))).rotationY(i * 90).addModel()).condition((Property)BarShelfBlock.FACING, (Comparable[])new Direction[]{d});
                ((MultiPartBlockStateBuilder.PartBuilder)barShelfBuilder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(shelfUpPath))).rotationY(i * 90).addModel()).condition((Property)BarShelfBlock.FACING, (Comparable[])new Direction[]{d}).condition((Property)BarShelfBlock.UP, (Comparable[])new Boolean[]{false});
                ++i;
            }
        });
        ModBlocks.BLOCKS.getEntries().stream().filter(b -> b.get() instanceof BeerGlassBlock).forEach(block -> {
            VariantBlockStateBuilder beerGlassBuilder = this.getVariantBuilder((Block)block.get());
            int i = 0;
            for (Direction d : List.of(Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.NORTH)) {
                beerGlassBuilder.partialState().with((Property)BeerGlassBlock.FACING, (Comparable)d).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + block.getId().getPath()))).rotationY(i++ * 90).addModel();
            }
        });
        ModBlocks.BLOCKS.getEntries().stream().filter(b -> b.get() instanceof WineGlassBlock).forEach(block -> {
            VariantBlockStateBuilder wineGlassBuilder = this.getVariantBuilder((Block)block.get());
            wineGlassBuilder.partialState().modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + block.getId().getPath()))).addModel();
        });
    }

    private void addClothCardTablePart(ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder> builder, ResourceLocation modelPath, int rotationY, Boolean valid, Boolean north, Boolean east, Boolean south, Boolean west, DyeColor color) {
        MultiPartBlockStateBuilder.PartBuilder model = this.addDirectionPart(builder, modelPath, rotationY, valid, north, east, south, west);
        model.condition((Property)CardTableBlock.CLOTH, (Comparable[])new Boolean[]{true});
        model.condition(CardTableBlock.COLOR, (Comparable[])new DyeColor[]{color});
    }

    private MultiPartBlockStateBuilder.PartBuilder addDirectionPart(ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder> builder, ResourceLocation modelPath, int rotationY, Boolean valid, Boolean north, Boolean east, Boolean south, Boolean west) {
        builder.modelFile((ModelFile)this.models().getExistingFile(modelPath));
        builder.rotationY(rotationY);
        MultiPartBlockStateBuilder.PartBuilder model = (MultiPartBlockStateBuilder.PartBuilder)builder.addModel();
        if (valid != null) {
            model.condition((Property)CardTableBlock.VALID, (Comparable[])new Boolean[]{valid});
        }
        if (north != null) {
            model.condition((Property)CardTableBlock.NORTH, (Comparable[])new Boolean[]{north});
        }
        if (east != null) {
            model.condition((Property)CardTableBlock.EAST, (Comparable[])new Boolean[]{east});
        }
        if (south != null) {
            model.condition((Property)CardTableBlock.SOUTH, (Comparable[])new Boolean[]{south});
        }
        if (west != null) {
            model.condition((Property)CardTableBlock.WEST, (Comparable[])new Boolean[]{west});
        }
        return model;
    }

    private ResourceLocation getLogResource(String wood) {
        ResourceLocation logResource = this.mcLoc("block/" + wood + "_log");
        if (!this.models().existingFileHelper.exists(this.mcLoc("textures/block/" + wood + "_log.png"), PackType.CLIENT_RESOURCES)) {
            logResource = this.mcLoc("block/" + wood + "_stem");
            if (!this.models().existingFileHelper.exists(this.mcLoc("textures/block/" + wood + "_stem.png"), PackType.CLIENT_RESOURCES)) {
                logResource = this.mcLoc("block/" + wood + "_stalk");
            }
        }
        return logResource;
    }
}

