/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.datagen;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.game.Deck;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;
import org.jetbrains.annotations.NotNull;

public class DeckProvider
implements DataProvider {
    private final PackOutput output;
    private final Gson gson;
    public static final Map<ResourceLocation, Deck> DECKS = new HashMap<ResourceLocation, Deck>();
    public static final Map<String, List<ResourceLocation>> GROUPS = new HashMap<String, List<ResourceLocation>>();
    public static final Deck FUN_INVERTED = DeckProvider.register(Charta.id("fun_inverted"), Deck.fun(Rarity.UNCOMMON, false, Charta.id("fun_inverted"), Charta.id("fun_inverted")));
    public static final Deck FUN_CLASSIC = DeckProvider.register(Charta.id("fun_classic"), Deck.fun(Rarity.UNCOMMON, false, Charta.id("fun_classic"), Charta.id("fun_classic")));
    public static final Deck FUN_NEON = DeckProvider.register(Charta.id("fun_neon"), Deck.fun(Rarity.RARE, false, Charta.id("fun_neon"), Charta.id("fun_neon")));
    public static final Deck FUN_MINIMAL_NEON = DeckProvider.register(Charta.id("fun_minimal_neon"), Deck.fun(Rarity.RARE, false, Charta.id("fun_neon"), Charta.id("fun_minimal_neon"), Charta.id("fun_minimal_neon")));

    public static Deck register(ResourceLocation resourceLocation, Deck deck) {
        if (DECKS.containsKey(resourceLocation)) {
            throw new IllegalArgumentException("Duplicate resource location: " + String.valueOf(resourceLocation));
        }
        if (resourceLocation.getPath().split("/").length == 2) {
            String group = resourceLocation.getPath().split("/")[0];
            GROUPS.computeIfAbsent(group, k -> new ArrayList()).add(resourceLocation);
        }
        DECKS.put(resourceLocation, deck);
        return deck;
    }

    public DeckProvider(PackOutput output) {
        this.output = output;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cachedOutput) {
        return CompletableFuture.runAsync(() -> {
            Path outputPath = this.output.getOutputFolder();
            String decksOutputPath = String.valueOf(outputPath) + File.separator + "data" + File.separator + "charta" + File.separator + "decks";
            DECKS.forEach((key, deck) -> {
                String path = key.getPath() + ".json";
                Path fullPath = Path.of(decksOutputPath, path);
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                HashingOutputStream hashedOutStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)outStream);
                DataResult json = Deck.CODEC.encode(deck, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty());
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)hashedOutStream, StandardCharsets.UTF_8);){
                    writer.write(this.gson.toJson((JsonElement)json.getOrThrow()));
                    writer.flush();
                }
                catch (IOException e) {
                    Charta.LOGGER.error("Error writing stream for file: {}", (Object)fullPath, (Object)e);
                }
                try {
                    cachedOutput.writeIfNeeded(fullPath, outStream.toByteArray(), hashedOutStream.hash());
                }
                catch (IOException e) {
                    Charta.LOGGER.error("Error saving file: {}", (Object)fullPath, (Object)e);
                }
            });
        });
    }

    @NotNull
    public String getName() {
        return "CardDecks";
    }

    static {
        DeckProvider.register(Charta.id("standard/black"), Deck.simple(Rarity.COMMON, true, Charta.id("standard"), Charta.id("standard/black")));
        DeckProvider.register(Charta.id("standard/blue"), Deck.simple(Rarity.COMMON, true, Charta.id("standard"), Charta.id("standard/blue")));
        DeckProvider.register(Charta.id("standard/green"), Deck.simple(Rarity.COMMON, true, Charta.id("standard"), Charta.id("standard/green")));
        DeckProvider.register(Charta.id("standard/red"), Deck.simple(Rarity.COMMON, true, Charta.id("standard"), Charta.id("standard/red")));
        DeckProvider.register(Charta.id("standard/yellow"), Deck.simple(Rarity.COMMON, true, Charta.id("standard"), Charta.id("standard/yellow")));
        DeckProvider.register(Charta.id("light/aqua"), Deck.simple(Rarity.UNCOMMON, true, Charta.id("light"), Charta.id("light/aqua")));
        DeckProvider.register(Charta.id("light/blue"), Deck.simple(Rarity.UNCOMMON, true, Charta.id("light"), Charta.id("light/blue")));
        DeckProvider.register(Charta.id("light/green"), Deck.simple(Rarity.UNCOMMON, true, Charta.id("light"), Charta.id("light/green")));
        DeckProvider.register(Charta.id("light/orange"), Deck.simple(Rarity.UNCOMMON, true, Charta.id("light"), Charta.id("light/orange")));
        DeckProvider.register(Charta.id("light/pink"), Deck.simple(Rarity.UNCOMMON, true, Charta.id("light"), Charta.id("light/pink")));
        DeckProvider.register(Charta.id("light/red"), Deck.simple(Rarity.UNCOMMON, true, Charta.id("light"), Charta.id("light/red")));
        DeckProvider.register(Charta.id("light/yellow"), Deck.simple(Rarity.UNCOMMON, true, Charta.id("light"), Charta.id("light/yellow")));
        DeckProvider.register(Charta.id("dark/aqua"), Deck.simple(Rarity.UNCOMMON, true, Charta.id("light"), Charta.id("dark"), Charta.id("dark/aqua")));
        DeckProvider.register(Charta.id("dark/blue"), Deck.simple(Rarity.UNCOMMON, true, Charta.id("light"), Charta.id("dark"), Charta.id("dark/blue")));
        DeckProvider.register(Charta.id("dark/green"), Deck.simple(Rarity.UNCOMMON, true, Charta.id("light"), Charta.id("dark"), Charta.id("dark/green")));
        DeckProvider.register(Charta.id("dark/orange"), Deck.simple(Rarity.UNCOMMON, true, Charta.id("light"), Charta.id("dark"), Charta.id("dark/orange")));
        DeckProvider.register(Charta.id("dark/pink"), Deck.simple(Rarity.UNCOMMON, true, Charta.id("light"), Charta.id("dark"), Charta.id("dark/pink")));
        DeckProvider.register(Charta.id("dark/red"), Deck.simple(Rarity.UNCOMMON, true, Charta.id("light"), Charta.id("dark"), Charta.id("dark/red")));
        DeckProvider.register(Charta.id("dark/yellow"), Deck.simple(Rarity.UNCOMMON, true, Charta.id("light"), Charta.id("dark"), Charta.id("dark/yellow")));
        DeckProvider.register(Charta.id("inverted"), Deck.simple(Rarity.RARE, true, Charta.id("inverted"), Charta.id("inverted")));
        DeckProvider.register(Charta.id("fun"), Deck.fun(Rarity.RARE, true, Charta.id("fun"), Charta.id("fun")));
        DeckProvider.register(Charta.id("fun_minimal"), Deck.fun(Rarity.RARE, true, Charta.id("fun"), Charta.id("fun_minimal"), Charta.id("fun_minimal")));
        DeckProvider.register(Charta.id("fun_light"), Deck.fun(Rarity.RARE, true, Charta.id("fun_light"), Charta.id("fun_light")));
        DeckProvider.register(Charta.id("flags/argentina"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/argentina")));
        DeckProvider.register(Charta.id("flags/australia"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/australia")));
        DeckProvider.register(Charta.id("flags/belgium"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/belgium")));
        DeckProvider.register(Charta.id("flags/brazil"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/brazil")));
        DeckProvider.register(Charta.id("flags/canada"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/canada")));
        DeckProvider.register(Charta.id("flags/china"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/china")));
        DeckProvider.register(Charta.id("flags/france"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/france")));
        DeckProvider.register(Charta.id("flags/germany"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/germany")));
        DeckProvider.register(Charta.id("flags/india"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/india")));
        DeckProvider.register(Charta.id("flags/indonesia"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/indonesia")));
        DeckProvider.register(Charta.id("flags/ireland"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/ireland")));
        DeckProvider.register(Charta.id("flags/italy"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/italy")));
        DeckProvider.register(Charta.id("flags/japan"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/japan")));
        DeckProvider.register(Charta.id("flags/mexico"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/mexico")));
        DeckProvider.register(Charta.id("flags/netherlands"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/netherlands")));
        DeckProvider.register(Charta.id("flags/philippines"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/philippines")));
        DeckProvider.register(Charta.id("flags/poland"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/poland")));
        DeckProvider.register(Charta.id("flags/portugal"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/portugal")));
        DeckProvider.register(Charta.id("flags/rainbow"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/rainbow")));
        DeckProvider.register(Charta.id("flags/russia"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/russia")));
        DeckProvider.register(Charta.id("flags/spain"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/spain")));
        DeckProvider.register(Charta.id("flags/thailand"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/thailand")));
        DeckProvider.register(Charta.id("flags/ukraine"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/ukraine")));
        DeckProvider.register(Charta.id("flags/united_kingdom"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/united_kingdom")));
        DeckProvider.register(Charta.id("flags/usa"), Deck.simple(Rarity.COMMON, false, Charta.id("standard"), Charta.id("flags/usa")));
        DeckProvider.register(Charta.id("neon/aqua"), Deck.simple(Rarity.UNCOMMON, false, Charta.id("neon"), Charta.id("neon/aqua")));
        DeckProvider.register(Charta.id("neon/blue"), Deck.simple(Rarity.UNCOMMON, false, Charta.id("neon"), Charta.id("neon/blue")));
        DeckProvider.register(Charta.id("neon/green"), Deck.simple(Rarity.UNCOMMON, false, Charta.id("neon"), Charta.id("neon/green")));
        DeckProvider.register(Charta.id("neon/orange"), Deck.simple(Rarity.UNCOMMON, false, Charta.id("neon"), Charta.id("neon/orange")));
        DeckProvider.register(Charta.id("neon/pink"), Deck.simple(Rarity.UNCOMMON, false, Charta.id("neon"), Charta.id("neon/pink")));
        DeckProvider.register(Charta.id("neon/red"), Deck.simple(Rarity.UNCOMMON, false, Charta.id("neon"), Charta.id("neon/red")));
        DeckProvider.register(Charta.id("neon/yellow"), Deck.simple(Rarity.UNCOMMON, false, Charta.id("neon"), Charta.id("neon/yellow")));
        DeckProvider.register(Charta.id("metals/copper"), Deck.simple(Rarity.RARE, false, Charta.id("metallic"), Charta.id("metals/copper"), Charta.id("metals/copper")));
        DeckProvider.register(Charta.id("metals/iron"), Deck.simple(Rarity.RARE, false, Charta.id("metallic"), Charta.id("metals/iron"), Charta.id("metals/iron")));
        DeckProvider.register(Charta.id("metals/gold"), Deck.simple(Rarity.RARE, false, Charta.id("metallic"), Charta.id("metals/gold"), Charta.id("metals/gold")));
        DeckProvider.register(Charta.id("gems/diamond"), Deck.simple(Rarity.RARE, false, Charta.id("metallic"), Charta.id("gems/diamond"), Charta.id("gems/diamond")));
        DeckProvider.register(Charta.id("gems/emerald"), Deck.simple(Rarity.RARE, false, Charta.id("metallic"), Charta.id("gems/emerald"), Charta.id("gems/emerald")));
        DeckProvider.register(Charta.id("gems/ruby"), Deck.simple(Rarity.RARE, false, Charta.id("metallic"), Charta.id("gems/ruby"), Charta.id("gems/ruby")));
        DeckProvider.register(Charta.id("gems/sapphire"), Deck.simple(Rarity.RARE, false, Charta.id("metallic"), Charta.id("gems/sapphire"), Charta.id("gems/sapphire")));
        DeckProvider.register(Charta.id("gems/amethyst"), Deck.simple(Rarity.RARE, false, Charta.id("metallic"), Charta.id("gems/amethyst"), Charta.id("gems/amethyst")));
    }
}

