/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.datagen;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.utils.CardImage;
import dev.lucaargolo.charta.utils.CardImageUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import org.jetbrains.annotations.NotNull;

public class DeckImageProvider
implements DataProvider {
    private final PackOutput output;

    public DeckImageProvider(PackOutput output) {
        this.output = output;
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cachedOutput) {
        return CompletableFuture.runAsync(() -> {
            Path outputPath = this.output.getOutputFolder();
            String decksOutputPath = String.valueOf(outputPath) + File.separator + "data" + File.separator + "charta" + File.separator + "images" + File.separator + "deck";
            try {
                URL resource = Charta.class.getClassLoader().getResource("decks");
                URI uri = Objects.requireNonNull(resource).toURI();
                try (Stream<Path> paths = Files.walk(Paths.get(uri), new FileVisitOption[0]);){
                    paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                        String fileName = path.getFileName().toString();
                        String cardName = fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(46)) : fileName;
                        String subFolder = path.getParent().toString().replace("decks", "");
                        File cardOutputFolder = new File(decksOutputPath);
                        cardOutputFolder.mkdirs();
                        File cardOutputFile = new File(String.valueOf(cardOutputFolder) + File.separator + subFolder + File.separator + cardName);
                        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
                            CardImage.saveCards(ImageIO.read(stream), cardOutputFile, (fileToSave, cardImage) -> CardImageUtils.saveImage(cardImage, fileToSave, cachedOutput), String::valueOf, String::valueOf);
                        }
                        catch (Exception e) {
                            Charta.LOGGER.error("Error loading image: {}", path, (Object)e);
                        }
                    });
                }
            }
            catch (IOException | URISyntaxException e) {
                Charta.LOGGER.error("Error loading cards", (Throwable)e);
            }
        });
    }

    @NotNull
    public String getName() {
        return "Decks";
    }
}

