/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.datagen;

import dev.lucaargolo.charta.block.ModBannerPatterns;
import dev.lucaargolo.charta.datagen.CardImageProvider;
import dev.lucaargolo.charta.datagen.DeckImageProvider;
import dev.lucaargolo.charta.datagen.DeckProvider;
import dev.lucaargolo.charta.datagen.ModBannerPatternTagsProvider;
import dev.lucaargolo.charta.datagen.ModBlockStateProvider;
import dev.lucaargolo.charta.datagen.ModBlockTagsProvider;
import dev.lucaargolo.charta.datagen.ModLootProvider;
import dev.lucaargolo.charta.datagen.ModRecipeProvider;
import dev.lucaargolo.charta.datagen.SuitImageProvider;
import java.util.Set;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="charta", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper exFileHelper = event.getExistingFileHelper();
        DatapackBuiltinEntriesProvider builtinProvider = new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), DataGenerators.bootstrapRegistries(), Set.of("charta"));
        generator.addProvider(true, (DataProvider)builtinProvider);
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(output, exFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new SuitImageProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new CardImageProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new DeckImageProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new DeckProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new ModLootProvider(output, builtinProvider.getRegistryProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new ModBannerPatternTagsProvider(output, builtinProvider.getRegistryProvider(), exFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagsProvider(output, builtinProvider.getRegistryProvider(), exFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(output, builtinProvider.getRegistryProvider()));
    }

    public static RegistrySetBuilder bootstrapRegistries() {
        return new RegistrySetBuilder().add(Registries.BANNER_PATTERN, ModBannerPatterns::bootstrap);
    }
}

