/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.client.item;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.ModRenderType;
import dev.lucaargolo.charta.compat.IrisCompat;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.item.DeckItem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DeckItemExtensions
implements IClientItemExtensions {
    private static final RandomSource RANDOM = RandomSource.create();

    @NotNull
    public BlockEntityWithoutLevelRenderer getCustomRenderer() {
        final Minecraft minecraft = Minecraft.getInstance();
        return new BlockEntityWithoutLevelRenderer(this, minecraft.getBlockEntityRenderDispatcher(), minecraft.getEntityModels()){

            public void renderByItem(@NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
                BakedModel model = minecraft.getModelManager().getModel(new ModelResourceLocation(Charta.id("deck"), "standalone"));
                List<BakedQuad> transformedQuads = model.getQuads(null, null, RANDOM).stream().map(DeckItemExtensions::replaceQuadSprite).toList();
                Deck deck = DeckItem.getDeck(stack);
                if (IrisCompat.isPresent()) {
                    ResourceLocation deckGlowTexture = deck != null ? deck.getDeckTexture(true) : Charta.MISSING_CARD;
                    RenderType glowRenderType = RenderType.entityTranslucentEmissive((ResourceLocation)deckGlowTexture);
                    minecraft.getItemRenderer().renderQuadList(poseStack, buffer.getBuffer(glowRenderType), transformedQuads, stack, 0xF000F0, packedOverlay);
                }
                ResourceLocation deckTexture = deck != null ? deck.getDeckTexture(false) : Charta.MISSING_CARD;
                RenderType renderType = IrisCompat.isPresent() ? RenderType.entityTranslucent((ResourceLocation)deckTexture) : ModRenderType.entityCard(deckTexture);
                minecraft.getItemRenderer().renderQuadList(poseStack, buffer.getBuffer(renderType), transformedQuads, stack, packedLight, packedOverlay);
                if (IrisCompat.isPresent()) {
                    ResourceLocation deckGlowTexture = deck != null ? deck.getDeckTexture(true) : Charta.MISSING_CARD;
                    RenderType glowRenderType = RenderType.entityTranslucentEmissive((ResourceLocation)deckGlowTexture);
                    minecraft.getItemRenderer().renderQuadList(poseStack, buffer.getBuffer(glowRenderType), transformedQuads, stack, 0xF000F0, packedOverlay);
                }
            }
        };
    }

    private static BakedQuad replaceQuadSprite(BakedQuad quad) {
        int[] vertexData = (int[])quad.getVertices().clone();
        for (int cornerIndex = 0; cornerIndex < 4; ++cornerIndex) {
            int i = cornerIndex * 8;
            float uFrame = (Float.intBitsToFloat(vertexData[i + 4]) - quad.getSprite().getU0()) / (quad.getSprite().getU1() - quad.getSprite().getU0());
            vertexData[i + 4] = Float.floatToRawIntBits(uFrame);
            float vFrame = (Float.intBitsToFloat(vertexData[i + 5]) - quad.getSprite().getV0()) / (quad.getSprite().getV1() - quad.getSprite().getV0());
            vertexData[i + 5] = Float.floatToRawIntBits(vFrame);
        }
        return new BakedQuad(vertexData, quad.getTintIndex(), quad.getDirection(), null, quad.isShade());
    }
}

