/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.client.gui.screens;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Either;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.ChartaClient;
import dev.lucaargolo.charta.client.gui.screens.OptionsScreen;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardGames;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.mixed.LivingEntityMixed;
import dev.lucaargolo.charta.network.CardTableSelectGamePayload;
import dev.lucaargolo.charta.utils.ChartaGuiGraphics;
import dev.lucaargolo.charta.utils.TickableWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableScreen
extends Screen {
    private final BlockPos pos;
    private final Deck deck;
    private final int[] players;
    private GameWidget<?> widget;

    public TableScreen(BlockPos pos, Deck deck, int[] players) {
        super((Component)Component.translatable((String)"message.charta.choose_game"));
        this.pos = pos;
        this.deck = deck;
        this.players = players;
    }

    protected void init() {
        super.init();
        this.widget = (GameWidget)this.addRenderableWidget((GuiEventListener)new GameWidget(this.minecraft, this.width, this.height - 60, 30));
        CardGames.getGames().forEach((gameId, gameFactory) -> this.widget.addEntry(new Game((ResourceLocation)gameId, gameFactory)));
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 10, -1);
        if (this.minecraft != null) {
            guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"message.charta.hold_to_options", (Object[])new Object[]{this.minecraft.options.keyShift.getKey().getDisplayName()}), this.width / 2, this.height - 20, -1);
        }
    }

    public void tick() {
        if (this.minecraft != null) {
            int mouseX = (int)(this.minecraft.mouseHandler.xpos() * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth());
            int mouseY = (int)(this.minecraft.mouseHandler.ypos() * (double)this.minecraft.getWindow().getGuiScaledHeight() / (double)this.minecraft.getWindow().getScreenHeight());
            for (GuiEventListener widget : this.children()) {
                if (!(widget instanceof TickableWidget)) continue;
                TickableWidget tickable = (TickableWidget)widget;
                tickable.tick(mouseX, mouseY);
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private boolean isShiftDown() {
        assert (this.minecraft != null);
        return InputConstants.isKeyDown((long)this.minecraft.getWindow().getWindow(), (int)this.minecraft.options.keyShift.getKey().getValue());
    }

    public class GameWidget<G extends CardGame<G>>
    extends ContainerObjectSelectionList<GameRow<G>>
    implements TickableWidget {
        private final int amount;

        public GameWidget(Minecraft minecraft, int width, int height, int y) {
            super(minecraft, width, height, y, 75);
            int margin = width - 40;
            this.amount = margin / 75;
        }

        public void addEntry(@NotNull Game<G> entry) {
            if (this.children().isEmpty() || ((GameRow)((Object)this.children().getLast())).games.size() >= this.amount) {
                this.addEntry((AbstractSelectionList.Entry)new GameRow());
            }
            ((GameRow)((Object)this.children().getLast())).games.add(entry);
            MutableComponent play = Component.literal((String)"\ue037").withStyle(Charta.SYMBOLS);
            Button playWidget = Button.builder((Component)play, button -> entry.onPress()).bounds(0, 0, 20, 20).build();
            playWidget.active = entry.active;
            playWidget.setTooltip(Tooltip.create((Component)(entry.tooltip != null ? entry.tooltip : Component.translatable((String)"message.charta.play_game"))));
            ((GameRow)((Object)this.children().getLast())).plays.add(playWidget);
            MutableComponent config = Component.literal((String)"\ue8b8").withStyle(Charta.SYMBOLS);
            Button configWidget = Button.builder((Component)config, button -> this.minecraft.setScreen(new OptionsScreen(TableScreen.this, TableScreen.this.pos, entry.game, entry.gameId, entry.gameFactory, false))).bounds(0, 0, 20, 20).build();
            configWidget.active = entry.active && !((CardGame)entry.game).getOptions().isEmpty();
            configWidget.setTooltip(Tooltip.create((Component)Component.translatable((String)"message.charta.configure_game")));
            ((GameRow)((Object)this.children().getLast())).configs.add(configWidget);
        }

        public int getRowWidth() {
            return this.amount * 75 - 5;
        }

        @Override
        public void tick(int mouseX, int mouseY) {
            for (GameRow row : this.children()) {
                for (Game game : row.games) {
                    game.tick(mouseX, mouseY);
                }
            }
        }
    }

    public class Game<G extends CardGame<G>>
    extends Button
    implements TickableWidget {
        private final ResourceLocation gameId;
        private final CardGames.Factory<G> gameFactory;
        private final ResourceLocation texture;
        private final G game;
        @Nullable
        private final Component tooltip;
        private float lastInset;
        private float inset;
        private float lastFov;
        private float fov;

        public Game(ResourceLocation gameId, CardGames.Factory<G> gameFactory) {
            super(0, 0, 70, 70, (Component)Component.translatable((String)gameId.toLanguageKey()), button -> {
                PacketDistributor.sendToServer((CustomPacketPayload)new CardTableSelectGamePayload(dev$lucaargolo$charta$client$gui$screens$TableScreen$this.pos, gameId, ChartaClient.LOCAL_OPTIONS.getOrDefault(gameId, new byte[0])), (CustomPacketPayload[])new CustomPacketPayload[0]);
                TableScreen.this.onClose();
            }, Button.DEFAULT_NARRATION);
            this.lastInset = 0.0f;
            this.inset = 0.0f;
            this.lastFov = 30.0f;
            this.fov = 37.0f;
            this.gameId = gameId;
            this.gameFactory = gameFactory;
            this.texture = gameId.withPrefix("textures/gui/game/").withSuffix(".png");
            this.game = gameFactory.create(List.of(), Deck.EMPTY);
            ArrayList<CardPlayer> cardPlayers = new ArrayList<CardPlayer>();
            for (int entityId : TableScreen.this.players) {
                Entity entity;
                if (TableScreen.this.minecraft == null || ((TableScreen)TableScreen.this).minecraft.level == null || !((entity = ((TableScreen)TableScreen.this).minecraft.level.getEntity(entityId)) instanceof LivingEntityMixed)) continue;
                LivingEntityMixed mixed = (LivingEntityMixed)entity;
                cardPlayers.add(mixed.charta_getCardPlayer());
            }
            Either<CardGame<?>, Component> either = ((CardGame)this.game).playerPredicate(cardPlayers);
            boolean invalidDeck = !CardGame.isValidDeck(this.game, TableScreen.this.deck);
            boolean notEnoughPlayers = TableScreen.this.players.length < ((CardGame)this.game).getMinPlayers();
            boolean tooManyPlayers = TableScreen.this.players.length > ((CardGame)this.game).getMaxPlayers();
            boolean invalidPlayers = either.right().isPresent();
            boolean bl = this.active = !invalidDeck && !notEnoughPlayers && !tooManyPlayers && !invalidPlayers;
            this.tooltip = invalidDeck ? Component.translatable((String)"message.charta.cant_play_deck").append(" ").append((Component)Component.translatable((String)"message.charta.try_finding_another")) : (notEnoughPlayers ? Component.translatable((String)"message.charta.not_enough_players", (Object[])new Object[]{((CardGame)this.game).getMinPlayers()}) : (tooManyPlayers ? Component.translatable((String)"message.charta.too_many_players", (Object[])new Object[]{((CardGame)this.game).getMaxPlayers()}) : (invalidPlayers ? (Component)either.right().orElseThrow() : null)));
        }

        protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.isHovered() && TableScreen.this.isShiftDown()) {
                this.isHovered = false;
            }
            if (this.active) {
                float inset = Mth.lerp((float)partialTick, (float)this.lastInset, (float)this.inset);
                float fov = Mth.lerp((float)partialTick, (float)this.lastFov, (float)this.fov);
                ChartaClient.CARD_INSET.accept(Float.valueOf(inset));
                ChartaClient.CARD_FOV.accept(Float.valueOf(fov));
                ChartaClient.CARD_X_ROT.accept(Float.valueOf(0.0f));
                ChartaClient.CARD_Y_ROT.accept(Float.valueOf(0.0f));
                float xOffset = ((float)this.getWidth() * 1.333333f - (float)this.getWidth()) / 2.0f;
                float yOffset = ((float)this.getHeight() * 1.333333f - (float)this.getHeight()) / 2.0f;
                ChartaGuiGraphics.blitPerspective(guiGraphics, this.texture, (float)this.getX() - xOffset, (float)this.getY() - yOffset, (float)this.getWidth() + xOffset * 2.0f, (float)this.getHeight() + yOffset * 2.0f);
                this.lastInset = inset;
                this.lastFov = fov;
            } else {
                ChartaGuiGraphics.blitGrayscale(guiGraphics, this.texture, this.getX(), this.getY(), 70.0f, 70.0f);
            }
            if (this.isHovered()) {
                if (this.active) {
                    guiGraphics.fill(this.getX(), this.getY(), this.getX() + 70, this.getY() + 70, 0x33FFFFFF);
                } else {
                    guiGraphics.fill(this.getX() + 2, this.getY() + 2, this.getX() + 68, this.getY() + 68, 0x33FFFFFF);
                }
            } else if (TableScreen.this.isShiftDown()) {
                guiGraphics.fill(this.getX() + 2, this.getY() + 2, this.getX() + 68, this.getY() + 68, 0x66000000);
            }
        }

        @Override
        public void tick(int mouseX, int mouseY) {
            this.inset = this.isHovered() ? -30.0f : 0.0f;
            this.fov = 37.0f;
        }
    }

    public class GameRow<G extends CardGame<G>>
    extends ContainerObjectSelectionList.Entry<GameRow<G>> {
        protected List<Game<G>> games = new ArrayList<Game<G>>();
        protected List<Button> plays = new ArrayList<Button>();
        protected List<Button> configs = new ArrayList<Button>();

        public void render(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            int i = 0;
            for (Game<G> game : this.games) {
                game.setX(left + i * 75);
                game.setY(top);
                game.render(guiGraphics, mouseX, mouseY, partialTick);
                if (game.isHovered() && game.tooltip != null) {
                    TableScreen.this.setTooltipForNextRenderPass(game.tooltip);
                }
                ++i;
            }
            if (TableScreen.this.isShiftDown()) {
                i = 0;
                for (Button button : this.plays) {
                    button.setX(left + i * 75 + 25 - 12);
                    button.setY(top + 25);
                    button.render(guiGraphics, mouseX, mouseY, partialTick);
                    ++i;
                }
                i = 0;
                for (Button button : this.configs) {
                    button.setX(left + i * 75 + 25 + 12);
                    button.setY(top + 25);
                    button.render(guiGraphics, mouseX, mouseY, partialTick);
                    ++i;
                }
            }
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return TableScreen.this.isShiftDown() ? Stream.concat(this.plays.stream(), this.configs.stream()).toList() : this.games;
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return TableScreen.this.isShiftDown() ? Stream.concat(this.plays.stream(), this.configs.stream()).toList() : this.games;
        }
    }
}

