/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.client.gui.screens;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.ChartaClient;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardGames;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.game.GameOption;
import dev.lucaargolo.charta.network.CardTableSelectGamePayload;
import dev.lucaargolo.charta.network.PlayerOptionsPayload;
import dev.lucaargolo.charta.utils.CustomOptionTooltip;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class OptionsScreen<G extends CardGame<G>>
extends Screen {
    private final Screen parent;
    private final BlockPos pos;
    private final G game;
    private final ResourceLocation gameId;
    private final CardGames.Factory<G> gameFactory;
    private final boolean showcase;
    private OptionsWidget widget;
    private Button resetButton;
    private Button saveButton;

    public OptionsScreen(Screen parent, BlockPos pos, G game, ResourceLocation gameId, CardGames.Factory<G> gameFactory, boolean showcase) {
        super((Component)Component.translatable((String)"message.charta.this_game_options", (Object[])new Object[]{Component.translatable((String)gameId.toLanguageKey())}));
        this.parent = parent;
        this.pos = pos;
        this.game = game;
        this.gameId = gameId;
        this.gameFactory = gameFactory;
        this.showcase = showcase;
        if (!showcase) {
            Optional.ofNullable(ChartaClient.LOCAL_OPTIONS.get(this.gameId)).ifPresent(arg_0 -> game.setRawOptions(arg_0));
        }
    }

    protected void init() {
        this.widget = (OptionsWidget)this.addRenderableWidget((GuiEventListener)new OptionsWidget(this.minecraft, this.width, this.height - 60, 30));
        for (int i = 0; i < ((CardGame)this.game).getOptions().size(); ++i) {
            GameOption<?> option = ((CardGame)this.game).getOptions().get(i);
            this.widget.addEntry(option.getWidget(o -> this.updateButtons(false), this.font, this.widget.getRowWidth(), 20, this.showcase));
        }
        MutableComponent back = Component.literal((String)"\ue5c4").withStyle(Charta.SYMBOLS);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)back, b -> this.onClose()).bounds(5, 5, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"message.charta.go_back"))).build());
        if (!this.showcase) {
            this.resetButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.charta.reset"), b -> {
                boolean reset = CardGames.areOptionsChanged(this.gameFactory, this.game);
                if (reset) {
                    G defaultGame = this.gameFactory.create(List.of(), Deck.EMPTY);
                    ((CardGame)this.game).setRawOptions(((CardGame)defaultGame).getRawOptions());
                }
                this.updateButtons(false);
            }).bounds(this.width / 2 - 108, this.height - 25, 68, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"message.charta.reset_options"))).build());
            this.resetButton.active = CardGames.areOptionsChanged(this.gameFactory, this.game);
            this.saveButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.charta.save"), b -> {
                this.updateButtons(true);
                ChartaClient.LOCAL_OPTIONS.put(this.gameId, ((CardGame)this.game).getRawOptions());
                PacketDistributor.sendToServer((CustomPacketPayload)new PlayerOptionsPayload(ChartaClient.LOCAL_OPTIONS), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }).bounds(this.width / 2 - 32, this.height - 25, 68, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"message.charta.save_options"))).build());
            this.saveButton.active = false;
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.charta.start"), b -> {
                PacketDistributor.sendToServer((CustomPacketPayload)new CardTableSelectGamePayload(this.pos, this.gameId, ((CardGame)this.game).getRawOptions()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.onClose();
            }).bounds(this.width / 2 + 44, this.height - 25, 68, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"message.charta.start_options"))).build());
        }
        this.updateButtons(true);
    }

    public void updateButtons(boolean saved) {
        boolean reset = false;
        G defaultGame = this.gameFactory.create(List.of(), Deck.EMPTY);
        for (int i = 0; i < ((CardGame)defaultGame).getOptions().size(); ++i) {
            GameOption<?> defaultOption = ((CardGame)defaultGame).getOptions().get(i);
            GameOption<?> modifiedOption = ((CardGame)this.game).getOptions().get(i);
            GameOption.Widget entry = this.widget.getEntry(i);
            entry.setTooltip(new CustomOptionTooltip(entry.getTooltip(), defaultOption.get().toString(), modifiedOption.get().toString()));
            if (modifiedOption.getValue() != defaultOption.getValue()) {
                this.widget.changed.set(i, true);
                reset = true;
                continue;
            }
            this.widget.changed.set(i, false);
        }
        if (this.resetButton != null) {
            this.resetButton.active = reset;
        }
        if (this.saveButton != null) {
            this.saveButton.active = !saved;
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 10, -1);
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public static class OptionsWidget
    extends ContainerObjectSelectionList<GameOption.Widget> {
        protected final BooleanList changed = new BooleanArrayList();

        public OptionsWidget(Minecraft minecraft, int width, int height, int y) {
            super(minecraft, width, height, y, 25);
        }

        protected void renderItem(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int index, int left, int top, int width, int height) {
            super.renderItem(guiGraphics, mouseX, mouseY, partialTick, index, left, top, width, height);
            if (this.changed.getBoolean(index)) {
                guiGraphics.drawString(this.minecraft.font, "!", left + width - 4, top + 2, Util.getMillis() / 1000L % 2L == 0L ? 0xFF0000 : 0xFFFF00);
            }
        }

        public int addEntry(@NotNull GameOption.Widget entry) {
            this.changed.add(false);
            return super.addEntry((AbstractSelectionList.Entry)entry);
        }

        public @NotNull GameOption.Widget getEntry(int index) {
            return (GameOption.Widget)super.getEntry(index);
        }
    }
}

