/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.client.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.ChartaClient;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class MarkdownScreen
extends Screen {
    private final Screen parent;
    private final List<Either<String, String>> markdown;
    private MarkdownWidget widget;

    public MarkdownScreen(Component title, Screen parent, String markdown) {
        super(title);
        this.parent = parent;
        String resourceId = I18n.get((String)("charta_md:" + markdown), (Object[])new Object[0]);
        ResourceLocation id = ResourceLocation.tryParse((String)resourceId);
        this.markdown = id != null ? ChartaClient.MARKDOWN.getMarkdown(id) : List.of(Either.left((Object)"p"), Either.right((Object)resourceId));
    }

    protected void init() {
        this.widget = (MarkdownWidget)this.addRenderableWidget((GuiEventListener)new MarkdownWidget(this.minecraft, this.width, this.height - 60, 30));
        LinkedList stack = new LinkedList();
        LinkedList countStack = new LinkedList();
        AtomicInteger space = new AtomicInteger();
        AtomicBoolean started = new AtomicBoolean(false);
        MutableComponent text = Component.empty();
        for (Either<String, String> either : this.markdown) {
            either.ifLeft(t -> {
                boolean isCancel = t.startsWith("/");
                MarkdownTag tag = MarkdownTag.get(t.replace("/", ""));
                if (isCancel) {
                    if (tag == MarkdownTag.OL) {
                        countStack.removeLast();
                    }
                    if (tag.start) {
                        started.set(false);
                        this.widget.addEntry(new MarkdownLine(this.font, List.copyOf(stack), (FormattedText)text.copy(), space.get(), false));
                        text.getSiblings().clear();
                    }
                    stack.removeLastOccurrence((Object)tag);
                } else {
                    if (tag == MarkdownTag.OL) {
                        countStack.add(0);
                    }
                    if (tag.start) {
                        if (started.get()) {
                            this.widget.addEntry(new MarkdownLine(this.font, List.copyOf(stack), (FormattedText)text.copy(), space.get(), false));
                            text.getSiblings().clear();
                        }
                        if (!this.widget.children().isEmpty() && tag.line) {
                            this.widget.addEmptyEntry(this.font);
                        }
                        started.set(true);
                    }
                    stack.addLast(tag);
                }
            }).ifRight(t -> {
                boolean bold = false;
                boolean italic = false;
                if (text.getString().isEmpty()) {
                    int i;
                    int listTabs = 0;
                    int numberedTabs = 0;
                    boolean numbered = false;
                    for (MarkdownTag tag : stack) {
                        switch (tag.ordinal()) {
                            case 9: {
                                ++listTabs;
                                numbered = false;
                                break;
                            }
                            case 10: {
                                ++numberedTabs;
                                numbered = true;
                            }
                        }
                    }
                    space.set(0);
                    for (i = 0; i < listTabs; ++i) {
                        text.append("  ");
                        space.addAndGet(this.font.width("  "));
                    }
                    for (i = 0; i < numberedTabs - 1; ++i) {
                        text.append("  ");
                        space.addAndGet(this.font.width("  "));
                    }
                    if (numbered) {
                        countStack.addLast((Integer)countStack.removeLast() + 1);
                        text.append(String.valueOf(countStack.getLast()) + ". ");
                        space.addAndGet(this.font.width(String.valueOf(countStack.getLast()) + ". "));
                    } else if (listTabs + numberedTabs > 0) {
                        text.append(" - ");
                        space.addAndGet(this.font.width(" - "));
                    }
                }
                for (MarkdownTag tag : stack) {
                    switch (tag.ordinal()) {
                        case 7: {
                            bold = true;
                            break;
                        }
                        case 8: {
                            italic = true;
                        }
                    }
                }
                boolean em = italic;
                boolean strong = bold;
                text.append((Component)Component.literal((String)t).withStyle(s -> s.withBold(Boolean.valueOf(strong)).withItalic(Boolean.valueOf(em))));
            });
        }
        if (this.parent != null) {
            MutableComponent back = Component.literal((String)"\ue5c4").withStyle(Charta.SYMBOLS);
            this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)back, b -> this.onClose()).bounds(5, 5, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"message.charta.go_back"))).build());
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 10, -1);
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public static class MarkdownWidget
    extends ContainerObjectSelectionList<MarkdownLine> {
        public MarkdownWidget(Minecraft minecraft, int width, int height, int y) {
            super(minecraft, width, height, y, 10);
        }

        protected void renderItem(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int index, int left, int top, int width, int height) {
            super.renderItem(guiGraphics, mouseX, mouseY, partialTick, index, left, top, width, height);
        }

        public void addEmptyEntry(Font font) {
            super.addEntry((AbstractSelectionList.Entry)new MarkdownLine(font, List.of(), (FormattedText)Component.empty(), 0.0, false));
        }

        public int addEntry(@NotNull MarkdownLine entry) {
            if (!entry.text.getString().isEmpty()) {
                List lines = entry.font.getSplitter().splitLines(entry.text, this.getRowWidth(), Style.EMPTY);
                boolean first = true;
                for (FormattedText line : lines) {
                    if (entry.tall) {
                        super.addEntry((AbstractSelectionList.Entry)entry.withText(line, first));
                        this.addEmptyEntry(entry.font);
                    } else {
                        super.addEntry((AbstractSelectionList.Entry)entry.withText(line, first));
                    }
                    first = false;
                }
            }
            return this.children().size() - 1;
        }

        public int getRowWidth() {
            return Math.min(600, this.minecraft.getWindow().getGuiScaledWidth() - 32);
        }
    }

    public static enum MarkdownTag {
        P(true, true),
        H1(true, true),
        H2(true, true),
        H3(true, true),
        H4(true, true),
        H5(true, true),
        H6(true, true),
        STRONG(false, false),
        EM(false, false),
        UL(false, false),
        OL(false, false),
        LI(true, false),
        A(false, false);

        final boolean start;
        final boolean line;

        private MarkdownTag(boolean start, boolean line) {
            this.start = start;
            this.line = line;
        }

        public static MarkdownTag get(String tag) {
            try {
                return MarkdownTag.valueOf(tag.toUpperCase());
            }
            catch (Exception e) {
                return P;
            }
        }
    }

    public static class MarkdownLine
    extends ContainerObjectSelectionList.Entry<MarkdownLine> {
        private final Font font;
        private final List<MarkdownTag> tags;
        private final boolean tall;
        private final FormattedText text;
        private final double space;
        private final boolean align;

        public MarkdownLine(Font font, List<MarkdownTag> tags, FormattedText text, double space, boolean align) {
            this.font = font;
            this.tags = tags;
            this.tall = tags.stream().anyMatch(t -> t == MarkdownTag.H1 || t == MarkdownTag.H2 || t == MarkdownTag.H3 || t == MarkdownTag.H4);
            this.text = text;
            for (MarkdownTag tag : tags) {
                switch (tag.ordinal()) {
                    case 1: {
                        space *= 2.0;
                        break;
                    }
                    case 2: {
                        space *= 1.5;
                        break;
                    }
                    case 3: {
                        space *= 1.25;
                        break;
                    }
                    case 4: {
                        space *= 1.125;
                        break;
                    }
                    case 6: {
                        space *= 0.75;
                    }
                }
            }
            this.space = space;
            this.align = align;
        }

        public MarkdownLine withText(FormattedText text, boolean first) {
            return new MarkdownLine(this.font, this.tags, text, this.space, !first);
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return List.of();
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return List.of();
        }

        public void render(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            PoseStack stack = guiGraphics.pose();
            stack.pushPose();
            stack.translate((float)(left - 12), (float)top, 0.0f);
            if (this.align) {
                stack.translate(this.space, 0.0, 0.0);
            }
            for (MarkdownTag tag : this.tags) {
                switch (tag.ordinal()) {
                    case 1: {
                        stack.scale(2.0f, 2.0f, 2.0f);
                        break;
                    }
                    case 2: {
                        stack.scale(1.5f, 1.5f, 1.5f);
                        break;
                    }
                    case 3: {
                        stack.scale(1.25f, 1.25f, 1.25f);
                        break;
                    }
                    case 4: {
                        stack.scale(1.125f, 1.125f, 1.125f);
                        break;
                    }
                    case 6: {
                        stack.scale(0.75f, 0.75f, 0.75f);
                    }
                }
            }
            guiGraphics.drawString(this.font, Language.getInstance().getVisualOrder(this.text), 0, 0, 0xFFFFFF);
            stack.popPose();
        }
    }
}

