/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.client.gui.screens;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.ChartaClient;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

public class HistoryScreen
extends Screen {
    private final Screen parent;
    private HistoryWidget widget;

    public HistoryScreen(Screen parent) {
        super((Component)Component.translatable((String)"charta.game_history"));
        this.parent = parent;
    }

    protected void init() {
        this.widget = (HistoryWidget)this.addRenderableWidget((GuiEventListener)new HistoryWidget(this, this.minecraft, this.width, this.height - 60, 30));
        ChartaClient.LOCAL_HISTORY.forEach(triple -> this.widget.addEntry(new Play((Triple<Component, Integer, Component>)triple)));
        this.widget.setClampedScrollAmount(Double.MAX_VALUE);
        MutableComponent back = Component.literal((String)"\ue5c4").withStyle(Charta.SYMBOLS);
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)back, b -> this.onClose()).bounds(5, 5, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"message.charta.go_back"))).build());
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 10, -1);
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public class HistoryWidget
    extends ContainerObjectSelectionList<Play> {
        public HistoryWidget(HistoryScreen this$0, Minecraft minecraft, int width, int height, int y) {
            super(minecraft, width, height, y, 15);
        }

        public int addEntry(@NotNull Play entry) {
            return super.addEntry((AbstractSelectionList.Entry)entry);
        }

        public int getRowWidth() {
            return Math.min(600, this.minecraft.getWindow().getGuiScaledWidth() - 32);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class Play
    extends ContainerObjectSelectionList.Entry<Play> {
        private final Component player;
        private final int cards;
        private final Component play;

        public Play(Triple<Component, Integer, Component> triple) {
            this.player = (Component)triple.getLeft();
            this.cards = (Integer)triple.getMiddle();
            this.play = (Component)triple.getRight();
        }

        public void render(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            guiGraphics.fill(left - 12 + 101, top - 4, left - 12 + 102, top + height, 0x33FFFFFF);
            guiGraphics.fill(left - 12 + width - 108, top - 4, left - 12 + width - 107, top + height, 0x33FFFFFF);
            if (!this.player.equals((Object)Component.empty())) {
                guiGraphics.drawString(HistoryScreen.this.font, this.player, left - 12, top, -1);
                guiGraphics.drawString(HistoryScreen.this.font, (Component)Component.literal((String)Integer.toString(this.cards)).append(" ").append((Component)(this.cards > 1 ? Component.translatable((String)"charta.cards") : Component.translatable((String)"charta.card"))), left - 12 + width - 101, top, -1);
            }
            guiGraphics.drawScrollingString(HistoryScreen.this.font, this.play, left - 12 + 108, left - 12 + width - 108, top, -1);
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return List.of();
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return List.of();
        }
    }
}

