/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.client.gui.screens;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.gui.components.CardSlotWidget;
import dev.lucaargolo.charta.client.gui.screens.CardScreen;
import dev.lucaargolo.charta.client.gui.screens.DeckScreen;
import dev.lucaargolo.charta.client.gui.screens.HistoryScreen;
import dev.lucaargolo.charta.client.gui.screens.MarkdownScreen;
import dev.lucaargolo.charta.client.gui.screens.OptionsScreen;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardGames;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import dev.lucaargolo.charta.menu.CardSlot;
import dev.lucaargolo.charta.network.CardContainerSlotClickPayload;
import dev.lucaargolo.charta.utils.CardPlayerHead;
import dev.lucaargolo.charta.utils.HoverableRenderable;
import dev.lucaargolo.charta.utils.MultiLineTooltip;
import dev.lucaargolo.charta.utils.TickableWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GameScreen<G extends CardGame<G>, T extends AbstractCardMenu<G>>
extends AbstractContainerScreen<T>
implements HoverableRenderable {
    public static final ResourceLocation WIDGETS = Charta.id("textures/gui/widgets.png");
    private final List<CardSlotWidget<G>> slotWidgets = new ArrayList<CardSlotWidget<G>>();
    protected HoverableRenderable hoverable = null;
    protected CardSlot<G> hoveredCardSlot = null;
    protected int hoveredCardId = -1;
    private final boolean areOptionsChanged;
    private final ChatScreen chatScreen = new ChatScreen("");
    private boolean prevChatFocused = false;
    private boolean chatFocused = false;
    private Button optionsButton;

    public GameScreen(T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.areOptionsChanged = CardGames.areOptionsChanged(((AbstractCardMenu)((Object)menu)).getGameFactory(), ((AbstractCardMenu)((Object)menu)).getGame());
    }

    public Deck getDeck() {
        return ((AbstractCardMenu)this.menu).getDeck();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.hoveredCardSlot != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new CardContainerSlotClickPayload(((AbstractCardMenu)this.menu).containerId, this.hoveredCardSlot.index, this.hoveredCardId), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return this.chatScreen.mouseClicked(mouseX, this.chatFocused ? mouseY : mouseY + 25.0, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.chatFocused && this.chatScreen.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft != null && this.chatFocused) {
            if (keyCode == 257 || keyCode == 335) {
                this.chatScreen.handleChatInput(this.chatScreen.input.getValue(), true);
                this.chatFocused = false;
                return true;
            }
            if (this.chatScreen.keyPressed(keyCode, scanCode, modifiers)) {
                if (keyCode == 256) {
                    this.minecraft.setScreen((Screen)this);
                    this.chatFocused = false;
                }
                return true;
            }
        }
        if (!this.chatFocused) {
            if (keyCode == 84) {
                this.chatFocused = true;
                this.chatScreen.input.setValue("");
                return false;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.minecraft != null && this.prevChatFocused && this.chatFocused && this.chatScreen.charTyped(codePoint, modifiers)) {
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    public final void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void init() {
        super.init();
        assert (this.minecraft != null);
        this.chatScreen.init(this.minecraft, this.width, this.height);
        this.slotWidgets.clear();
        ((AbstractCardMenu)this.menu).cardSlots.forEach(slot -> this.slotWidgets.add(new CardSlotWidget(this, slot)));
        MutableComponent rules = Component.literal((String)"\ue90e").withStyle(Charta.SYMBOLS);
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)rules, b -> {
            ResourceLocation gameId = CardGames.getGameId(((AbstractCardMenu)this.menu).getGameFactory());
            Minecraft.getInstance().setScreen((Screen)new MarkdownScreen((Component)Component.translatable((String)"message.charta.how_to_play").append(" ").append((Component)Component.translatable((String)gameId.toLanguageKey())), (Screen)this, gameId.getNamespace() + ".how_to_play_" + gameId.getPath()));
        }).bounds(5, 35, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"message.charta.how_to_play"))).build());
        MultiLineTooltip tooltip = this.areOptionsChanged ? new MultiLineTooltip(new Component[]{Component.translatable((String)"message.charta.game_options"), Component.empty(), Component.translatable((String)"message.charta.custom_options").withStyle(ChatFormatting.RED)}) : Tooltip.create((Component)Component.translatable((String)"message.charta.game_options"));
        MutableComponent config = Component.literal((String)"\ue8b8").withStyle(Charta.SYMBOLS);
        this.optionsButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)config, b -> {
            ResourceLocation gameId = CardGames.getGameId(((AbstractCardMenu)this.menu).getGameFactory());
            Minecraft.getInstance().setScreen(new OptionsScreen((Screen)this, BlockPos.ZERO, ((AbstractCardMenu)this.menu).getGame(), gameId, ((AbstractCardMenu)this.menu).getGameFactory(), true));
        }).bounds(27, 35, 20, 20).tooltip((Tooltip)tooltip).build());
        this.optionsButton.active = !((CardGame)((AbstractCardMenu)this.menu).getGame()).getOptions().isEmpty();
        MutableComponent cards = Component.literal((String)"\ue41d").withStyle(Charta.SYMBOLS);
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)cards, b -> Minecraft.getInstance().setScreen((Screen)new DeckScreen((Screen)this, this.getDeck()))).bounds(this.width - 25, 35, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"message.charta.game_deck"))).build());
        MutableComponent history = Component.literal((String)"\ue889").withStyle(Charta.SYMBOLS);
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)history, b -> Minecraft.getInstance().setScreen((Screen)new HistoryScreen((Screen)this))).bounds(this.width - 47, 35, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"message.charta.game_history"))).build());
    }

    public void renderTopBar(@NotNull GuiGraphics guiGraphics) {
        Object game = ((AbstractCardMenu)this.menu).getGame();
        int players = ((CardGame)game).getPlayers().size();
        float totalWidth = CardSlot.getWidth(CardSlot.Type.PREVIEW) + 28.0f;
        float playersWidth = (float)players * totalWidth + ((float)players - 1.0f) * (totalWidth / 10.0f);
        guiGraphics.fill(0, 0, Mth.floor((float)(((float)this.width - playersWidth) / 2.0f)), 28, -2013265920);
        guiGraphics.fill(this.width - Mth.floor((float)(((float)this.width - playersWidth) / 2.0f)), 0, this.width, 28, -2013265920);
        for (int i = 0; i < players; ++i) {
            CardPlayer player = ((CardGame)game).getPlayers().get(i);
            float x = (float)this.width / 2.0f - playersWidth / 2.0f + (float)i * (totalWidth + totalWidth / 10.0f);
            Component text = player.getName();
            DyeColor color = player.getColor();
            guiGraphics.fill(Mth.floor((float)x), 0, Mth.ceil((float)(x + totalWidth)), 28, -2013265920 + color.getTextureDiffuseColor());
            if (i < players - 1) {
                guiGraphics.fill(Mth.ceil((float)(x + totalWidth)), 0, Mth.floor((float)(x + totalWidth + totalWidth / 10.0f)), 28, -2013265920);
            }
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(x + 26.0f, 2.0f, 0.0f);
            guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
            guiGraphics.drawString(this.font, text, 0, 0, -1, true);
            guiGraphics.pose().popPose();
            Minecraft mc = Minecraft.getInstance();
            Function function = mc.getTextureAtlas(InventoryMenu.BLOCK_ATLAS);
            ResourceLocation wool = ResourceLocation.withDefaultNamespace((String)("block/" + color.getName() + "_wool"));
            TextureAtlasSprite woolSprite = (TextureAtlasSprite)function.apply(wool);
            guiGraphics.blit((int)(x + 4.0f), 2, 0, 16, 1, woolSprite);
            guiGraphics.blit((int)(x + 2.0f), 3, 0, 20, 22, woolSprite);
            guiGraphics.blit((int)(x + 4.0f), 25, 0, 16, 1, woolSprite);
            CardPlayerHead.renderHead(guiGraphics, (int)x, 2, player);
        }
    }

    public void renderBottomBar(@NotNull GuiGraphics guiGraphics) {
        CardPlayer player = ((AbstractCardMenu)this.menu).getCardPlayer();
        DyeColor color = player.getColor();
        int totalWidth = Mth.floor((float)CardSlot.getWidth(CardSlot.Type.HORIZONTAL)) + 10;
        guiGraphics.fill(0, this.height - 63, (this.width - totalWidth) / 2, this.height, -2013265920);
        guiGraphics.fill((this.width - totalWidth) / 2, this.height - 63, (this.width - totalWidth) / 2 + totalWidth, this.height, -2013265920 + color.getTextureDiffuseColor());
        guiGraphics.fill((this.width - totalWidth) / 2 + totalWidth, this.height - 63, this.width, this.height, -2013265920);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Renderable renderable2;
        this.renderBlurredBackground(partialTick);
        this.renderTopBar(guiGraphics);
        this.renderBottomBar(guiGraphics);
        this.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        List renderablesBackup = List.copyOf(this.renderables);
        this.hoveredCardSlot = null;
        for (int k = 0; k < ((AbstractCardMenu)this.menu).cardSlots.size(); ++k) {
            CardSlot slot = (CardSlot)((AbstractCardMenu)this.menu).cardSlots.get(k);
            if (this.isHoveringPrecise(slot, mouseX, mouseY)) {
                this.hoveredCardSlot = slot;
            }
            if (CardSlot.getWidth(slot) == 37.5f) {
                guiGraphics.blit(WIDGETS, this.leftPos + (int)slot.x, this.topPos + (int)slot.y, 0, 0, 38, 53);
            }
            if (slot.getSlot().isEmpty()) continue;
            CardSlotWidget<G> slotWidget = this.slotWidgets.get(k);
            slotWidget.setPreciseX(slot.x + (float)this.leftPos);
            if (slot.getType() == CardSlot.Type.HORIZONTAL) {
                slotWidget.setPreciseY(slot.y + (float)this.height - slotWidget.getPreciseHeight());
            } else if (slot.getType() == CardSlot.Type.PREVIEW) {
                slotWidget.setPreciseY(slot.y);
            } else {
                slotWidget.setPreciseY(slot.y + (float)this.topPos);
            }
            this.renderables.add(slotWidget);
        }
        if (this.hoverable != null && !this.renderables.contains(this.hoverable)) {
            this.hoverable = null;
        }
        for (Renderable renderable2 : this.renderables) {
            if (renderable2 == this.hoverable) continue;
            if (this.hoverable != null) {
                this.hoverable.render(guiGraphics, mouseX, mouseY, partialTick);
            }
            renderable2.render(guiGraphics, mouseX, mouseY, partialTick);
            if (!(renderable2 instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)renderable2;
            if (!(renderable2 instanceof HoverableRenderable) || !widget.isHovered) continue;
            HoverableRenderable hoverableRenderable = this.hoverable;
            if (hoverableRenderable instanceof AbstractWidget) {
                AbstractWidget other = (AbstractWidget)hoverableRenderable;
                if (other.isHovered) continue;
            }
            this.hoverable = (HoverableRenderable)renderable2;
        }
        this.renderables.clear();
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.minecraft != null && !this.chatFocused) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, -25.0f, 0.0f);
            double chatWidth = (Double)this.minecraft.options.chatWidth().get();
            double newChatWidth = Math.min(chatWidth * 280.0, (double)this.width / 2.0 - (double)this.imageWidth / 2.0 - 50.0) / 280.0;
            if (newChatWidth > 0.0 && newChatWidth < 1.0) {
                this.minecraft.options.chatWidth().set((Object)newChatWidth);
            }
            this.minecraft.gui.getChat().render(guiGraphics, this.minecraft.gui.getGuiTicks(), mouseX, mouseY + 25, false);
            this.minecraft.options.chatWidth().set((Object)chatWidth);
            guiGraphics.pose().popPose();
        }
        if (this.areOptionsChanged && this.optionsButton != null) {
            guiGraphics.drawString(this.font, "!", this.optionsButton.getX() + 16, this.optionsButton.getY() + 2, Util.getMillis() / 1000L % 2L == 0L ? 0xFF0000 : 0xFFFF00);
        }
        this.renderables.addAll(renderablesBackup);
        if (this.hoverable != null) {
            this.hoverable.render(guiGraphics, mouseX, mouseY, partialTick);
            renderable2 = this.hoverable;
            if (renderable2 instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)renderable2;
                if (!widget.isHovered) {
                    this.hoverable = null;
                }
            }
        }
        if (this.hoveredCardSlot != null && (renderable2 = this.hoverable) instanceof CardSlotWidget) {
            CardSlotWidget cardSlotWidget = (CardSlotWidget)renderable2;
            this.hoveredCardId = cardSlotWidget.getHoveredId();
        } else {
            this.hoveredCardId = -1;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        GameSlot cards = ((AbstractCardMenu)this.menu).getCarriedCards();
        if (!cards.isEmpty()) {
            CardSlotWidget<CardGame> carriedWidget = new CardSlotWidget<CardGame>(this, new CardSlot<CardGame>((CardGame)((AbstractCardMenu)this.menu).getGame(), g -> cards, (float)(mouseX - this.leftPos) - 18.75f, (float)(mouseY - this.topPos) - 26.25f, CardSlot.Type.VERTICAL));
            carriedWidget.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        CardScreen.renderGlowBlur((Screen)this, guiGraphics, partialTick);
        guiGraphics.pose().popPose();
        if (this.chatFocused) {
            this.renderBlurredBackground(partialTick);
            this.chatScreen.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public void scheduleTooltip(Component component) {
        this.setTooltipForNextRenderPass(component);
    }

    public boolean isHoveredCardSlot(CardSlot<G> slot) {
        return this.hoveredCardSlot == slot;
    }

    private boolean isHoveringPrecise(CardSlot<G> slot, float mouseX, float mouseY) {
        return switch (slot.getType()) {
            case CardSlot.Type.HORIZONTAL -> this.isHoveringPrecise(slot.x, slot.y - (float)this.topPos + (float)this.height - CardSlot.getHeight(slot), CardSlot.getWidth(slot), CardSlot.getHeight(slot), mouseX, mouseY);
            case CardSlot.Type.PREVIEW -> this.isHoveringPrecise(slot.x, slot.y - (float)this.topPos, CardSlot.getWidth(slot), CardSlot.getHeight(slot), mouseX, mouseY);
            default -> this.isHoveringPrecise(slot.x, slot.y, CardSlot.getWidth(slot), CardSlot.getHeight(slot), mouseX, mouseY);
        };
    }

    protected boolean isHoveringPrecise(float x, float y, float width, float height, double mouseX, double mouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        return (mouseX -= (double)i) >= (double)x && mouseX < (double)(x + width) && (mouseY -= (double)j) >= (double)y && mouseY < (double)(y + height);
    }

    public void containerTick() {
        super.containerTick();
        this.prevChatFocused = this.chatFocused;
        if (this.minecraft != null) {
            int mouseX = (int)(this.minecraft.mouseHandler.xpos() * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth());
            int mouseY = (int)(this.minecraft.mouseHandler.ypos() * (double)this.minecraft.getWindow().getGuiScaledHeight() / (double)this.minecraft.getWindow().getScreenHeight());
            for (GuiEventListener guiEventListener : this.children()) {
                if (!(guiEventListener instanceof TickableWidget)) continue;
                TickableWidget tickable = (TickableWidget)guiEventListener;
                tickable.tick(mouseX, mouseY);
            }
            for (CardSlotWidget cardSlotWidget : this.slotWidgets) {
                cardSlotWidget.tick(mouseX, mouseY);
            }
        }
    }

    @Override
    @Nullable
    public HoverableRenderable getHoverable() {
        return this.hoverable;
    }
}

