/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.client.gui.screens;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.gui.components.CardWidget;
import dev.lucaargolo.charta.client.gui.screens.CardScreen;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.game.Suit;
import dev.lucaargolo.charta.menu.CardSlot;
import dev.lucaargolo.charta.utils.ChartaGuiGraphics;
import dev.lucaargolo.charta.utils.HoverableRenderable;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeckScreen
extends CardScreen
implements HoverableRenderable {
    private final Screen parent;
    private final Deck deck;
    private int headerOffset = 10;
    private int footerOffset = 10;

    public DeckScreen(@Nullable Screen parent, Deck deck) {
        super(deck.getName());
        this.parent = parent;
        this.deck = deck;
    }

    protected void init() {
        if (this.parent != null) {
            MutableComponent back = Component.literal((String)"\ue5c4").withStyle(Charta.SYMBOLS);
            this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)back, b -> this.onClose()).bounds(5, 5, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"message.charta.go_back"))).build());
        }
        float cardWidth = CardSlot.getWidth(CardSlot.Type.DEFAULT);
        float maxWidth = (float)this.width - 60.0f - cardWidth;
        float maxLeftOffset = cardWidth + cardWidth / 10.0f;
        float maxHeight = (float)this.height - 80.0f;
        float cardHeight = CardSlot.getHeight(CardSlot.Type.DEFAULT);
        float maxTopOffset = cardHeight + cardHeight / 10.0f;
        float topOffset = cardHeight + Math.max(0.0f, maxHeight - (float)this.deck.getUniqueSuits().size() * cardHeight / (float)this.deck.getUniqueSuits().size());
        float totalHeight = cardHeight + topOffset * ((float)this.deck.getUniqueSuits().size() - 1.0f);
        float topExcess = totalHeight - maxHeight;
        if (topExcess > 0.0f) {
            topOffset -= topExcess / ((float)this.deck.getUniqueSuits().size() - 1.0f);
        }
        totalHeight = cardHeight + maxTopOffset * ((float)this.deck.getUniqueSuits().size() - 1.0f);
        float top = 0.0f;
        if (topOffset > maxTopOffset) {
            top = Math.max(topOffset - maxTopOffset, maxHeight - totalHeight);
            topOffset = maxTopOffset;
        }
        this.headerOffset = Math.max(0, Mth.floor((float)(top / 2.0f + 15.0f)));
        this.footerOffset = Math.max(0, Mth.floor((float)(top / 2.0f + 27.0f)));
        int i = 0;
        for (Suit suit : this.deck.getUniqueSuits()) {
            List<Card> cards = this.deck.getCards().stream().filter(c -> c.suit().equals(suit)).sorted().toList();
            float leftOffset = cardWidth + Math.max(0.0f, maxWidth - (float)cards.size() * cardWidth / (float)cards.size());
            float totalWidth = cardWidth + leftOffset * ((float)cards.size() - 1.0f);
            float leftExcess = totalWidth - maxWidth;
            if (leftExcess > 0.0f) {
                leftOffset -= leftExcess / ((float)cards.size() - 1.0f);
            }
            totalWidth = cardWidth + maxLeftOffset * ((float)cards.size() - 1.0f);
            float left = 0.0f;
            if (leftOffset > maxLeftOffset) {
                left = Math.max(leftOffset - maxLeftOffset, maxWidth - totalWidth);
                leftOffset = maxLeftOffset;
            }
            this.addRenderableWidget((GuiEventListener)new CardWidget(this, Card.BLANK, this.deck, 25.0f + left / 2.0f, 45.0f + topOffset * (float)i + top / 2.0f, 1.0f){

                @Override
                @Nullable
                public String getCardTranslatableKey() {
                    return DeckScreen.this.deck.getDeckTranslatableKey();
                }
            });
            int j = 0;
            for (Card card : cards) {
                CardWidget cardWidget = new CardWidget(this, card, this.deck, cardWidth + 35.0f + leftOffset * (float)j + left / 2.0f, 45.0f + topOffset * (float)i + top / 2.0f, 1.0f);
                this.addRenderableWidget((GuiEventListener)cardWidget);
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected void renderFg(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, this.headerOffset, -1);
        int i = 0;
        int totalWidth = this.deck.getUniqueSuits().size() * 16 - 3;
        for (Suit suit : this.deck.getUniqueSuits()) {
            ChartaGuiGraphics.blitSuitAndGlow(guiGraphics, this.deck, suit, (float)this.width / 2.0f - (float)totalWidth / 2.0f + (float)(i * 16), this.headerOffset + 10, 0.0f, 0.0f, 13.0f, 13.0f, 13.0f, 13.0f);
            ++i;
        }
        guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)(this.deck.getCards().size() + " ")).append((Component)Component.translatable((String)"charta.cards")).append(" | " + this.deck.getUniqueSuits().size() + " ").append((Component)Component.translatable((String)"charta.suits")), this.width / 2, this.height - this.footerOffset, -1);
    }

    @Override
    public void scheduleTooltip(Component component) {
        this.setTooltipForNextRenderPass(component);
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
    }
}

