/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.client.gui.screens;

import dev.lucaargolo.charta.Charta;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class ConfirmScreen
extends Screen {
    private static final ResourceLocation TEXTURE = Charta.id("textures/gui/confirm.png");
    private final int imageWidth = 175;
    private final int imageHeight = 108;
    private int leftPos;
    private int topPos;
    private final Screen parent;
    private final Component text;
    private final Runnable action;
    private final boolean reversed;

    public ConfirmScreen(Screen parent, Component text, boolean reversed, Runnable action) {
        super((Component)Component.translatable((String)"message.charta.are_you_sure"));
        this.parent = parent;
        this.text = text;
        this.reversed = reversed;
        this.action = action;
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        assert (this.minecraft != null);
        if ((int)mouseX >= this.leftPos + 21 && (int)mouseX <= this.leftPos + 81 && (int)mouseY >= this.topPos + 75 && (int)mouseY <= this.topPos + 95) {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            if (this.reversed) {
                this.action.run();
            }
            this.onClose();
            return true;
        }
        if ((int)mouseX >= this.leftPos + 95 && (int)mouseX <= this.leftPos + 155 && (int)mouseY >= this.topPos + 75 && (int)mouseY <= this.topPos + 95) {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            if (!this.reversed) {
                this.action.run();
            }
            this.onClose();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, 175, 108);
        graphics.drawCenteredString(this.font, this.title, this.leftPos + 87, this.topPos + 9, 0xFFFFFF);
        List split = this.font.split((FormattedText)this.text, 140);
        for (int i = 0; i < split.size(); ++i) {
            FormattedCharSequence sequence = (FormattedCharSequence)split.get(i);
            graphics.drawString(this.font, sequence, this.leftPos + 16, this.topPos + 26 + 10 * i, 0xFFFFFF);
        }
        if (mouseX >= this.leftPos + 21 && mouseX <= this.leftPos + 81 && mouseY >= this.topPos + 75 && mouseY <= this.topPos + 95) {
            graphics.blit(TEXTURE, this.leftPos + 21, this.topPos + 75, 0, 108, 60, 20);
        } else if (mouseX >= this.leftPos + 95 && mouseX <= this.leftPos + 155 && mouseY >= this.topPos + 75 && mouseY <= this.topPos + 95) {
            graphics.blit(TEXTURE, this.leftPos + 95, this.topPos + 75, 60, 108, 60, 20);
        }
        graphics.drawCenteredString(this.font, (Component)(this.reversed ? Component.translatable((String)"button.charta.confirm") : Component.translatable((String)"button.charta.cancel")), this.leftPos + 51, this.topPos + 80, 0xFFFFFF);
        graphics.drawCenteredString(this.font, (Component)(this.reversed ? Component.translatable((String)"button.charta.cancel") : Component.translatable((String)"button.charta.confirm")), this.leftPos + 125, this.topPos + 80, 0xFFFFFF);
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

