/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.client.gui.screens;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.lucaargolo.charta.client.ChartaClient;
import dev.lucaargolo.charta.utils.ChartaGuiGraphics;
import dev.lucaargolo.charta.utils.HoverableRenderable;
import dev.lucaargolo.charta.utils.TickableWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CardScreen
extends Screen
implements HoverableRenderable {
    private HoverableRenderable hoverable = null;

    protected CardScreen(Component title) {
        super(title);
    }

    protected void renderFg(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, -1);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        for (Renderable renderable : this.renderables) {
            if (renderable == this.hoverable) continue;
            if (this.hoverable != null) {
                this.hoverable.render(guiGraphics, mouseX, mouseY, partialTick);
            }
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
            if (!(renderable instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)renderable;
            if (!(renderable instanceof HoverableRenderable) || !widget.isHovered) continue;
            HoverableRenderable hoverableRenderable = this.hoverable;
            if (hoverableRenderable instanceof AbstractWidget) {
                AbstractWidget other = (AbstractWidget)hoverableRenderable;
                if (other.isHovered) continue;
            }
            this.hoverable = (HoverableRenderable)renderable;
        }
        if (this.hoverable != null) {
            this.hoverable.render(guiGraphics, mouseX, mouseY, partialTick);
            HoverableRenderable hoverableRenderable = this.hoverable;
            if (hoverableRenderable instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)hoverableRenderable;
                if (!widget.isHovered) {
                    this.hoverable = null;
                }
            }
        }
        this.renderFg(guiGraphics, mouseX, mouseY);
        CardScreen.renderGlowBlur(this, guiGraphics, partialTick);
    }

    public void tick() {
        if (this.minecraft != null) {
            int mouseX = (int)(this.minecraft.mouseHandler.xpos() * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth());
            int mouseY = (int)(this.minecraft.mouseHandler.ypos() * (double)this.minecraft.getWindow().getGuiScaledHeight() / (double)this.minecraft.getWindow().getScreenHeight());
            for (GuiEventListener widget : this.children()) {
                if (!(widget instanceof TickableWidget)) continue;
                TickableWidget tickable = (TickableWidget)widget;
                tickable.tick(mouseX, mouseY);
            }
        }
    }

    public static void renderGlowBlur(Screen screen, GuiGraphics guiGraphics, float partialTick) {
        ChartaClient.processBlurEffect(partialTick);
        RenderTarget glowTarget = ChartaClient.getGlowRenderTarget();
        Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (int)glowTarget.getColorTextureId());
        RenderSystem.blendFunc((int)1, (int)1);
        ChartaGuiGraphics.innerBlit(guiGraphics, 0.0f, screen.width, 0.0f, screen.height, 0.0f, 1.0f, 1.0f, 0.0f);
        RenderSystem.defaultBlendFunc();
        ChartaClient.getGlowRenderTarget().clear(Minecraft.ON_OSX);
        Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
    }

    @Override
    public void scheduleTooltip(Component component) {
        this.setTooltipForNextRenderPass(component);
    }

    @Override
    @Nullable
    public HoverableRenderable getHoverable() {
        return this.hoverable;
    }

    public boolean isPauseScreen() {
        return false;
    }
}

