/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.client.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.lucaargolo.charta.blockentity.CardTableBlockEntity;
import dev.lucaargolo.charta.client.ModRenderType;
import dev.lucaargolo.charta.compat.IrisCompat;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.game.GameSlot;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class CardTableBlockEntityRenderer
implements BlockEntityRenderer<CardTableBlockEntity> {
    private final BlockEntityRendererProvider.Context context;

    public CardTableBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(@NotNull CardTableBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Deck deck = blockEntity.getDeck();
        ItemStack deckStack = blockEntity.getDeckStack();
        poseStack.pushPose();
        poseStack.translate(0.0, 0.85, 1.0);
        poseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
        int gameSlots = blockEntity.getSlotCount();
        if (deck != null && gameSlots > 0) {
            for (int i = 0; i < gameSlots; ++i) {
                float topOffset;
                float leftOffset;
                float maxHeight;
                float maxWidth;
                GameSlot slot = blockEntity.getSlot(i);
                float x = slot.lerpX(partialTick);
                float y = slot.lerpY(partialTick);
                float z = slot.lerpZ(partialTick);
                float angle = slot.lerpAngle(partialTick);
                Direction stackDirection = slot.getStackDirection();
                int cards = slot.size();
                float f = stackDirection.getAxis().isVertical() ? 0.0f : (maxWidth = angle % 180.0f == 0.0f && stackDirection.getAxis() == Direction.Axis.Z ? 0.0f : slot.getMaxStack());
                float cardWidth = stackDirection.getAxis().isVertical() ? 0.0f : (angle % 180.0f == 0.0f && stackDirection.getAxis() == Direction.Axis.Z ? 0.0f : 25.0f);
                float maxLeftOffset = cardWidth + cardWidth / 10.0f;
                float f2 = stackDirection.getAxis().isVertical() ? 0.0f : (maxHeight = angle % 180.0f == 0.0f && stackDirection.getAxis() == Direction.Axis.Z ? slot.getMaxStack() : 0.0f);
                float cardHeight = stackDirection.getAxis().isVertical() ? 0.0f : (angle % 180.0f == 0.0f && stackDirection.getAxis() == Direction.Axis.Z ? 35.0f : 0.0f);
                float maxTopOffset = cardHeight + cardHeight / 10.0f;
                float left = 0.0f;
                float top = 0.0f;
                if (slot.isCentered()) {
                    float totalHeight;
                    float topExcess;
                    leftOffset = cardWidth + Math.max(0.0f, maxWidth - (float)cards * cardWidth / (float)cards);
                    float totalWidth = cardWidth + leftOffset * ((float)cards - 1.0f);
                    float leftExcess = totalWidth - maxWidth;
                    if (leftExcess > 0.0f) {
                        leftOffset -= leftExcess / ((float)cards - 1.0f);
                    }
                    totalWidth = cardWidth + maxLeftOffset * ((float)cards - 1.0f);
                    left = 0.0f;
                    if (leftOffset > maxLeftOffset) {
                        left = Math.max(leftOffset - maxLeftOffset, maxWidth - totalWidth);
                        leftOffset = maxLeftOffset;
                    }
                    if ((topExcess = (totalHeight = cardHeight + (topOffset = cardHeight + Math.max(0.0f, maxHeight - (float)cards * cardHeight / (float)cards)) * ((float)cards - 1.0f)) - maxHeight) > 0.0f) {
                        topOffset -= topExcess / ((float)cards - 1.0f);
                    }
                    totalHeight = cardHeight + maxTopOffset * ((float)cards - 1.0f);
                    top = 0.0f;
                    if (topOffset > maxTopOffset) {
                        top = Math.max(topOffset - maxTopOffset, maxHeight - totalHeight);
                        topOffset = maxTopOffset;
                    }
                } else {
                    float f3 = stackDirection.getAxis().isVertical() ? 0.0f : (leftOffset = angle % 180.0f == 0.0f && stackDirection.getAxis() == Direction.Axis.Z ? 0.0f : 5.0f);
                    if (leftOffset * (float)(slot.size() - 1) + cardWidth > maxWidth) {
                        leftOffset = (maxWidth - cardWidth) / (float)(slot.size() - 1);
                    }
                    float f4 = stackDirection.getAxis().isVertical() ? 0.0f : (topOffset = angle % 180.0f == 0.0f && stackDirection.getAxis() == Direction.Axis.Z ? 7.5f : 0.0f);
                    if (topOffset * (float)(slot.size() - 1) + cardHeight > maxHeight) {
                        topOffset = (maxHeight - cardHeight) / (float)(slot.size() - 1);
                    }
                }
                Vector3f normal = new Vector3f(0.0f, -1.0f, 0.0f);
                normal.rotateAxis(90.0f, -1.0f, 0.0f, 0.0f);
                normal.rotateAxis(angle, 0.0f, 0.0f, -1.0f);
                int o = 0;
                for (Card card : slot.getCards()) {
                    poseStack.pushPose();
                    poseStack.scale(0.00625f, 0.00625f, 0.00625f);
                    poseStack.translate(x, y, z + (float)o * 0.01f);
                    if (stackDirection.getAxis().isVertical()) {
                        poseStack.translate(0.0f, 0.0f, (float)o * 0.25f * (float)stackDirection.getNormal().getY());
                    }
                    poseStack.mulPose(Axis.ZN.rotationDegrees(angle));
                    poseStack.translate((double)((float)o * leftOffset), (double)((float)o * topOffset), 0.0);
                    poseStack.scale(160.0f, 160.0f, 160.0f);
                    if (slot.isCentered()) {
                        CardTableBlockEntityRenderer.drawCard(deck, card, packedLight, packedOverlay, poseStack, bufferSource, left / 2.0f, top / 2.0f, normal);
                    } else {
                        CardTableBlockEntityRenderer.drawCard(deck, card, packedLight, packedOverlay, poseStack, bufferSource, 0.0f, 0.0f, normal);
                    }
                    poseStack.popPose();
                    ++o;
                }
            }
        } else if (!deckStack.isEmpty()) {
            poseStack.translate(0.5 + (double)blockEntity.centerOffset.x, 0.275 + (double)blockEntity.centerOffset.y, 0.0);
            this.context.getItemRenderer().renderStatic(deckStack, ItemDisplayContext.GROUND, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), 1);
        }
        poseStack.popPose();
    }

    public static void drawCard(Deck deck, Card card, int packedLight, int packedOverlay, PoseStack poseStack, MultiBufferSource bufferSource, float x, float y, Vector3f normal) {
        PoseStack.Pose entry = poseStack.last();
        if (IrisCompat.isPresent()) {
            ResourceLocation glowTexture = card.flipped() ? deck.getDeckTexture(true) : deck.getCardTexture(card, true);
            RenderType glowType = RenderType.entityTranslucentEmissive((ResourceLocation)glowTexture);
            VertexConsumer glowConsumer = bufferSource.getBuffer(glowType);
            glowConsumer.addVertex(entry.pose(), (x + 25.0f) / 160.0f, y / 160.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 1.0f).setOverlay(packedOverlay).setLight(0xF000F0).setNormal(entry, normal.x, normal.y, normal.z);
            glowConsumer.addVertex(entry.pose(), (x + 25.0f) / 160.0f, (y + 35.0f) / 160.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 0.0f).setOverlay(packedOverlay).setLight(0xF000F0).setNormal(entry, normal.x, normal.y, normal.z);
            glowConsumer.addVertex(entry.pose(), x / 160.0f, (y + 35.0f) / 160.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 0.0f).setOverlay(packedOverlay).setLight(0xF000F0).setNormal(entry, normal.x, normal.y, normal.z);
            glowConsumer.addVertex(entry.pose(), x / 160.0f, y / 160.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 1.0f).setOverlay(packedOverlay).setLight(0xF000F0).setNormal(entry, normal.x, normal.y, normal.z);
        }
        ResourceLocation texture = card.flipped() ? deck.getDeckTexture(false) : deck.getCardTexture(card, false);
        RenderType type = IrisCompat.isPresent() ? RenderType.entityTranslucent((ResourceLocation)texture) : ModRenderType.entityCard(texture);
        VertexConsumer consumer = bufferSource.getBuffer(type);
        consumer.addVertex(entry.pose(), (x + 25.0f) / 160.0f, y / 160.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 1.0f).setOverlay(packedOverlay).setLight(packedLight).setNormal(entry, normal.x, normal.y, normal.z);
        consumer.addVertex(entry.pose(), (x + 25.0f) / 160.0f, (y + 35.0f) / 160.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 0.0f).setOverlay(packedOverlay).setLight(packedLight).setNormal(entry, normal.x, normal.y, normal.z);
        consumer.addVertex(entry.pose(), x / 160.0f, (y + 35.0f) / 160.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 0.0f).setOverlay(packedOverlay).setLight(packedLight).setNormal(entry, normal.x, normal.y, normal.z);
        consumer.addVertex(entry.pose(), x / 160.0f, y / 160.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 1.0f).setOverlay(packedOverlay).setLight(packedLight).setNormal(entry, normal.x, normal.y, normal.z);
    }
}

