/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.client;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.blockentity.ModBlockEntityTypes;
import dev.lucaargolo.charta.client.blockentity.BarShelfBlockEntityRenderer;
import dev.lucaargolo.charta.client.blockentity.CardTableBlockEntityRenderer;
import dev.lucaargolo.charta.client.entity.IronLeashKnotRenderer;
import dev.lucaargolo.charta.client.item.DeckItemExtensions;
import dev.lucaargolo.charta.compat.IrisCompat;
import dev.lucaargolo.charta.entity.ModEntityTypes;
import dev.lucaargolo.charta.game.crazyeights.CrazyEightsScreen;
import dev.lucaargolo.charta.game.fun.FunScreen;
import dev.lucaargolo.charta.game.solitaire.SolitaireScreen;
import dev.lucaargolo.charta.item.ModItems;
import dev.lucaargolo.charta.menu.ModMenus;
import dev.lucaargolo.charta.resources.MarkdownResource;
import dev.lucaargolo.charta.utils.CardImageUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import org.apache.commons.lang3.tuple.Triple;

@OnlyIn(value=Dist.CLIENT)
public class ChartaClient {
    public static final LinkedList<Triple<Component, Integer, Component>> LOCAL_HISTORY = new LinkedList();
    public static final HashMap<ResourceLocation, byte[]> LOCAL_OPTIONS = new HashMap();
    private static final ResourceLocation BLUR_LOCATION = Charta.id("shaders/post/blur.json");
    private static RenderTarget glowRenderTarget;
    private static PostChain glowBlurEffect;
    public static ShaderInstance IMAGE_SHADER;
    public static ShaderInstance IMAGE_GLOW_SHADER;
    public static ShaderInstance IMAGE_ARGB_SHADER;
    public static ShaderInstance WHITE_IMAGE_SHADER;
    public static ShaderInstance WHITE_IMAGE_GLOW_SHADER;
    public static ShaderInstance WHITE_IMAGE_ARGB_SHADER;
    public static ShaderInstance CARD_SHADER;
    public static ShaderInstance CARD_GLOW_SHADER;
    public static ShaderInstance CARD_ARGB_SHADER;
    public static ShaderInstance PERSPECTIVE_SHADER;
    public static ShaderInstance GRAYSCALE_SHADER;
    private static final List<Consumer<Float>> cardFovUniforms;
    public static Consumer<Float> CARD_FOV;
    private static final List<Consumer<Float>> cardXRotUniforms;
    public static Consumer<Float> CARD_X_ROT;
    private static final List<Consumer<Float>> cardYRotUniforms;
    public static Consumer<Float> CARD_Y_ROT;
    private static final List<Consumer<Float>> cardInsetUniforms;
    public static Consumer<Float> CARD_INSET;
    public static ShaderInstance ENTITY_CARD_SHADER;
    public static ShaderInstance IRON_LEASH_SHADER;
    public static final MarkdownResource MARKDOWN;

    public static void generateImages() {
        Minecraft client = Minecraft.getInstance();
        TextureManager manager = client.getTextureManager();
        manager.register(Charta.MISSING_SUIT, (AbstractTexture)CardImageUtils.convertImage(CardImageUtils.EMPTY_SUIT, IrisCompat.isPresent(), false));
        Charta.SUIT_IMAGES.getImages().forEach((id, image) -> {
            ResourceLocation suitId = ChartaClient.getSuitTexture(id);
            manager.register(suitId, (AbstractTexture)CardImageUtils.convertImage(image, IrisCompat.isPresent(), false));
        });
        manager.register(Charta.MISSING_CARD, (AbstractTexture)CardImageUtils.convertImage(CardImageUtils.EMPTY_CARD, IrisCompat.isPresent(), false));
        Charta.CARD_IMAGES.getImages().forEach((id, image) -> {
            ResourceLocation cardId = ChartaClient.getCardTexture(id);
            manager.register(cardId, (AbstractTexture)CardImageUtils.convertImage(image, IrisCompat.isPresent(), false));
        });
        Charta.DECK_IMAGES.getImages().forEach((id, image) -> {
            ResourceLocation deckId = ChartaClient.getDeckTexture(id);
            manager.register(deckId, (AbstractTexture)CardImageUtils.convertImage(image, IrisCompat.isPresent(), false));
        });
        IrisCompat.generateImages();
    }

    public static ResourceLocation getSuitTexture(ResourceLocation location) {
        if (Charta.SUIT_IMAGES.getImages().containsKey(location)) {
            return location.withPrefix("suit/");
        }
        return Charta.MISSING_SUIT;
    }

    public static ResourceLocation getCardTexture(ResourceLocation location) {
        if (Charta.CARD_IMAGES.getImages().containsKey(location)) {
            return location.withPrefix("card/");
        }
        return Charta.MISSING_CARD;
    }

    public static ResourceLocation getDeckTexture(ResourceLocation location) {
        if (Charta.DECK_IMAGES.getImages().containsKey(location)) {
            return location.withPrefix("deck/");
        }
        return Charta.MISSING_CARD;
    }

    public static void clearImages() {
        Minecraft client = Minecraft.getInstance();
        TextureManager manager = client.getTextureManager();
        manager.release(Charta.MISSING_SUIT);
        Charta.SUIT_IMAGES.getImages().keySet().stream().map(ChartaClient::getSuitTexture).forEach(arg_0 -> ((TextureManager)manager).release(arg_0));
        Charta.SUIT_IMAGES.getImages().clear();
        manager.release(Charta.MISSING_CARD);
        Charta.CARD_IMAGES.getImages().keySet().stream().map(ChartaClient::getCardTexture).forEach(arg_0 -> ((TextureManager)manager).release(arg_0));
        Charta.DECK_IMAGES.getImages().keySet().stream().map(ChartaClient::getDeckTexture).forEach(arg_0 -> ((TextureManager)manager).release(arg_0));
        IrisCompat.clearImages();
        Charta.CARD_IMAGES.getImages().clear();
        Charta.DECK_IMAGES.getImages().clear();
    }

    public static void processBlurEffect(float partialTick) {
        float f = 2.0f;
        if (glowBlurEffect != null) {
            glowBlurEffect.setUniform("Radius", f);
            glowBlurEffect.process(partialTick);
        }
    }

    public static RenderTarget getGlowRenderTarget() {
        return glowRenderTarget;
    }

    public static PostChain getGlowBlurEffect() {
        return glowBlurEffect;
    }

    private static void loadGlowBlurEffect(ResourceProvider resourceProvider) {
        Minecraft minecraft = Minecraft.getInstance();
        if (glowBlurEffect != null) {
            glowBlurEffect.close();
        }
        try {
            glowBlurEffect = new PostChain(minecraft.getTextureManager(), resourceProvider, ChartaClient.getGlowRenderTarget(), BLUR_LOCATION);
            glowBlurEffect.resize(minecraft.getWindow().getWidth(), minecraft.getWindow().getHeight());
        }
        catch (IOException ioexception) {
            Charta.LOGGER.warn("Failed to load shader: {}", (Object)BLUR_LOCATION, (Object)ioexception);
        }
        catch (JsonSyntaxException jsonsyntaxexception) {
            Charta.LOGGER.warn("Failed to parse shader: {}", (Object)BLUR_LOCATION, (Object)jsonsyntaxexception);
        }
    }

    @Nullable
    public static ShaderInstance getImageShader() {
        return IMAGE_SHADER;
    }

    @Nullable
    public static ShaderInstance getImageGlowShader() {
        return IMAGE_GLOW_SHADER;
    }

    @Nullable
    public static ShaderInstance getImageArgbShader() {
        return IMAGE_ARGB_SHADER;
    }

    @Nullable
    public static ShaderInstance getWhiteImageShader() {
        return WHITE_IMAGE_SHADER;
    }

    @Nullable
    public static ShaderInstance getWhiteImageGlowShader() {
        return WHITE_IMAGE_GLOW_SHADER;
    }

    @Nullable
    public static ShaderInstance getWhiteImageArgbShader() {
        return WHITE_IMAGE_ARGB_SHADER;
    }

    @Nullable
    public static ShaderInstance getCardShader() {
        return CARD_SHADER;
    }

    @Nullable
    public static ShaderInstance getCardGlowShader() {
        return CARD_GLOW_SHADER;
    }

    @Nullable
    public static ShaderInstance getCardArgbShader() {
        return CARD_ARGB_SHADER;
    }

    @Nullable
    public static ShaderInstance getPerspectiveShader() {
        return PERSPECTIVE_SHADER;
    }

    @Nullable
    public static ShaderInstance getGrayscaleShader() {
        return GRAYSCALE_SHADER;
    }

    static {
        cardFovUniforms = new ArrayList<Consumer<Float>>();
        CARD_FOV = f -> cardFovUniforms.forEach(c -> c.accept(f));
        cardXRotUniforms = new ArrayList<Consumer<Float>>();
        CARD_X_ROT = f -> cardXRotUniforms.forEach(c -> c.accept(f));
        cardYRotUniforms = new ArrayList<Consumer<Float>>();
        CARD_Y_ROT = f -> cardYRotUniforms.forEach(c -> c.accept(f));
        cardInsetUniforms = new ArrayList<Consumer<Float>>();
        CARD_INSET = f -> cardInsetUniforms.forEach(c -> c.accept(f));
        MARKDOWN = new MarkdownResource();
    }

    @OnlyIn(value=Dist.CLIENT)
    @EventBusSubscriber(modid="charta", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            Minecraft minecraft = Minecraft.getInstance();
            minecraft.submit(() -> {
                glowRenderTarget = new TextureTarget(minecraft.getWindow().getWidth(), minecraft.getWindow().getHeight(), false, Minecraft.ON_OSX);
                glowRenderTarget.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                glowRenderTarget.clear(Minecraft.ON_OSX);
            });
        }

        @SubscribeEvent
        public static void registerCoverModel(ModelEvent.RegisterAdditional event) {
            event.register(new ModelResourceLocation(Charta.id("deck"), "standalone"));
        }

        @SubscribeEvent
        public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
            event.registerItem((IClientItemExtensions)new DeckItemExtensions(), new Item[]{(Item)ModItems.DECK.get()});
        }

        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)ModEntityTypes.SEAT.get(), NoopRenderer::new);
            event.registerEntityRenderer((EntityType)ModEntityTypes.IRON_LEASH_KNOT.get(), IronLeashKnotRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.CARD_TABLE.get(), CardTableBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.BAR_SHELF.get(), BarShelfBlockEntityRenderer::new);
        }

        @SubscribeEvent
        public static void addReloadListeners(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)MARKDOWN);
        }

        @SubscribeEvent
        public static void registerMenuScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)ModMenus.CRAZY_EIGHTS.get(), CrazyEightsScreen::new);
            event.register((MenuType)ModMenus.FUN.get(), FunScreen::new);
            event.register((MenuType)ModMenus.SOLITAIRE.get(), SolitaireScreen::new);
        }

        @SubscribeEvent
        public static void registerShaders(RegisterShadersEvent event) throws IOException {
            ChartaClient.loadGlowBlurEffect(event.getResourceProvider());
            cardFovUniforms.clear();
            cardXRotUniforms.clear();
            cardYRotUniforms.clear();
            cardInsetUniforms.clear();
            event.registerShader(new ShaderInstance(event.getResourceProvider(), Charta.id("image"), DefaultVertexFormat.POSITION_TEX_COLOR), instance -> {
                IMAGE_SHADER = instance;
            });
            event.registerShader(new ShaderInstance(event.getResourceProvider(), Charta.id("image_glow"), DefaultVertexFormat.POSITION_TEX_COLOR), instance -> {
                IMAGE_GLOW_SHADER = instance;
            });
            event.registerShader(new ShaderInstance(event.getResourceProvider(), Charta.id("image_argb"), DefaultVertexFormat.POSITION_TEX_COLOR), instance -> {
                IMAGE_ARGB_SHADER = instance;
            });
            event.registerShader(new ShaderInstance(event.getResourceProvider(), Charta.id("white_image"), DefaultVertexFormat.POSITION_TEX_COLOR), instance -> {
                WHITE_IMAGE_SHADER = instance;
            });
            event.registerShader(new ShaderInstance(event.getResourceProvider(), Charta.id("white_image_glow"), DefaultVertexFormat.POSITION_TEX_COLOR), instance -> {
                WHITE_IMAGE_GLOW_SHADER = instance;
            });
            event.registerShader(new ShaderInstance(event.getResourceProvider(), Charta.id("white_image_argb"), DefaultVertexFormat.POSITION_TEX_COLOR), instance -> {
                WHITE_IMAGE_ARGB_SHADER = instance;
            });
            event.registerShader(new ShaderInstance(event.getResourceProvider(), Charta.id("card"), DefaultVertexFormat.POSITION_TEX_COLOR), instance -> {
                cardFovUniforms.add(arg_0 -> ((Uniform)Objects.requireNonNull(instance.getUniform("Fov"))).set(arg_0));
                cardXRotUniforms.add(arg_0 -> ((Uniform)Objects.requireNonNull(instance.getUniform("XRot"))).set(arg_0));
                cardYRotUniforms.add(arg_0 -> ((Uniform)Objects.requireNonNull(instance.getUniform("YRot"))).set(arg_0));
                cardInsetUniforms.add(arg_0 -> ((Uniform)Objects.requireNonNull(instance.getUniform("InSet"))).set(arg_0));
                CARD_SHADER = instance;
            });
            event.registerShader(new ShaderInstance(event.getResourceProvider(), Charta.id("card_glow"), DefaultVertexFormat.POSITION_TEX_COLOR), instance -> {
                cardFovUniforms.add(arg_0 -> ((Uniform)Objects.requireNonNull(instance.getUniform("Fov"))).set(arg_0));
                cardXRotUniforms.add(arg_0 -> ((Uniform)Objects.requireNonNull(instance.getUniform("XRot"))).set(arg_0));
                cardYRotUniforms.add(arg_0 -> ((Uniform)Objects.requireNonNull(instance.getUniform("YRot"))).set(arg_0));
                cardInsetUniforms.add(arg_0 -> ((Uniform)Objects.requireNonNull(instance.getUniform("InSet"))).set(arg_0));
                CARD_GLOW_SHADER = instance;
            });
            event.registerShader(new ShaderInstance(event.getResourceProvider(), Charta.id("card_argb"), DefaultVertexFormat.POSITION_TEX_COLOR), instance -> {
                cardFovUniforms.add(arg_0 -> ((Uniform)Objects.requireNonNull(instance.getUniform("Fov"))).set(arg_0));
                cardXRotUniforms.add(arg_0 -> ((Uniform)Objects.requireNonNull(instance.getUniform("XRot"))).set(arg_0));
                cardYRotUniforms.add(arg_0 -> ((Uniform)Objects.requireNonNull(instance.getUniform("YRot"))).set(arg_0));
                cardInsetUniforms.add(arg_0 -> ((Uniform)Objects.requireNonNull(instance.getUniform("InSet"))).set(arg_0));
                CARD_ARGB_SHADER = instance;
            });
            event.registerShader(new ShaderInstance(event.getResourceProvider(), Charta.id("perspective"), DefaultVertexFormat.POSITION_TEX_COLOR), instance -> {
                cardFovUniforms.add(arg_0 -> ((Uniform)Objects.requireNonNull(instance.getUniform("Fov"))).set(arg_0));
                cardXRotUniforms.add(arg_0 -> ((Uniform)Objects.requireNonNull(instance.getUniform("XRot"))).set(arg_0));
                cardYRotUniforms.add(arg_0 -> ((Uniform)Objects.requireNonNull(instance.getUniform("YRot"))).set(arg_0));
                cardInsetUniforms.add(arg_0 -> ((Uniform)Objects.requireNonNull(instance.getUniform("InSet"))).set(arg_0));
                PERSPECTIVE_SHADER = instance;
            });
            event.registerShader(new ShaderInstance(event.getResourceProvider(), Charta.id("grayscale"), DefaultVertexFormat.POSITION_TEX_COLOR), instance -> {
                GRAYSCALE_SHADER = instance;
            });
            event.registerShader(new ShaderInstance(event.getResourceProvider(), Charta.id("rendertype_entity_card"), DefaultVertexFormat.NEW_ENTITY), instance -> {
                ENTITY_CARD_SHADER = instance;
            });
            event.registerShader(new ShaderInstance(event.getResourceProvider(), Charta.id("rendertype_iron_leash"), DefaultVertexFormat.POSITION_COLOR_LIGHTMAP), instance -> {
                IRON_LEASH_SHADER = instance;
            });
        }
    }
}

