/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.blockentity;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import dev.lucaargolo.charta.block.CardTableBlock;
import dev.lucaargolo.charta.block.GameChairBlock;
import dev.lucaargolo.charta.block.SeatBlock;
import dev.lucaargolo.charta.blockentity.ModBlockEntityTypes;
import dev.lucaargolo.charta.entity.SeatEntity;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardGames;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.item.DeckItem;
import dev.lucaargolo.charta.mixed.LivingEntityMixed;
import dev.lucaargolo.charta.network.GameSlotCompletePayload;
import dev.lucaargolo.charta.network.GameSlotPositionPayload;
import dev.lucaargolo.charta.network.GameSlotResetPayload;
import dev.lucaargolo.charta.network.GameStartPayload;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;

public class CardTableBlockEntity
extends BlockEntity {
    public static final int TABLE_WIDTH = 160;
    public static final int TABLE_HEIGHT = 160;
    private static final Predicate<Vector2i> PY = pos -> pos.x == 0 && pos.y > 0;
    private static final Predicate<Vector2i> PX_PY = pos -> pos.x > 0 && pos.y > 0;
    private static final Predicate<Vector2i> PX = pos -> pos.x > 0 && pos.y == 0;
    private static final Predicate<Vector2i> PX_NY = pos -> pos.x > 0 && pos.y < 0;
    private static final Predicate<Vector2i> NY = pos -> pos.x == 0 && pos.y < 0;
    private static final Predicate<Vector2i> NX_XY = pos -> pos.x < 0 && pos.y < 0;
    private static final Predicate<Vector2i> NX = pos -> pos.x < 0 && pos.y == 0;
    private static final Predicate<Vector2i> NX_PY = pos -> pos.x < 0 && pos.y > 0;
    private static final Predicate<Vector2i>[] PREDICATES = new Predicate[]{PY, PX_PY, PX, PX_NY, NY, NX_XY, NX, NX_PY};
    private final List<GameSlot> trackedSlots = new ArrayList<GameSlot>();
    private final Set<Integer> dirtySlotCards = new HashSet<Integer>();
    private final Set<Integer> dirtySlotPositions = new HashSet<Integer>();
    private ItemStack deckStack = ItemStack.EMPTY;
    public Vector2f centerOffset = new Vector2f();
    @Nullable
    private CardGame<?> game = null;
    private int age = 0;
    public boolean playersDirty = true;

    public CardTableBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.CARD_TABLE.get(), pos, blockState);
    }

    @Nullable
    public Deck getDeck() {
        return DeckItem.getDeck(this.deckStack);
    }

    @Nullable
    public CardGame<?> getGame() {
        return this.game;
    }

    public Component startGame(@Nullable ResourceLocation gameId, byte[] options) {
        Deck deck = this.getDeck();
        if (deck != null) {
            if (gameId != null) {
                List<CardPlayer> players = this.getOrderedPlayers();
                CardGames.Factory<?> factory = CardGames.getGame(gameId);
                if (factory != null) {
                    Object game = factory.create(players, this.getDeck());
                    ((CardGame)game).setRawOptions(options);
                    if (CardGame.isValidDeck(game, this.getDeck())) {
                        if (players.size() >= ((CardGame)game).getMinPlayers()) {
                            if (players.size() <= ((CardGame)game).getMaxPlayers()) {
                                Either<CardGame<?>, Component> either = ((CardGame)game).playerPredicate(players);
                                if (either.left().isPresent()) {
                                    LivingEntity entity;
                                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)new ChunkPos(this.worldPosition), (CustomPacketPayload)new GameSlotResetPayload(this.worldPosition), (CustomPacketPayload[])new CustomPacketPayload[0]);
                                    for (CardPlayer player : players) {
                                        entity = player.getEntity();
                                        if (!(entity instanceof ServerPlayer)) continue;
                                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                                        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new GameStartPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                                    }
                                    this.resetSlots();
                                    this.game = game;
                                    this.game.startGame();
                                    this.game.runGame();
                                    for (GameSlot slot : this.game.getSlots()) {
                                        slot.setX(slot.getX() + this.centerOffset.x * 160.0f);
                                        slot.setY(slot.getY() + this.centerOffset.y * 160.0f);
                                        slot.setParent(this);
                                        this.addSlot(slot);
                                    }
                                    for (CardPlayer player : players) {
                                        entity = player.getEntity();
                                        if (entity != null) {
                                            Vector3f offset = entity.position().subtract((double)this.worldPosition.getX() + 0.5, entity.getY(), (double)this.worldPosition.getZ() + 0.5).toVector3f();
                                            Direction direction = GameChairBlock.getSeatedDirection(entity);
                                            if (direction != null) {
                                                float angle = switch (direction) {
                                                    case Direction.EAST -> 90.0f;
                                                    case Direction.SOUTH -> 180.0f;
                                                    case Direction.WEST -> 270.0f;
                                                    default -> 0.0f;
                                                };
                                                float x = switch (direction) {
                                                    case Direction.NORTH -> 40.0f + 160.0f * offset.x;
                                                    case Direction.EAST -> -147.5f + 160.0f * (offset.x + 2.0f);
                                                    case Direction.SOUTH -> 120.0f + 160.0f * offset.x;
                                                    case Direction.WEST -> 307.5f + 160.0f * (offset.x - 2.0f);
                                                    default -> 0.0f;
                                                };
                                                float y = switch (direction) {
                                                    case Direction.NORTH -> -147.5f - 160.0f * (offset.z - 2.0f);
                                                    case Direction.EAST -> 120.0f - 160.0f * offset.z;
                                                    case Direction.SOUTH -> 307.5f - 160.0f * (offset.z + 2.0f);
                                                    case Direction.WEST -> 12.5f - 160.0f * offset.z + 27.5f;
                                                    default -> 0.0f;
                                                };
                                                GameSlot slot = ((CardGame)game).getCensoredHand(player);
                                                slot.setX(x);
                                                slot.setY(y);
                                                slot.setAngle(angle);
                                                slot.setStackDirection(direction.getClockWise());
                                                slot.setParent(this);
                                                slot.setIndex(this.getSlotCount());
                                                this.addSlot(slot);
                                            }
                                        }
                                        player.openScreen(this.game, this.worldPosition, deck);
                                    }
                                    return Component.translatable((String)"message.charta.game_started").withStyle(ChatFormatting.GREEN);
                                }
                                this.game = null;
                                return ((Component)either.right().orElse(Component.translatable((String)"message.charta.invalid_players"))).copy().withStyle(ChatFormatting.RED);
                            }
                            this.game = null;
                            return Component.translatable((String)"message.charta.too_many_players", (Object[])new Object[]{((CardGame)game).getMaxPlayers()}).withStyle(ChatFormatting.RED);
                        }
                        this.game = null;
                        return Component.translatable((String)"message.charta.not_enough_players", (Object[])new Object[]{((CardGame)game).getMinPlayers()}).withStyle(ChatFormatting.RED);
                    }
                    this.game = null;
                    return Component.translatable((String)"message.charta.cant_play_deck").withStyle(ChatFormatting.RED);
                }
                this.game = null;
                return Component.translatable((String)"message.charta.table_unknown_game").withStyle(ChatFormatting.RED);
            }
            this.game = null;
            return Component.translatable((String)"message.charta.table_no_game").withStyle(ChatFormatting.RED);
        }
        this.game = null;
        return Component.translatable((String)"message.charta.table_no_deck").withStyle(ChatFormatting.RED);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.deckStack.isEmpty()) {
            tag.put("deckStack", this.deckStack.save(registries));
        } else {
            tag.put("deckStack", (Tag)new CompoundTag());
        }
        tag.putFloat("centerOffsetX", this.centerOffset.x);
        tag.putFloat("centerOffsetY", this.centerOffset.y);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("deckStack")) {
            CompoundTag compoundTag;
            Tag deckTag = tag.get("deckStack");
            if (deckTag instanceof CompoundTag && !(compoundTag = (CompoundTag)deckTag).getAllKeys().isEmpty()) {
                ItemStack.parse((HolderLookup.Provider)registries, (Tag)deckTag).ifPresentOrElse(this::setDeckStack, () -> this.setDeckStack(ItemStack.EMPTY));
            } else {
                this.setDeckStack(ItemStack.EMPTY);
            }
        }
        this.centerOffset.x = tag.getFloat("centerOffsetX");
        this.centerOffset.y = tag.getFloat("centerOffsetY");
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        this.resetSlots();
        super.handleUpdateTag(tag, lookupProvider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public ItemStack getDeckStack() {
        return this.deckStack;
    }

    public void setDeckStack(ItemStack deckStack) {
        this.deckStack = deckStack;
        this.setChanged();
    }

    public GameSlot getSlot(int index) {
        return this.trackedSlots.get(index);
    }

    public void addSlot(GameSlot slot) {
        this.dirtySlotCards.add(this.getSlotCount());
        this.trackedSlots.add(slot);
    }

    public void setSlotDirty(int index, boolean cards) {
        if (cards) {
            this.dirtySlotCards.add(index);
        } else {
            this.dirtySlotPositions.add(index);
        }
    }

    public int getSlotCount() {
        return this.trackedSlots.size();
    }

    public void resetSlots() {
        this.trackedSlots.forEach(GameSlot::clear);
        this.trackedSlots.clear();
        this.dirtySlotCards.clear();
        this.dirtySlotPositions.clear();
    }

    public List<LivingEntity> getPlayers() {
        BlockState state;
        Block block;
        ArrayList<LivingEntity> players = new ArrayList<LivingEntity>();
        if (this.level != null && (block = (state = this.level.getBlockState(this.worldPosition)).getBlock()) instanceof CardTableBlock) {
            CardTableBlock cardTable = (CardTableBlock)block;
            Set<BlockPos> set = cardTable.getMultiblock((LevelAccessor)this.level, this.worldPosition);
            HashSet<BlockPos> chairs = new HashSet<BlockPos>();
            for (BlockPos pos : set) {
                if (!set.contains(pos.north())) {
                    chairs.add(pos.north());
                }
                if (!set.contains(pos.south())) {
                    chairs.add(pos.south());
                }
                if (!set.contains(pos.east())) {
                    chairs.add(pos.east());
                }
                if (set.contains(pos.west())) continue;
                chairs.add(pos.west());
            }
            for (BlockPos pos : chairs) {
                Object e;
                List passengers;
                List seats;
                BlockState chairState = this.level.getBlockState(pos);
                if (!(chairState.getBlock() instanceof GameChairBlock) || !set.contains(pos.relative((Direction)chairState.getValue((Property)GameChairBlock.FACING))) || !SeatBlock.isSeatOccupied(this.level, pos) || (seats = this.level.getEntitiesOfClass(SeatEntity.class, new AABB(pos))).isEmpty() || (passengers = ((SeatEntity)((Object)seats.getFirst())).getPassengers()).isEmpty() || !((e = passengers.getFirst()) instanceof LivingEntity)) continue;
                LivingEntity entity = (LivingEntity)e;
                players.add(entity);
            }
        }
        return players;
    }

    private List<CardPlayer> getOrderedPlayers() {
        List<LivingEntity> players = this.getPlayers();
        if (players.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList entries = new LinkedList();
        Vec3 center = this.worldPosition.getCenter();
        players.forEach(player -> {
            Vector2i pos = new Vector2i(Mth.floor((double)((player.getX() - center.x) * 2.0)), Mth.floor((double)((player.getZ() - center.z) * 2.0)));
            entries.add(new Pair((Object)pos, (Object)((LivingEntityMixed)player).charta_getCardPlayer()));
        });
        Collections.shuffle(entries);
        Pair firstEntry = (Pair)entries.getFirst();
        Vector2i firstPos = (Vector2i)firstEntry.getFirst();
        int firstQuadrant = CardTableBlockEntity.getQuadrant(firstPos);
        ArrayList<Integer> order = new ArrayList<Integer>();
        for (int i = 0; i < PREDICATES.length; ++i) {
            order.add((firstQuadrant + i) % PREDICATES.length);
        }
        entries.sort((a, b) -> {
            int bq;
            Vector2i va = (Vector2i)a.getFirst();
            Vector2i vb = (Vector2i)b.getFirst();
            int aq = CardTableBlockEntity.getQuadrant(va);
            if (aq == (bq = CardTableBlockEntity.getQuadrant(vb))) {
                return switch (aq) {
                    case 0 -> Integer.compare(vb.y, va.y);
                    case 1 -> {
                        if (vb.y != va.y) {
                            yield Integer.compare(vb.y, va.y);
                        }
                        yield Integer.compare(va.x, vb.x);
                    }
                    case 2 -> Integer.compare(vb.x, va.x);
                    case 3 -> {
                        if (vb.x != va.x) {
                            yield Integer.compare(vb.x, va.x);
                        }
                        yield Integer.compare(vb.y, va.y);
                    }
                    case 4 -> Integer.compare(va.y, vb.y);
                    case 5 -> {
                        if (va.y != vb.y) {
                            yield Integer.compare(va.y, vb.y);
                        }
                        yield Integer.compare(vb.x, va.x);
                    }
                    case 6 -> Integer.compare(va.x, vb.x);
                    case 7 -> {
                        if (va.x != vb.x) {
                            yield Integer.compare(va.x, vb.x);
                        }
                        yield Integer.compare(va.y, vb.y);
                    }
                    default -> 0;
                };
            }
            return Integer.compare(order.indexOf(aq), order.indexOf(bq));
        });
        return entries.stream().map(Pair::getSecond).toList().reversed();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CardTableBlockEntity blockEntity) {
        GameSlot slot;
        int index;
        Iterator<Integer> updateIterator = blockEntity.dirtySlotCards.iterator();
        while (updateIterator.hasNext()) {
            index = updateIterator.next();
            slot = blockEntity.trackedSlots.get(index);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new GameSlotCompletePayload(pos, index, slot), (CustomPacketPayload[])new CustomPacketPayload[0]);
            blockEntity.dirtySlotPositions.remove(index);
            updateIterator.remove();
        }
        updateIterator = blockEntity.dirtySlotPositions.iterator();
        while (updateIterator.hasNext()) {
            index = updateIterator.next();
            slot = blockEntity.trackedSlots.get(index);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new GameSlotPositionPayload(pos, index, slot.getX(), slot.getY(), slot.getZ(), slot.getAngle()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            updateIterator.remove();
        }
        if (!((Boolean)state.getValue((Property)CardTableBlock.CLOTH)).booleanValue() && !blockEntity.getDeckStack().isEmpty()) {
            Vec3 c = pos.getCenter();
            Containers.dropItemStack((Level)level, (double)c.x, (double)c.y, (double)c.z, (ItemStack)blockEntity.getDeckStack());
            blockEntity.setDeckStack(ItemStack.EMPTY);
            level.sendBlockUpdated(pos, state, state, 3);
        }
        if (blockEntity.game != null) {
            CardGame<?> game = blockEntity.game;
            if (!game.isGameOver()) {
                if (blockEntity.age++ % 100 == 0 || blockEntity.playersDirty) {
                    List<CardPlayer> players = blockEntity.getOrderedPlayers();
                    if (!players.containsAll(game.getPlayers())) {
                        game.endGame();
                    }
                    blockEntity.playersDirty = false;
                }
                game.tick();
            } else {
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new GameSlotResetPayload(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
                blockEntity.resetSlots();
                blockEntity.game = null;
            }
        }
    }

    private static int getQuadrant(Vector2i pos) {
        int quadrant = 0;
        for (int i = 0; i < PREDICATES.length; ++i) {
            if (!PREDICATES[i].test(pos)) continue;
            quadrant = i;
            break;
        }
        return quadrant;
    }
}

