/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.block;

import dev.lucaargolo.charta.block.ModBlocks;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class WineGlassBlock
extends Block {
    private static final VoxelShape SHAPE = Stream.of(Block.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)0.5, (double)9.5), Block.box((double)6.5, (double)5.0, (double)6.5, (double)9.5, (double)11.0, (double)9.5), Block.box((double)7.5, (double)0.5, (double)7.5, (double)8.5, (double)5.0, (double)8.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final FoodProperties FOOD = new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).effect(() -> new MobEffectInstance(MobEffects.REGENERATION, 1200, 1), 1.0f).effect(() -> new MobEffectInstance(MobEffects.HUNGER, 300, 2), 1.0f).effect(() -> new MobEffectInstance(MobEffects.CONFUSION, 300, 0), 1.0f).build();

    public WineGlassBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (!state.is(ModBlocks.EMPTY_WINE_GLASS)) {
            if (!level.isClientSide()) {
                player.eat(level, this.asItem().getDefaultInstance(), FOOD);
                level.setBlockAndUpdate(pos, ((WineGlassBlock)((Object)ModBlocks.EMPTY_WINE_GLASS.get())).defaultBlockState());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }
}

