/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.block;

import dev.lucaargolo.charta.entity.SeatEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class SeatBlock
extends Block {
    public SeatBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public float seatHeight(BlockState state) {
        return 0.35f;
    }

    public boolean isSittable(BlockState state) {
        return true;
    }

    public BlockPos primaryDismountLocation(Level level, BlockState state, BlockPos pos) {
        return pos;
    }

    public float setRiderRotation(BlockState state, Entity entity) {
        return entity.getYRot();
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (this.tryAndSit(state, level, pos, player)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean tryAndSit(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player) {
        if (player instanceof FakePlayer) {
            return false;
        }
        if (!level.mayInteract(player, pos)) {
            return false;
        }
        if (!this.isSittable(state) || player.isPassenger() || player.isCrouching()) {
            return false;
        }
        if (SeatBlock.isSeatBlocked(level, pos)) {
            return false;
        }
        if (SeatBlock.isSeatOccupied(level, pos)) {
            List seats = level.getEntitiesOfClass(SeatEntity.class, new AABB(pos));
            return SeatBlock.ejectSeatedExceptPlayer(level, (SeatEntity)((Object)seats.getFirst()));
        }
        if (level.isClientSide) {
            return true;
        }
        SeatBlock.sitDown(level, pos, SeatBlock.getLeashed(player).orElse((Entity)player));
        return true;
    }

    public static boolean isSeatBlocked(Level level, BlockPos pos) {
        return !level.getBlockState(pos.above()).getCollisionShape((BlockGetter)level, pos).isEmpty();
    }

    public static boolean isSeatOccupied(Level level, BlockPos pos) {
        return !level.getEntitiesOfClass(SeatEntity.class, new AABB(pos)).isEmpty();
    }

    public static Optional<Entity> getLeashed(Player player) {
        List entities = player.level().getEntities((Entity)null, player.getBoundingBox().inflate(10.0), e -> true);
        for (Entity e2 : entities) {
            Mob mob;
            if (!(e2 instanceof Mob) || (mob = (Mob)e2).getLeashHolder() != player || !SeatBlock.canBePickedUp(e2)) continue;
            return Optional.of(mob);
        }
        return Optional.empty();
    }

    public static boolean ejectSeatedExceptPlayer(Level level, SeatEntity seatEntity) {
        List passengers = seatEntity.getPassengers();
        if (!passengers.isEmpty() && passengers.getFirst() instanceof Player) {
            return false;
        }
        if (!level.isClientSide) {
            seatEntity.ejectPassengers();
        }
        return true;
    }

    public static boolean canBePickedUp(Entity passenger) {
        TamableAnimal ta;
        if (passenger instanceof Player) {
            return false;
        }
        if (passenger instanceof TamableAnimal && !(ta = (TamableAnimal)passenger).isTame()) {
            return false;
        }
        return passenger instanceof LivingEntity;
    }

    public static void sitDown(Level level, BlockPos pos, Entity entity) {
        if (level.isClientSide) {
            return;
        }
        SeatEntity seat = new SeatEntity(level, pos);
        level.addFreshEntity((Entity)seat);
        entity.startRiding((Entity)seat);
        level.updateNeighbourForOutputSignal(pos, level.getBlockState(pos).getBlock());
        if (entity instanceof TamableAnimal) {
            TamableAnimal ta = (TamableAnimal)entity;
            ta.setInSittingPose(true);
        }
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType pathComputationType) {
        return false;
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        return SeatBlock.isSeatOccupied(level, pos) ? 15 : 0;
    }
}

