/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.block;

import dev.lucaargolo.charta.block.BarShelfBlock;
import dev.lucaargolo.charta.block.BarStoolBlock;
import dev.lucaargolo.charta.block.BeerGlassBlock;
import dev.lucaargolo.charta.block.CardTableBlock;
import dev.lucaargolo.charta.block.GameChairBlock;
import dev.lucaargolo.charta.block.WineGlassBlock;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamilies;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"charta");
    public static final Map<WoodType, DeferredHolder<Block, CardTableBlock>> CARD_TABLE_MAP = new HashMap<WoodType, DeferredHolder<Block, CardTableBlock>>();
    public static final Map<WoodType, DeferredHolder<Block, GameChairBlock>> GAME_CHAIR_MAP = new HashMap<WoodType, DeferredHolder<Block, GameChairBlock>>();
    public static final Map<WoodType, DeferredHolder<Block, BarStoolBlock>> BAR_STOOL_MAP = new HashMap<WoodType, DeferredHolder<Block, BarStoolBlock>>();
    public static final Map<WoodType, DeferredHolder<Block, BarShelfBlock>> BAR_SHELF_MAP = new HashMap<WoodType, DeferredHolder<Block, BarShelfBlock>>();
    public static final DeferredHolder<Block, Block> DEALER_TABLE = BLOCKS.register("dealer_table", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final DeferredHolder<Block, BeerGlassBlock> EMPTY_BEER_GLASS;
    public static final DeferredHolder<Block, BeerGlassBlock> WHEAT_BEER_GLASS;
    public static final DeferredHolder<Block, BeerGlassBlock> SORGHUM_BEER_GLASS;
    public static final DeferredHolder<Block, WineGlassBlock> EMPTY_WINE_GLASS;
    public static final DeferredHolder<Block, WineGlassBlock> BERRY_WINE_GLASS;
    public static final DeferredHolder<Block, WineGlassBlock> CACTUS_WINE_GLASS;

    public static void register(IEventBus bus) {
        BLOCKS.register(bus);
    }

    static {
        BlockFamilies.getAllFamilies().filter(f -> f.getRecipeGroupPrefix().orElse("").equals("wooden")).forEach(f -> {
            ResourceKey resourceKey = f.getBaseBlock().builtInRegistryHolder().getKey();
            if (resourceKey != null && resourceKey.location().getNamespace().equals("minecraft")) {
                String woodName = resourceKey.location().withPath(s -> s.replace("_planks", "")).getPath();
                WoodType.values().filter(t -> t.name().equals(woodName)).findFirst().ifPresent(type -> {
                    Supplier<CardTableBlock> tableSupplier = () -> new CardTableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)f.getBaseBlock()));
                    DeferredHolder tableHolder = BLOCKS.register(woodName + "_card_table", tableSupplier);
                    CARD_TABLE_MAP.put((WoodType)type, (DeferredHolder<Block, CardTableBlock>)tableHolder);
                    Supplier<GameChairBlock> chairSupplier = () -> new GameChairBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)f.getBaseBlock()));
                    DeferredHolder chairHolder = BLOCKS.register(woodName + "_game_chair", chairSupplier);
                    GAME_CHAIR_MAP.put((WoodType)type, (DeferredHolder<Block, GameChairBlock>)chairHolder);
                    Supplier<BarStoolBlock> stoolSupplier = () -> new BarStoolBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)f.getBaseBlock()));
                    DeferredHolder stoolHolder = BLOCKS.register(woodName + "_bar_stool", stoolSupplier);
                    BAR_STOOL_MAP.put((WoodType)type, (DeferredHolder<Block, BarStoolBlock>)stoolHolder);
                    Supplier<BarShelfBlock> shelfSupplier = () -> new BarShelfBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)f.getBaseBlock()).noOcclusion());
                    DeferredHolder shelfHolder = BLOCKS.register(woodName + "_bar_shelf", shelfSupplier);
                    BAR_SHELF_MAP.put((WoodType)type, (DeferredHolder<Block, BarShelfBlock>)shelfHolder);
                });
            }
        });
        EMPTY_BEER_GLASS = BLOCKS.register("empty_beer_glass", () -> new BeerGlassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)));
        WHEAT_BEER_GLASS = BLOCKS.register("wheat_beer_glass", () -> new BeerGlassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)));
        SORGHUM_BEER_GLASS = BLOCKS.register("sorghum_beer_glass", () -> new BeerGlassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)));
        EMPTY_WINE_GLASS = BLOCKS.register("empty_wine_glass", () -> new WineGlassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)));
        BERRY_WINE_GLASS = BLOCKS.register("berry_wine_glass", () -> new WineGlassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)));
        CACTUS_WINE_GLASS = BLOCKS.register("cactus_wine_glass", () -> new WineGlassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)));
    }
}

