/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.block;

import dev.lucaargolo.charta.block.BarStoolBlock;
import dev.lucaargolo.charta.block.CardTableBlock;
import dev.lucaargolo.charta.entity.SeatEntity;
import dev.lucaargolo.charta.utils.VoxelShapeUtils;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GameChairBlock
extends BarStoolBlock {
    private static final VoxelShape NORTH_SHAPE = Stream.of(Block.box((double)3.0, (double)5.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)11.0, (double)5.0, (double)5.0, (double)13.0), Block.box((double)3.0, (double)7.0, (double)12.0, (double)13.0, (double)24.0, (double)13.0), Block.box((double)11.0, (double)0.0, (double)11.0, (double)13.0, (double)5.0, (double)13.0), Block.box((double)11.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)5.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)5.0, (double)5.0, (double)5.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SOUTH_SHAPE = VoxelShapeUtils.rotate(NORTH_SHAPE, Direction.SOUTH);
    private static final VoxelShape EAST_SHAPE = VoxelShapeUtils.rotate(NORTH_SHAPE, Direction.EAST);
    private static final VoxelShape WEST_SHAPE = VoxelShapeUtils.rotate(NORTH_SHAPE, Direction.WEST);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public GameChairBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)CLOTH, (Comparable)Boolean.valueOf(false))).setValue((Property)COLOR, (Comparable)DyeColor.WHITE));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, CLOTH, COLOR});
    }

    @Override
    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (this.tryAndSetCloth(state, level, pos, player)) {
            return InteractionResult.SUCCESS;
        }
        if (!((Boolean)state.getValue((Property)CLOTH)).booleanValue()) {
            if (!level.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.charta.put_chair_cloth").withStyle(ChatFormatting.RED), true);
            }
            return InteractionResult.FAIL;
        }
        if (this.tryAndSit(state, level, pos, player)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        Direction facing = this.getValidTable(level, pos);
        if (facing != null) {
            return (BlockState)state.setValue((Property)FACING, (Comparable)facing);
        }
        return Blocks.AIR.defaultBlockState();
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = this.getValidTable((LevelAccessor)context.getLevel(), context.getClickedPos());
        return direction == null ? null : (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    @Nullable
    private Direction getValidTable(LevelAccessor level, BlockPos pos) {
        ArrayList<Direction> valid = new ArrayList<Direction>();
        for (Direction d : Direction.Plane.HORIZONTAL) {
            CardTableBlock block;
            BlockState state = level.getBlockState(pos.relative(d));
            Block block2 = state.getBlock();
            if (!(block2 instanceof CardTableBlock) || !(block = (CardTableBlock)block2).isValidMultiblock(level, pos.relative(d))) continue;
            int connections = 0;
            connections += (Boolean)state.getValue((Property)CardTableBlock.NORTH) != false ? 1 : 0;
            connections += (Boolean)state.getValue((Property)CardTableBlock.SOUTH) != false ? 1 : 0;
            connections += (Boolean)state.getValue((Property)CardTableBlock.EAST) != false ? 1 : 0;
            if ((connections += (Boolean)state.getValue((Property)CardTableBlock.WEST) != false ? 1 : 0) != 3) continue;
            valid.add(d);
        }
        return valid.size() == 1 ? (Direction)valid.getFirst() : null;
    }

    @Nullable
    public static Direction getSeatedDirection(LivingEntity living) {
        Entity entity = living.getVehicle();
        if (entity instanceof SeatEntity) {
            SeatEntity seatEntity = (SeatEntity)entity;
            BlockPos pos = seatEntity.blockPosition();
            BlockState state = living.level().getBlockState(pos);
            if (state.getBlock() instanceof GameChairBlock) {
                return (Direction)state.getValue((Property)FACING);
            }
        }
        return null;
    }
}

