/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.block;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import dev.lucaargolo.charta.blockentity.CardTableBlockEntity;
import dev.lucaargolo.charta.blockentity.ModBlockEntityTypes;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.item.DeckItem;
import dev.lucaargolo.charta.item.ModDataComponentTypes;
import dev.lucaargolo.charta.mixed.LivingEntityMixed;
import dev.lucaargolo.charta.network.TableScreenPayload;
import dev.lucaargolo.charta.utils.DyeColorHelper;
import dev.lucaargolo.charta.utils.VoxelShapeUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockBox;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector2i;

public class CardTableBlock
extends BaseEntityBlock {
    public static final MapCodec<CardTableBlock> CODEC = CardTableBlock.simpleCodec(CardTableBlock::new);
    private static final VoxelShape CENTER = Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    private static final VoxelShape FEET_NORTH_EAST = Block.box((double)10.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)6.0);
    private static final VoxelShape FEET_SOUTH_EAST = VoxelShapeUtils.rotate(FEET_NORTH_EAST, Direction.EAST);
    private static final VoxelShape FEET_SOUTH_WEST = VoxelShapeUtils.rotate(FEET_NORTH_EAST, Direction.SOUTH);
    private static final VoxelShape FEET_NORTH_WEST = VoxelShapeUtils.rotate(FEET_NORTH_EAST, Direction.WEST);
    private static final VoxelShape CORNER_NORTH_WEST = Stream.of(Block.box((double)0.0, (double)13.0, (double)0.0, (double)6.0, (double)15.0, (double)6.0), Block.box((double)0.0, (double)13.0, (double)6.0, (double)6.0, (double)15.0, (double)16.0), Block.box((double)6.0, (double)13.0, (double)0.0, (double)16.0, (double)15.0, (double)6.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape CORNER_NORTH_EAST = VoxelShapeUtils.rotate(CORNER_NORTH_WEST, Direction.EAST);
    private static final VoxelShape CORNER_SOUTH_EAST = VoxelShapeUtils.rotate(CORNER_NORTH_WEST, Direction.SOUTH);
    private static final VoxelShape CORNER_SOUTH_WEST = VoxelShapeUtils.rotate(CORNER_NORTH_WEST, Direction.WEST);
    private static final VoxelShape SIDE_WEST = Block.box((double)0.0, (double)13.0, (double)0.0, (double)6.0, (double)15.0, (double)16.0);
    private static final VoxelShape SIDE_NORTH = VoxelShapeUtils.rotate(SIDE_WEST, Direction.EAST);
    private static final VoxelShape SIDE_EAST = VoxelShapeUtils.rotate(SIDE_WEST, Direction.SOUTH);
    private static final VoxelShape SIDE_SOUTH = VoxelShapeUtils.rotate(SIDE_WEST, Direction.WEST);
    private static final Map<Combination, VoxelShape> SHAPES = new HashMap<Combination, VoxelShape>();
    private static final List<Vector2i> VALID_DIMENSIONS = List.of(new Vector2i(3, 3), new Vector2i(4, 3), new Vector2i(5, 3));
    private static final int MAX_SIZE;
    public static final BooleanProperty VALID;
    public static final BooleanProperty NORTH;
    public static final BooleanProperty EAST;
    public static final BooleanProperty SOUTH;
    public static final BooleanProperty WEST;
    public static final BooleanProperty CLOTH;
    public static final EnumProperty<DyeColor> COLOR;

    public CardTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)VALID, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)CLOTH, (Comparable)Boolean.valueOf(false))).setValue(COLOR, (Comparable)DyeColor.WHITE));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return !level.isClientSide ? CardTableBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.CARD_TABLE.get()), CardTableBlockEntity::serverTick) : null;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new CardTableBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{VALID, NORTH, EAST, SOUTH, WEST, CLOTH, COLOR});
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.isShiftKeyDown()) {
                if (((Boolean)state.getValue((Property)CLOTH)).booleanValue()) {
                    Pair<BlockPos, Vector2f> pair = this.getCenterAndOffset((LevelAccessor)level, pos);
                    BlockPos center = (BlockPos)pair.getFirst();
                    Vector2f offset = (Vector2f)pair.getSecond();
                    level.getBlockEntity(center, (BlockEntityType)ModBlockEntityTypes.CARD_TABLE.get()).ifPresent(cardTable -> {
                        Vec3 c = pos.getCenter();
                        if (!cardTable.centerOffset.equals((Object)offset)) {
                            cardTable.centerOffset = offset;
                            level.sendBlockUpdated(center, state, state, 3);
                        }
                        if (cardTable.getGame() != null && !cardTable.getGame().isGameOver()) {
                            player.displayClientMessage((Component)Component.translatable((String)"message.charta.cant_remove_while_table_occupied").withStyle(ChatFormatting.RED), true);
                        } else if (!cardTable.getDeckStack().isEmpty()) {
                            Containers.dropItemStack((Level)level, (double)c.x, (double)c.y, (double)c.z, (ItemStack)cardTable.getDeckStack());
                            cardTable.setDeckStack(ItemStack.EMPTY);
                            level.sendBlockUpdated(center, state, state, 3);
                        } else {
                            DyeColor color = (DyeColor)state.getValue(COLOR);
                            this.getMultiblock((LevelAccessor)level, pos).forEach(p -> {
                                BlockState s = level.getBlockState(p);
                                level.setBlockAndUpdate(p, (BlockState)s.setValue((Property)CLOTH, (Comparable)Boolean.valueOf(false)));
                            });
                            Containers.dropItemStack((Level)level, (double)c.x, (double)c.y, (double)c.z, (ItemStack)DyeColorHelper.getCarpet(color).asItem().getDefaultInstance());
                        }
                    });
                }
            } else {
                ItemStack stack = player.getMainHandItem();
                if (((Boolean)state.getValue((Property)VALID)).booleanValue()) {
                    if (!((Boolean)state.getValue((Property)CLOTH)).booleanValue()) {
                        BlockItem blockItem;
                        Item item = stack.getItem();
                        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof WoolCarpetBlock) {
                            WoolCarpetBlock carpetBlock = (WoolCarpetBlock)item;
                            if (!player.isCreative()) {
                                stack.shrink(1);
                            }
                            DyeColor color = carpetBlock.getColor();
                            this.getMultiblock((LevelAccessor)level, pos).forEach(p -> {
                                BlockState s = level.getBlockState(p);
                                level.setBlockAndUpdate(p, (BlockState)((BlockState)s.setValue((Property)CLOTH, (Comparable)Boolean.valueOf(true))).setValue(COLOR, (Comparable)color));
                            });
                        } else {
                            player.displayClientMessage((Component)Component.translatable((String)"message.charta.put_table_cloth").withStyle(ChatFormatting.RED), true);
                        }
                    } else if (player instanceof LivingEntityMixed) {
                        LivingEntityMixed mixed = (LivingEntityMixed)player;
                        Pair<BlockPos, Vector2f> pair = this.getCenterAndOffset((LevelAccessor)level, pos);
                        BlockPos center = (BlockPos)pair.getFirst();
                        Vector2f offset = (Vector2f)pair.getSecond();
                        level.getBlockEntity(center, (BlockEntityType)ModBlockEntityTypes.CARD_TABLE.get()).ifPresent(cardTable -> {
                            if (!cardTable.centerOffset.equals((Object)offset)) {
                                cardTable.centerOffset = offset;
                                level.sendBlockUpdated(center, state, state, 3);
                            }
                            if (stack.getItem() instanceof DeckItem && stack.has(ModDataComponentTypes.CARD_DECK)) {
                                if (!cardTable.getDeckStack().isEmpty()) {
                                    Vec3 c = center.getCenter();
                                    Containers.dropItemStack((Level)level, (double)c.x, (double)c.y, (double)c.z, (ItemStack)cardTable.getDeckStack());
                                }
                                cardTable.setDeckStack(stack.copy());
                                if (!serverPlayer.isCreative()) {
                                    stack.shrink(1);
                                }
                                level.sendBlockUpdated(center, state, state, 3);
                            } else {
                                Deck deck = cardTable.getDeck();
                                if (deck != null) {
                                    List<LivingEntity> satPlayers = cardTable.getPlayers();
                                    if (satPlayers.contains(player)) {
                                        CardGame<?> game = cardTable.getGame();
                                        if (game == null || game.isGameOver()) {
                                            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new TableScreenPayload(center, deck, satPlayers.stream().mapToInt(Entity::getId).toArray()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                                        } else if (game.getPlayers().contains(mixed.charta_getCardPlayer())) {
                                            game.openScreen(serverPlayer, serverPlayer.serverLevel(), center, cardTable.getDeck());
                                        } else {
                                            player.displayClientMessage((Component)Component.translatable((String)"message.charta.not_playing_current").withStyle(ChatFormatting.RED), true);
                                        }
                                    } else {
                                        player.displayClientMessage((Component)Component.translatable((String)"message.charta.need_to_be_sat").withStyle(ChatFormatting.RED), true);
                                    }
                                } else {
                                    player.displayClientMessage((Component)Component.translatable((String)"message.charta.table_no_deck").withStyle(ChatFormatting.RED), true);
                                }
                            }
                        });
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"message.charta.invalid_card_player").withStyle(ChatFormatting.RED), true);
                    }
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            if (((Boolean)state.getValue((Property)CLOTH)).booleanValue()) {
                Vec3 c = pos.getCenter();
                ItemStack carpetStack = DyeColorHelper.getCarpet((DyeColor)state.getValue(COLOR)).asItem().getDefaultInstance();
                Containers.dropItemStack((Level)level, (double)c.x, (double)c.y, (double)c.z, (ItemStack)carpetStack);
            }
            level.getBlockEntity(pos, (BlockEntityType)ModBlockEntityTypes.CARD_TABLE.get()).ifPresent(entity -> {
                Vec3 c = pos.getCenter();
                Containers.dropItemStack((Level)level, (double)c.x, (double)c.y, (double)c.z, (ItemStack)entity.getDeckStack());
                if (entity.getGame() != null && !entity.getGame().isGameOver()) {
                    entity.getGame().endGame();
                }
            });
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        boolean valid = this.isValidMultiblock(level, pos);
        switch (direction) {
            case NORTH: {
                BlockState blockState = (BlockState)((BlockState)state.setValue((Property)VALID, (Comparable)Boolean.valueOf(valid))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(neighborState.is((Block)this)));
                break;
            }
            case EAST: {
                BlockState blockState = (BlockState)((BlockState)state.setValue((Property)VALID, (Comparable)Boolean.valueOf(valid))).setValue((Property)EAST, (Comparable)Boolean.valueOf(neighborState.is((Block)this)));
                break;
            }
            case SOUTH: {
                BlockState blockState = (BlockState)((BlockState)state.setValue((Property)VALID, (Comparable)Boolean.valueOf(valid))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(neighborState.is((Block)this)));
                break;
            }
            case WEST: {
                BlockState blockState = (BlockState)((BlockState)state.setValue((Property)VALID, (Comparable)Boolean.valueOf(valid))).setValue((Property)WEST, (Comparable)Boolean.valueOf(neighborState.is((Block)this)));
                break;
            }
            default: {
                BlockState blockState = state = (BlockState)super.updateShape(state, direction, neighborState, level, pos, neighborPos).setValue((Property)VALID, (Comparable)Boolean.valueOf(valid));
            }
        }
        return neighborState.is((Block)this) ? (BlockState)state.setValue((Property)CLOTH, (Comparable)((Boolean)neighborState.getValue((Property)CLOTH))) : (valid ? state : (BlockState)state.setValue((Property)CLOTH, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected BlockState rotate(BlockState state, @NotNull Rotation rot) {
        boolean north = (Boolean)state.getValue((Property)NORTH);
        boolean east = (Boolean)state.getValue((Property)EAST);
        boolean south = (Boolean)state.getValue((Property)SOUTH);
        boolean west = (Boolean)state.getValue((Property)WEST);
        state = (BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(false));
        state = (BlockState)state.setValue((Property)EAST, (Comparable)Boolean.valueOf(false));
        state = (BlockState)state.setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false));
        state = (BlockState)state.setValue((Property)WEST, (Comparable)Boolean.valueOf(false));
        if (north) {
            switch (rot.rotate(Direction.NORTH)) {
                case NORTH: {
                    state = (BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case EAST: {
                    state = (BlockState)state.setValue((Property)EAST, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case SOUTH: {
                    state = (BlockState)state.setValue((Property)SOUTH, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case WEST: {
                    state = (BlockState)state.setValue((Property)WEST, (Comparable)Boolean.valueOf(true));
                }
            }
        }
        if (east) {
            switch (rot.rotate(Direction.EAST)) {
                case NORTH: {
                    state = (BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case EAST: {
                    state = (BlockState)state.setValue((Property)EAST, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case SOUTH: {
                    state = (BlockState)state.setValue((Property)SOUTH, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case WEST: {
                    state = (BlockState)state.setValue((Property)WEST, (Comparable)Boolean.valueOf(true));
                }
            }
        }
        if (south) {
            switch (rot.rotate(Direction.SOUTH)) {
                case NORTH: {
                    state = (BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case EAST: {
                    state = (BlockState)state.setValue((Property)EAST, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case SOUTH: {
                    state = (BlockState)state.setValue((Property)SOUTH, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case WEST: {
                    state = (BlockState)state.setValue((Property)WEST, (Comparable)Boolean.valueOf(true));
                }
            }
        }
        if (west) {
            switch (rot.rotate(Direction.WEST)) {
                case NORTH: {
                    state = (BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case EAST: {
                    state = (BlockState)state.setValue((Property)EAST, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case SOUTH: {
                    state = (BlockState)state.setValue((Property)SOUTH, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case WEST: {
                    state = (BlockState)state.setValue((Property)WEST, (Comparable)Boolean.valueOf(true));
                }
            }
        }
        return state;
    }

    @NotNull
    protected BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        if (mirror == Mirror.FRONT_BACK) {
            boolean east = (Boolean)state.getValue((Property)EAST);
            boolean west = (Boolean)state.getValue((Property)WEST);
            state = (BlockState)((BlockState)state.setValue((Property)EAST, (Comparable)Boolean.valueOf(west))).setValue((Property)WEST, (Comparable)Boolean.valueOf(east));
        } else if (mirror == Mirror.LEFT_RIGHT) {
            boolean north = (Boolean)state.getValue((Property)NORTH);
            boolean south = (Boolean)state.getValue((Property)SOUTH);
            state = (BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(south))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(north));
        }
        return state;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean valid = this.isValidMultiblock((LevelAccessor)context.getLevel(), context.getClickedPos());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)VALID, (Comparable)Boolean.valueOf(valid))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(context.getLevel().getBlockState(context.getClickedPos().north()).is((Block)this)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(context.getLevel().getBlockState(context.getClickedPos().east()).is((Block)this)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(context.getLevel().getBlockState(context.getClickedPos().south()).is((Block)this)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(context.getLevel().getBlockState(context.getClickedPos().west()).is((Block)this)));
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Combination combination = new Combination((Boolean)state.getValue((Property)VALID), (Boolean)state.getValue((Property)NORTH), (Boolean)state.getValue((Property)EAST), (Boolean)state.getValue((Property)SOUTH), (Boolean)state.getValue((Property)WEST));
        return SHAPES.getOrDefault(combination, Shapes.empty());
    }

    @NotNull
    protected MapCodec<CardTableBlock> codec() {
        return CODEC;
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public Set<BlockPos> getMultiblock(LevelAccessor level, BlockPos pos) {
        HashSet<BlockPos> multiblock = new HashSet<BlockPos>();
        this.floodFill(level, pos, new HashSet<BlockPos>(), multiblock);
        return multiblock;
    }

    public Pair<BlockPos, Vector2f> getCenterAndOffset(LevelAccessor level, BlockPos pos) {
        int height;
        Set<BlockPos> multiblock = this.getMultiblock(level, pos);
        Vector2f offset = new Vector2f();
        int width = this.getWidth(multiblock);
        if (width % 2 == 0) {
            offset.x = 0.5f;
        }
        if ((height = this.getHeight(multiblock)) % 2 == 0) {
            offset.y = -0.5f;
        }
        BlockBox box = this.getBoundingBox(multiblock);
        BlockPos min = box.min();
        BlockPos max = box.max();
        BlockPos center = new BlockPos(min.getX() + Mth.floor((double)((double)(max.getX() - min.getX()) / 2.0)), min.getY() + Mth.floor((double)((double)(max.getY() - min.getY()) / 2.0)), min.getZ() + Mth.floor((double)((double)(max.getZ() - min.getZ()) / 2.0)));
        return Pair.of((Object)center, (Object)offset);
    }

    public boolean isValidMultiblock(LevelAccessor level, BlockPos pos) {
        int height;
        Set<BlockPos> multiblock = this.getMultiblock(level, pos);
        int width = this.getWidth(multiblock);
        return this.isValidDimensions(width, height = this.getHeight(multiblock)) && this.isBoundingBoxFilled(level, this.getBoundingBox(multiblock));
    }

    private void floodFill(LevelAccessor level, BlockPos pos, Set<BlockPos> visited, Set<BlockPos> multiblock) {
        if (multiblock.size() > MAX_SIZE) {
            return;
        }
        if (!visited.add(pos)) {
            return;
        }
        if (level.getBlockState(pos).getBlock() != this) {
            return;
        }
        multiblock.add(pos);
        this.floodFill(level, pos.north(), visited, multiblock);
        this.floodFill(level, pos.south(), visited, multiblock);
        this.floodFill(level, pos.east(), visited, multiblock);
        this.floodFill(level, pos.west(), visited, multiblock);
    }

    private BlockBox getBoundingBox(Set<BlockPos> multiblock) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int y = 0;
        for (BlockPos pos : multiblock) {
            minX = Math.min(minX, pos.getX());
            maxX = Math.max(maxX, pos.getX());
            minZ = Math.min(minZ, pos.getZ());
            maxZ = Math.max(maxZ, pos.getZ());
            y = pos.getY();
        }
        return BlockBox.of((BlockPos)new BlockPos(minX, y, minZ), (BlockPos)new BlockPos(maxX, y, maxZ));
    }

    private boolean isBoundingBoxFilled(LevelAccessor level, BlockBox boundingBox) {
        for (BlockPos pos : boundingBox) {
            if (level.getBlockState(pos).getBlock() == this) continue;
            return false;
        }
        return true;
    }

    private boolean isValidDimensions(int width, int height) {
        return VALID_DIMENSIONS.contains(new Vector2i(width, height)) || VALID_DIMENSIONS.contains(new Vector2i(height, width));
    }

    private int getWidth(Set<BlockPos> multiblock) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        for (BlockPos pos : multiblock) {
            minX = Math.min(minX, pos.getX());
            maxX = Math.max(maxX, pos.getX());
        }
        return maxX - minX + 1;
    }

    private int getHeight(Set<BlockPos> multiblock) {
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos : multiblock) {
            minZ = Math.min(minZ, pos.getZ());
            maxZ = Math.max(maxZ, pos.getZ());
        }
        return maxZ - minZ + 1;
    }

    static {
        VALID = BooleanProperty.create((String)"valid");
        NORTH = BooleanProperty.create((String)"north");
        EAST = BooleanProperty.create((String)"east");
        SOUTH = BooleanProperty.create((String)"south");
        WEST = BooleanProperty.create((String)"west");
        CLOTH = BooleanProperty.create((String)"cloth");
        COLOR = EnumProperty.create((String)"color", DyeColor.class);
        Vector2i last = VALID_DIMENSIONS.getLast();
        MAX_SIZE = last.x * last.y;
        for (int i = 0; i < 32; ++i) {
            boolean[] combination = new boolean[5];
            for (int j = 0; j < 5; ++j) {
                combination[j] = (i & 1 << j) != 0;
            }
            boolean valid = combination[0];
            boolean north = combination[1];
            boolean east = combination[2];
            boolean south = combination[3];
            boolean west = combination[4];
            VoxelShape combinedShape = CENTER;
            if (!north && !east) {
                combinedShape = Shapes.join((VoxelShape)combinedShape, (VoxelShape)FEET_NORTH_EAST, (BooleanOp)BooleanOp.OR);
            }
            if (!south && !east) {
                combinedShape = Shapes.join((VoxelShape)combinedShape, (VoxelShape)FEET_SOUTH_EAST, (BooleanOp)BooleanOp.OR);
            }
            if (!south && !west) {
                combinedShape = Shapes.join((VoxelShape)combinedShape, (VoxelShape)FEET_SOUTH_WEST, (BooleanOp)BooleanOp.OR);
            }
            if (!north && !west) {
                combinedShape = Shapes.join((VoxelShape)combinedShape, (VoxelShape)FEET_NORTH_WEST, (BooleanOp)BooleanOp.OR);
            }
            if (valid) {
                if (!north && east && south && !west) {
                    combinedShape = Shapes.join((VoxelShape)combinedShape, (VoxelShape)CORNER_NORTH_WEST, (BooleanOp)BooleanOp.OR);
                }
                if (!north && !east && south && west) {
                    combinedShape = Shapes.join((VoxelShape)combinedShape, (VoxelShape)CORNER_NORTH_EAST, (BooleanOp)BooleanOp.OR);
                }
                if (north && !east && !south && west) {
                    combinedShape = Shapes.join((VoxelShape)combinedShape, (VoxelShape)CORNER_SOUTH_EAST, (BooleanOp)BooleanOp.OR);
                }
                if (north && east && !south && !west) {
                    combinedShape = Shapes.join((VoxelShape)combinedShape, (VoxelShape)CORNER_SOUTH_WEST, (BooleanOp)BooleanOp.OR);
                }
                if (north && east && south && !west) {
                    combinedShape = Shapes.join((VoxelShape)combinedShape, (VoxelShape)SIDE_WEST, (BooleanOp)BooleanOp.OR);
                }
                if (!north && east && south && west) {
                    combinedShape = Shapes.join((VoxelShape)combinedShape, (VoxelShape)SIDE_NORTH, (BooleanOp)BooleanOp.OR);
                }
                if (north && !east && south && west) {
                    combinedShape = Shapes.join((VoxelShape)combinedShape, (VoxelShape)SIDE_EAST, (BooleanOp)BooleanOp.OR);
                }
                if (north && east && !south && west) {
                    combinedShape = Shapes.join((VoxelShape)combinedShape, (VoxelShape)SIDE_SOUTH, (BooleanOp)BooleanOp.OR);
                }
            }
            SHAPES.put(new Combination(valid, north, east, south, west), combinedShape);
        }
    }

    private record Combination(boolean valid, boolean north, boolean east, boolean south, boolean west) {
    }
}

