/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.block;

import dev.lucaargolo.charta.block.ModBlocks;
import dev.lucaargolo.charta.utils.VoxelShapeUtils;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeerGlassBlock
extends TransparentBlock {
    private static final VoxelShape EAST_SHAPE = Stream.of(Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0), Block.box((double)7.5, (double)2.0, (double)2.5, (double)8.5, (double)3.0, (double)5.0), Block.box((double)7.5, (double)6.0, (double)2.5, (double)8.5, (double)7.0, (double)5.0), Block.box((double)7.5, (double)3.0, (double)2.5, (double)8.5, (double)6.0, (double)3.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape NORTH_SHAPE = VoxelShapeUtils.rotate(EAST_SHAPE, Direction.EAST, Direction.NORTH);
    private static final VoxelShape WEST_SHAPE = VoxelShapeUtils.rotate(EAST_SHAPE, Direction.EAST, Direction.WEST);
    private static final VoxelShape SOUTH_SHAPE = VoxelShapeUtils.rotate(EAST_SHAPE, Direction.EAST, Direction.SOUTH);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final FoodProperties FOOD = new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1200, 1), 1.0f).effect(() -> new MobEffectInstance(MobEffects.HUNGER, 300, 2), 1.0f).effect(() -> new MobEffectInstance(MobEffects.CONFUSION, 300, 0), 1.0f).build();

    public BeerGlassBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (!state.is(ModBlocks.EMPTY_BEER_GLASS)) {
            if (!level.isClientSide()) {
                player.eat(level, this.asItem().getDefaultInstance(), FOOD);
                level.setBlockAndUpdate(pos, (BlockState)((BeerGlassBlock)((Object)ModBlocks.EMPTY_BEER_GLASS.get())).defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }
}

