/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.block;

import dev.lucaargolo.charta.block.SeatBlock;
import dev.lucaargolo.charta.utils.DyeColorHelper;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BarStoolBlock
extends SeatBlock {
    private static final VoxelShape SHAPE = Stream.of(Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0), Block.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.box((double)4.0, (double)6.0, (double)2.0, (double)12.0, (double)8.0, (double)4.0), Block.box((double)4.0, (double)6.0, (double)12.0, (double)12.0, (double)8.0, (double)14.0), Block.box((double)12.0, (double)6.0, (double)4.0, (double)14.0, (double)8.0, (double)12.0), Block.box((double)2.0, (double)6.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final BooleanProperty CLOTH = BooleanProperty.create((String)"cloth");
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.create((String)"color", DyeColor.class);

    public BarStoolBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CLOTH, (Comparable)Boolean.valueOf(false))).setValue(COLOR, (Comparable)DyeColor.WHITE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CLOTH, COLOR});
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock()) && ((Boolean)state.getValue((Property)CLOTH)).booleanValue()) {
            Vec3 center = pos.getCenter();
            ItemStack carpetStack = DyeColorHelper.getCarpet((DyeColor)state.getValue(COLOR)).asItem().getDefaultInstance();
            Containers.dropItemStack((Level)level, (double)center.x, (double)center.y, (double)center.z, (ItemStack)carpetStack);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Override
    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (this.tryAndSetCloth(state, level, pos, player)) {
            return InteractionResult.SUCCESS;
        }
        if (this.tryAndSit(state, level, pos, player)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean tryAndSetCloth(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player) {
        DyeColor color;
        BlockItem blockItem;
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof WoolCarpetBlock) {
            WoolCarpetBlock carpetBlock = (WoolCarpetBlock)item;
            if (!level.isClientSide()) {
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                if (!((Boolean)state.getValue((Property)CLOTH)).booleanValue()) {
                    color = carpetBlock.getColor();
                    level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)CLOTH, (Comparable)Boolean.valueOf(true))).setValue(COLOR, (Comparable)color));
                }
            }
            return true;
        }
        if (player.isShiftKeyDown()) {
            if (!level.isClientSide() && ((Boolean)state.getValue((Property)CLOTH)).booleanValue()) {
                if (!BarStoolBlock.isSeatOccupied(level, pos)) {
                    color = (DyeColor)state.getValue(COLOR);
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CLOTH, (Comparable)Boolean.valueOf(false)));
                    Vec3 c = pos.getCenter();
                    Containers.dropItemStack((Level)level, (double)c.x, (double)c.y, (double)c.z, (ItemStack)DyeColorHelper.getCarpet(color).asItem().getDefaultInstance());
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"message.charta.cant_remove_while_seat_occupied").withStyle(ChatFormatting.RED), true);
                }
            }
            return true;
        }
        return false;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }
}

