/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.block;

import com.mojang.serialization.MapCodec;
import dev.lucaargolo.charta.blockentity.BarShelfBlockEntity;
import dev.lucaargolo.charta.blockentity.ModBlockEntityTypes;
import dev.lucaargolo.charta.utils.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;

public class BarShelfBlock
extends BaseEntityBlock {
    public static final MapCodec<BarShelfBlock> CODEC = BarShelfBlock.simpleCodec(BarShelfBlock::new);
    private static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = VoxelShapeUtils.rotate(NORTH_SHAPE, Direction.SOUTH);
    private static final VoxelShape EAST_SHAPE = VoxelShapeUtils.rotate(NORTH_SHAPE, Direction.EAST);
    private static final VoxelShape WEST_SHAPE = VoxelShapeUtils.rotate(NORTH_SHAPE, Direction.WEST);
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public BarShelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)UP, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, UP});
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new BarShelfBlockEntity(pos, state);
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            level.getBlockEntity(pos, (BlockEntityType)ModBlockEntityTypes.BAR_SHELF.get()).ifPresent(entity -> Containers.dropContents((Level)level, (BlockPos)pos, (Container)entity));
        }
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Direction direction = hitResult.getDirection();
        if (direction == state.getValue((Property)FACING)) {
            if (!level.isClientSide()) {
                boolean plus;
                Vec3 hit = hitResult.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                boolean axis = direction.getAxis() == Direction.Axis.X;
                boolean bl = plus = direction.getAxisDirection() == Direction.AxisDirection.POSITIVE;
                Vector2d coords = new Vector2d(axis ? (plus ? 1.0 - hit.z : hit.z) : (plus ? hit.x : 1.0 - hit.x), hit.y);
                int slot = coords.x < 0.5 ? (coords.y > 0.5 ? 0 : 2) : (coords.y > 0.5 ? 1 : 3);
                level.getBlockEntity(pos, (BlockEntityType)ModBlockEntityTypes.BAR_SHELF.get()).ifPresent(entity -> {
                    ItemStack stored = entity.getItem(slot);
                    if (!stored.isEmpty()) {
                        player.getInventory().placeItemBackInInventory(entity.removeItem(slot, 1));
                    } else if (!stack.isEmpty()) {
                        entity.setItem(slot, stack.copyWithCount(1));
                        stack.shrink(1);
                    }
                });
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection().getOpposite();
        Level level = context.getLevel();
        BlockPos neighborPos = context.getClickedPos().above();
        BlockState neighborState = level.getBlockState(neighborPos);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)UP, (Comparable)Boolean.valueOf(neighborState.getBlock() instanceof BarShelfBlock || neighborState.isCollisionShapeFullBlock((BlockGetter)level, neighborPos)));
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (direction == Direction.UP) {
            return (BlockState)state.setValue((Property)UP, (Comparable)Boolean.valueOf(neighborState.getBlock() instanceof BarShelfBlock || neighborState.isCollisionShapeFullBlock((BlockGetter)level, neighborPos)));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }
}

