/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigData;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.mixin.access.SingleQuadParticleAccessor;
import pigcart.particlerain.particle.WeatherParticle;

public class CustomParticle
extends WeatherParticle {
    private static final Set<String> usuallyUntintableSprites = Set.of("particlerain:rain_0", "particlerain:rain_1", "particlerain:rain_2", "particlerain:rain_3");
    public ConfigData.ParticleData opts;
    private float oCollisionAnimProgress = 1.0f;
    private float collisionAnimProgress = 1.0f;
    private float speed = 0.0f;
    private final float rotationVariation;
    boolean doCollisionAnim = false;
    public BlockPos.MutableBlockPos pos;
    protected BlockPos.MutableBlockPos oPos;
    BlockHitResult collision = null;
    float baseTemp;
    float oQuadSize;
    float distance;

    public CustomParticle(ClientLevel level, double x, double y, double z, ConfigData.ParticleData opts) {
        super(level, x, y, z, VersionUtil.getSprite(VersionUtil.parseId(opts.spriteLocations.get(level.random.nextInt(opts.spriteLocations.size())))));
        this.gravity = opts.gravity;
        this.yd = -this.gravity;
        this.quadSize = opts.size;
        this.alpha = 0.0f;
        this.hasPhysics = false;
        this.setSize(this.quadSize, this.quadSize);
        this.lifetime = ConfigManager.config.perf.particleDistance * 100;
        this.pos = new BlockPos.MutableBlockPos(x, y, z);
        this.oPos = new BlockPos.MutableBlockPos(x, y, z);
        this.baseTemp = ((Biome)level.getBiome((BlockPos)this.pos).value()).getBaseTemperature();
        this.opts = opts;
        this.lifetime = opts.lifetime;
        this.rotationVariation = opts.rotationAmount * ((this.random.nextFloat() - 0.5f) * 2.0f);
        this.quadSize = opts.constantScreenSize ? this.getDistanceSize() : opts.size;
        if (!usuallyUntintableSprites.contains(this.sprite.contents().name().toString()) || ConfigManager.config.compat.waterTint) {
            opts.tintType.applyTint((SingleQuadParticle)this, level, (BlockPos)this.pos, opts);
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.oQuadSize = this.quadSize;
        this.distance = (float)VersionUtil.camPos(Minecraft.getInstance().gameRenderer.getMainCamera()).distanceTo(new Vec3(this.x, this.y, this.z));
        this.pos.set(this.x, this.y, this.z);
        if (!this.pos.equals((Object)this.oPos)) {
            this.onPositionUpdate();
            this.oPos.set((Vec3i)this.pos);
        }
        if (this.doCollisionAnim) {
            this.tickCollisionAnim();
        }
        this.tickDistanceFade();
        this.speed = (float)new Vec3(this.xd, this.yd, this.zd).length();
        if (this.opts.constantScreenSize && !this.doCollisionAnim) {
            this.quadSize = this.getDistanceSize();
        }
        if (this.opts.rotationAmount != 0.0f) {
            this.oRoll = this.roll;
            this.roll += this.rotationVariation * this.speed;
        }
        this.tickWind();
    }

    @Override
    public void tickDistanceFade() {
        float renderDistance = ConfigManager.config.perf.particleDistance;
        if (this.distance > renderDistance + 1.0f) {
            this.remove();
        } else {
            this.alpha = Mth.lerp((float)Mth.clamp((float)(this.distance / renderDistance), (float)0.0f, (float)1.0f), (float)this.opts.opacity, (float)0.0f);
        }
    }

    public void tickWind() {
        float multiplier;
        float frequency = ConfigManager.config.wind.gustFrequency;
        float shift = (float)ParticleRain.clientTicks * ConfigManager.config.wind.modulationSpeed;
        float variance = ConfigManager.config.wind.strengthVariance;
        float strength = ConfigManager.config.wind.strength;
        float f = multiplier = this.level.isThundering() ? this.opts.stormWindStrength : this.opts.windStrength;
        if (ConfigManager.config.wind.yLevelAdjustment) {
            multiplier *= CustomParticle.yLevelWindMultiplier(this.y);
        }
        this.xd = (Mth.sin((float)((float)this.x * frequency + shift)) * variance + variance + strength) * multiplier + 0.001f;
        this.zd = (Mth.sin((float)((float)this.z * frequency + shift)) * variance + variance + strength) * multiplier + 0.001f;
    }

    public static float yLevelWindMultiplier(double y) {
        int transitionStart = 50;
        int transitionDistance = 40;
        return (float)Mth.clamp((double)((y - (double)transitionStart) / (double)transitionDistance), (double)0.0, (double)1.0);
    }

    @Override
    public void onPositionUpdate() {
        if (!ConfigManager.config.compat.crossBiomeBorder && (double)Mth.abs((float)(((Biome)this.level.getBiome((BlockPos)this.pos).value()).getBaseTemperature() - this.baseTemp)) > 0.4) {
            this.doCollisionAnim = true;
        }
        if (this.level.getBlockState((BlockPos)this.pos).isCollisionShapeFullBlock((BlockGetter)this.level, (BlockPos)this.pos) || !this.level.getFluidState((BlockPos)this.pos).isEmpty()) {
            this.remove();
        }
        this.testForCollisions();
    }

    public void testForCollisions() {
        Vec3 quadEdgePos;
        Vec3 quadCenterPos;
        BlockHitResult hitResult;
        float length = this.quadSize;
        if (this.opts.rotationType.equals((Object)ConfigData.RotationType.RELATIVE_VELOCITY)) {
            Vec3 camD = Minecraft.getInstance().getCameraEntity().getDeltaMovement();
            Vector3f deltaMotion = new Vector3f((float)(this.xd - camD.x), (float)(this.yd - camD.y), (float)(this.zd - camD.z));
            length *= Mth.clamp((float)deltaMotion.lengthSquared(), (float)0.2f, (float)1.0f);
        }
        if (!(hitResult = this.level.clip(VersionUtil.getClipContext(quadCenterPos = new Vec3(this.x, this.y, this.z), quadEdgePos = new Vec3(this.xd, this.yd, this.zd).normalize().multiply((double)length, (double)length, (double)length).add(this.x, this.y, this.z)))).getType().equals((Object)HitResult.Type.MISS) && !this.doCollisionAnim) {
            this.collision = hitResult;
            this.doCollisionAnim = true;
        }
    }

    @Override
    public void tickCollisionAnim() {
        this.oCollisionAnimProgress = this.collisionAnimProgress;
        this.collisionAnimProgress -= this.speed;
        if (!this.opts.rotationType.equals((Object)ConfigData.RotationType.RELATIVE_VELOCITY)) {
            this.quadSize -= this.speed;
        }
        if (this.oCollisionAnimProgress <= 0.0f) {
            this.remove();
        }
    }

    public float getDistanceSize() {
        if (Minecraft.getInstance().options.getCameraType().isFirstPerson() && Minecraft.getInstance().player.isScoping()) {
            return this.distance * this.opts.size * 0.25f;
        }
        return this.distance * this.opts.size;
    }

    @Override
    public ParticleRenderType getRenderType() {
        return this.opts.renderType.get();
    }

    public void render(VertexConsumer h, Camera camera, float tickPercent) {
        this.opts.rotationType.render(h, camera, tickPercent, this);
    }

    public void renderLookingQuad(VertexConsumer h, Camera camera, float tickPercent) {
        Vec3 camPos = VersionUtil.camPos(camera);
        float offsetX = (float)(Mth.lerp((double)tickPercent, (double)this.xo, (double)this.x) - camPos.x());
        float offsetY = (float)(Mth.lerp((double)tickPercent, (double)this.yo, (double)this.y) - camPos.y());
        float offsetZ = (float)(Mth.lerp((double)tickPercent, (double)this.zo, (double)this.z) - camPos.z());
        Vector3f localPos = new Vector3f(offsetX, offsetY, offsetZ);
        Quaternionf quaternion = Axis.YP.rotation(Math.atan2((float)offsetX, (float)offsetZ) + (float)java.lang.Math.PI);
        float yAngle = Math.asin((float)(offsetY / localPos.length()));
        quaternion.rotateX(yAngle);
        quaternion.rotateZ(Math.atan2((float)offsetX, (float)offsetZ));
        if (yAngle < -1.0f) {
            this.doCollisionAnim = true;
        }
        quaternion.rotateZ(Mth.lerp((float)tickPercent, (float)this.oRoll, (float)this.roll));
        this.renderRotatedQuad(h, quaternion, offsetX, offsetY, offsetZ, tickPercent);
    }

    public void renderRelativeVelocityQuad(VertexConsumer h, Camera camera, float tickPercent) {
        float collisionProg;
        Vec3 camPos = VersionUtil.camPos(camera);
        float offsetX = (float)(Mth.lerp((double)tickPercent, (double)this.xo, (double)this.x) - camPos.x());
        float offsetY = (float)(Mth.lerp((double)tickPercent, (double)this.yo, (double)this.y) - camPos.y());
        float offsetZ = (float)(Mth.lerp((double)tickPercent, (double)this.zo, (double)this.z) - camPos.z());
        Vec3 camD = Minecraft.getInstance().getCameraEntity().getDeltaMovement();
        Vector3f deltaMotion = new Vector3f((float)(this.xd - camD.x), (float)(this.yd - camD.y), (float)(this.zd - camD.z));
        float angle = Math.acos((float)new Vector3f((Vector3fc)deltaMotion).normalize().y);
        Vector3f axis = new Vector3f(-deltaMotion.z(), 0.0f, deltaMotion.x()).normalize();
        Quaternionf quaternion = new Quaternionf(new AxisAngle4f(-angle, (Vector3fc)axis));
        Vector3f transformedOffset = new Vector3f(offsetX, offsetY, offsetZ);
        transformedOffset.rotateAxis(angle, axis.x, axis.y, axis.z);
        quaternion.mul((Quaternionfc)Axis.YP.rotation(Math.atan2((float)transformedOffset.x, (float)transformedOffset.z) + (float)java.lang.Math.PI));
        float stretchFactor = Mth.clamp((float)deltaMotion.lengthSquared(), (float)0.25f, (float)1.0f);
        if (this.doCollisionAnim && (collisionProg = Mth.lerp((float)tickPercent, (float)this.oCollisionAnimProgress, (float)this.collisionAnimProgress)) < stretchFactor) {
            stretchFactor = collisionProg;
        }
        this.renderSquishyRotatedQuad(h, quaternion, offsetX, offsetY, offsetZ, tickPercent, stretchFactor);
    }

    public void renderWorldVelocityQuad(VertexConsumer h, Camera camera, float tickPercent) {
        float collisionProg;
        Vec3 camPos = VersionUtil.camPos(camera);
        float offsetX = (float)(Mth.lerp((double)tickPercent, (double)this.xo, (double)this.x) - camPos.x());
        float offsetY = (float)(Mth.lerp((double)tickPercent, (double)this.yo, (double)this.y) - camPos.y());
        float offsetZ = (float)(Mth.lerp((double)tickPercent, (double)this.zo, (double)this.z) - camPos.z());
        Vector3f deltaMotion = new Vector3f((float)this.xd, (float)this.yd, (float)this.zd);
        float angle = Math.acos((float)new Vector3f((Vector3fc)deltaMotion).normalize().y);
        Vector3f axis = new Vector3f(-deltaMotion.z(), 0.0f, deltaMotion.x()).normalize();
        Quaternionf quaternion = new Quaternionf(new AxisAngle4f(-angle, (Vector3fc)axis));
        Vector3f transformedOffset = new Vector3f(offsetX, offsetY, offsetZ);
        transformedOffset.rotateAxis(angle, axis.x, axis.y, axis.z);
        quaternion.mul((Quaternionfc)Axis.YP.rotation(Math.atan2((float)transformedOffset.x, (float)transformedOffset.z) + (float)java.lang.Math.PI));
        float stretchFactor = Mth.clamp((float)deltaMotion.lengthSquared(), (float)0.25f, (float)1.0f);
        if (this.doCollisionAnim && (collisionProg = Mth.lerp((float)tickPercent, (float)this.oCollisionAnimProgress, (float)this.collisionAnimProgress)) < stretchFactor) {
            stretchFactor = collisionProg;
        }
        this.renderSquishyRotatedQuad(h, quaternion, offsetX, offsetY, offsetZ, tickPercent, stretchFactor);
    }

    public void renderCameraCopyQuad(VertexConsumer h, Camera camera, float tickPercent) {
        Vec3 camPos = VersionUtil.camPos(camera);
        float offsetX = (float)(Mth.lerp((double)tickPercent, (double)this.xo, (double)this.x) - camPos.x());
        float offsetY = (float)(Mth.lerp((double)tickPercent, (double)this.yo, (double)this.y) - camPos.y());
        float offsetZ = (float)(Mth.lerp((double)tickPercent, (double)this.zo, (double)this.z) - camPos.z());
        Quaternionf quaternion = new Quaternionf((Quaternionfc)camera.rotation());
        if (this.roll != 0.0f) {
            quaternion.rotateZ(Mth.lerp((float)tickPercent, (float)this.oRoll, (float)this.roll));
        }
        this.renderRotatedQuad(h, quaternion, offsetX, offsetY, offsetZ, tickPercent);
    }

    private void renderSquishyRotatedQuad(VertexConsumer h, Quaternionf quaternion, float x, float y, float z, float tickPercent, float squish) {
        float size = this.getQuadSize(tickPercent);
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        int color = this.getLightColor(tickPercent);
        this.renderVertex(h, quaternion, x, y, z, 1.0f, -squish, size, u1, v1, color);
        this.renderVertex(h, quaternion, x, y, z, 1.0f, squish, size, u1, v0, color);
        this.renderVertex(h, quaternion, x, y, z, -1.0f, squish, size, u0, v0, color);
        this.renderVertex(h, quaternion, x, y, z, -1.0f, -squish, size, u0, v1, color);
    }

    private void renderVertex(VertexConsumer buffer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float quadSize, float u, float v, int packedLight) {
        SingleQuadParticleAccessor p = (SingleQuadParticleAccessor)((Object)this);
        p.callRenderVertex(buffer, quaternion, x, y, z, xOffset, yOffset, quadSize, u, v, packedLight);
    }

    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        ConfigData.ParticleData opts;

        public DefaultFactory(ConfigData.ParticleData opts) {
            this.opts = opts;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            for (ConfigData.ParticleData options : ConfigManager.config.particles) {
                if (!this.opts.id.equals(options.id)) continue;
                this.opts = options;
            }
            return new CustomParticle(level, x, y, z, this.opts);
        }
    }
}

