/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.config.gui;

import java.lang.reflect.Field;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.config.gui.AbstractWidgetAccess;
import pigcart.particlerain.config.gui.WidgetList;
import pigcart.particlerain.config.gui.Widgets;

public class ConfigScreen
extends Screen {
    final Object config;
    final Object configDefault;
    final Class<?> configGenericType;
    WidgetList list;
    protected final Screen lastScreen;
    public final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);

    public ConfigScreen(Screen lastScreen, Object config, Object configDefault, Class<?> configGenericType, Component title) {
        super(title);
        this.lastScreen = lastScreen;
        this.config = config;
        this.configDefault = configDefault;
        this.configGenericType = configGenericType;
    }

    public ConfigScreen(Screen lastScreen, Object config, Object configDefault, Component title) {
        super(title);
        this.lastScreen = lastScreen;
        this.config = config;
        this.configDefault = configDefault;
        this.configGenericType = null;
    }

    protected void init() {
        this.addTitle();
        this.addContents();
        this.addFooter();
        this.repositionElements();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    protected void addTitle() {
        this.layout.addToHeader((LayoutElement)new StringWidget(this.title, this.font));
    }

    protected void addContents() {
        this.list = new WidgetList(this.minecraft, this.width, this.layout.getContentHeight(), 32, this.height - 32, 25);
        Widgets.addOptionWidgets(this);
        this.layout.addToContents((LayoutElement)this.list);
    }

    protected void addFooter() {
        GridLayout.RowHelper row = ((GridLayout)this.layout.addToFooter((LayoutElement)new GridLayout().columnSpacing(8))).createRowHelper(2);
        Button resetButton = Button.builder((Component)Component.translatable((String)"controls.reset").append(" ").append(this.title), button -> {
            ParticleRain.LOGGER.info("Reset config");
            for (Field field : this.config.getClass().getFields()) {
                try {
                    field.setAccessible(true);
                    field.set(this.config, field.get(this.configDefault));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            this.refresh();
        }).build();
        Button doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).build();
        row.addChild((LayoutElement)resetButton);
        row.addChild((LayoutElement)doneButton);
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.list != null) {
            this.list.updateSize(this.width, this.layout);
        }
    }

    public void removed() {
        ConfigManager.save();
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    public Screen getFreshScreen() {
        return new ConfigScreen(this.lastScreen, this.config, this.configDefault, this.configGenericType, this.title);
    }

    public void refresh() {
        ConfigScreen freshScreen = new ConfigScreen(this.lastScreen, this.config, this.configDefault, this.configGenericType, this.title);
        this.minecraft.setScreen((Screen)freshScreen);
        freshScreen.list.setScrollAmount(this.list.getScrollAmount());
    }

    public void add(AbstractWidget ... widgets) {
        for (AbstractWidget widget : widgets) {
            widget.setX(this.width / 2 - 155 + ((AbstractWidgetAccess)widget).particle_rain$getOffset());
        }
        this.list.add(widgets);
    }
}

