/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.util;

import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class Truffling {
    private static final String TRUFFLED_KEY = "Truffled";

    public static boolean isTruffled(ItemStack itemStack) {
        return itemStack.has(DataComponents.CUSTOM_DATA) && Objects.requireNonNull((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).contains(TRUFFLED_KEY);
    }

    public static ItemStack setTruffled(ItemStack itemStack) {
        CompoundTag tag = ((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        tag.putBoolean(TRUFFLED_KEY, true);
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        return itemStack;
    }

    public static FoodValue getAdditionalFoodValue() {
        return new FoodValue(0, 0.0f);
    }

    public static void addTruffledTooltip(ItemStack itemStack, List<Component> tooltip) {
        if (Truffling.isTruffled(itemStack)) {
            tooltip.add((Component)Component.translatable((String)"tooltip.wildernature.truffled").withStyle(ChatFormatting.GOLD));
            tooltip.add((Component)Component.translatable((String)"tooltip.wildernature.truffled.nutrition").withStyle(ChatFormatting.GREEN));
            tooltip.add((Component)Component.translatable((String)"tooltip.wildernature.truffled.saturationModifier").withStyle(ChatFormatting.GREEN));
        }
    }

    public record FoodValue(int nutrition, float saturationModifier) {
        @Override
        public String toString() {
            return "{Nutrition:" + this.nutrition + ",Saturation:" + this.saturationModifier + "}";
        }
    }
}

