/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.block.entity.BountyBoardBlockEntity;
import net.satisfy.wildernature.core.block.entity.CompletionistBannerEntity;
import net.satisfy.wildernature.core.entity.BisonEntity;
import net.satisfy.wildernature.core.entity.BoarEntity;
import net.satisfy.wildernature.core.entity.BulletEntity;
import net.satisfy.wildernature.core.entity.CassowaryEntity;
import net.satisfy.wildernature.core.entity.DeerEntity;
import net.satisfy.wildernature.core.entity.DogEntity;
import net.satisfy.wildernature.core.entity.FlamingoEntity;
import net.satisfy.wildernature.core.entity.HedgehogEntity;
import net.satisfy.wildernature.core.entity.MiniSheepEntity;
import net.satisfy.wildernature.core.entity.OwlEntity;
import net.satisfy.wildernature.core.entity.PelicanEntity;
import net.satisfy.wildernature.core.entity.PenguinEntity;
import net.satisfy.wildernature.core.entity.RaccoonEntity;
import net.satisfy.wildernature.core.entity.RedWolfEntity;
import net.satisfy.wildernature.core.entity.SquirrelEntity;
import net.satisfy.wildernature.core.entity.TermiteEntity;
import net.satisfy.wildernature.core.entity.TurkeyEntity;
import net.satisfy.wildernature.core.registry.ObjectRegistry;

public class EntityTypeRegistry {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((String)"wildernature", (ResourceKey)Registries.BLOCK_ENTITY_TYPE);
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"wildernature", (ResourceKey)Registries.ENTITY_TYPE);
    public static final RegistrySupplier<BlockEntityType<CompletionistBannerEntity>> COMPLETIONIST_BANNER_ENTITY = EntityTypeRegistry.createBlockEntity("completionist_banner", () -> BlockEntityType.Builder.of(CompletionistBannerEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.WOLF_TRAPPER_BANNER.get(), (Block)ObjectRegistry.WOLF_TRAPPER_WALL_BANNER.get(), (Block)ObjectRegistry.BUNNY_STALKER_BANNER.get(), (Block)ObjectRegistry.BUNNY_STALKER_WALL_BANNER.get(), (Block)ObjectRegistry.COD_CATCHER_BANNER.get(), (Block)ObjectRegistry.COD_CATCHER_WALL_BANNER.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<BountyBoardBlockEntity>> BOUNTY_BOARD_ENTITY = EntityTypeRegistry.createBlockEntity("bounty_board", () -> BlockEntityType.Builder.of(BountyBoardBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.BOUNTY_BOARD.get()}).build(null));
    public static final RegistrySupplier<EntityType<TermiteEntity>> TERMITE = EntityTypeRegistry.createEntity("termite", () -> EntityType.Builder.of(TermiteEntity::new, (MobCategory)MobCategory.MONSTER).build(WilderNature.identifier("termite").toString()));
    public static final RegistrySupplier<EntityType<BisonEntity>> BISON = EntityTypeRegistry.createEntity("bison", () -> EntityType.Builder.of(BisonEntity::new, (MobCategory)MobCategory.CREATURE).sized(1.8f, 2.2f).build(WilderNature.identifier("bison").toString()));
    public static final RegistrySupplier<EntityType<BoarEntity>> BOAR = EntityTypeRegistry.createEntity("boar", () -> EntityType.Builder.of(BoarEntity::new, (MobCategory)MobCategory.CREATURE).sized(1.1f, 1.1f).build(WilderNature.identifier("boar").toString()));
    public static final RegistrySupplier<EntityType<CassowaryEntity>> CASSOWARY = EntityTypeRegistry.createEntity("cassowary", () -> EntityType.Builder.of(CassowaryEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.8f, 0.8f).clientTrackingRange(10).build(WilderNature.identifier("cassowary").toString()));
    public static final RegistrySupplier<EntityType<DeerEntity>> DEER = EntityTypeRegistry.createEntity("deer", () -> EntityType.Builder.of(DeerEntity::new, (MobCategory)MobCategory.CREATURE).sized(1.3f, 1.6f).build(WilderNature.identifier("deer").toString()));
    public static final RegistrySupplier<EntityType<DogEntity>> DOG = EntityTypeRegistry.createEntity("dog", () -> EntityType.Builder.of(DogEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.3f).build(WilderNature.identifier("dog").toString()));
    public static final RegistrySupplier<EntityType<FlamingoEntity>> FLAMINGO = EntityTypeRegistry.createEntity("flamingo", () -> EntityType.Builder.of(FlamingoEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.0f).clientTrackingRange(10).build(WilderNature.identifier("flamingo").toString()));
    public static final RegistrySupplier<EntityType<HedgehogEntity>> HEDGEHOG = EntityTypeRegistry.createEntity("hedgehog", () -> EntityType.Builder.of(HedgehogEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.3f, 0.3f).clientTrackingRange(10).build(WilderNature.identifier("hedgehog").toString()));
    public static final RegistrySupplier<EntityType<MiniSheepEntity>> MINISHEEP = EntityTypeRegistry.createEntity("minisheep", () -> EntityType.Builder.of(MiniSheepEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.3f).build(WilderNature.identifier("minisheep").toString()));
    public static final RegistrySupplier<EntityType<OwlEntity>> OWL = EntityTypeRegistry.createEntity("owl", () -> EntityType.Builder.of(OwlEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.0f).build(WilderNature.identifier("owl").toString()));
    public static final RegistrySupplier<EntityType<PelicanEntity>> PELICAN = EntityTypeRegistry.createEntity("pelican", () -> EntityType.Builder.of(PelicanEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.0f).build(WilderNature.identifier("pelican").toString()));
    public static final RegistrySupplier<EntityType<PenguinEntity>> PENGUIN = EntityTypeRegistry.createEntity("penguin", () -> EntityType.Builder.of(PenguinEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.7f, 0.9f).clientTrackingRange(10).build(WilderNature.identifier("penguin").toString()));
    public static final RegistrySupplier<EntityType<RaccoonEntity>> RACCOON = EntityTypeRegistry.createEntity("raccoon", () -> EntityType.Builder.of(RaccoonEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.6f).build(WilderNature.identifier("raccoon").toString()));
    public static final RegistrySupplier<EntityType<RedWolfEntity>> RED_WOLF = EntityTypeRegistry.createEntity("red_wolf", () -> EntityType.Builder.of(RedWolfEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.7f, 0.9f).clientTrackingRange(10).build(String.valueOf(WilderNature.identifier("red_wolf"))));
    public static final RegistrySupplier<EntityType<SquirrelEntity>> SQUIRREL = EntityTypeRegistry.createEntity("squirrel", () -> EntityType.Builder.of(SquirrelEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.4f, 0.9f).build(WilderNature.identifier("squirrel").toString()));
    public static final RegistrySupplier<EntityType<TurkeyEntity>> TURKEY = EntityTypeRegistry.createEntity("turkey", () -> EntityType.Builder.of(TurkeyEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.0f).build(WilderNature.identifier("turkey").toString()));
    public static final RegistrySupplier<EntityType<BulletEntity>> BULLET = EntityTypeRegistry.createEntity("bullet", () -> EntityType.Builder.of(BulletEntity::new, (MobCategory)MobCategory.MISC).sized(0.3125f, 0.3125f).clientTrackingRange(64).updateInterval(2).build(WilderNature.identifier("bullet").toString()));

    public static <T extends EntityType<?>> RegistrySupplier<T> createEntity(String path, Supplier<T> type) {
        return ENTITY_TYPES.register(WilderNature.identifier(path), type);
    }

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> createBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITIES.register(WilderNature.identifier(path), type);
    }

    public static void init() {
        ENTITY_TYPES.register();
        BLOCK_ENTITIES.register();
        EntityAttributeRegistry.register(TERMITE, TermiteEntity::createMobAttributes);
        EntityAttributeRegistry.register(BISON, BisonEntity::createMobAttributes);
        EntityAttributeRegistry.register(BOAR, BoarEntity::createMobAttributes);
        EntityAttributeRegistry.register(CASSOWARY, CassowaryEntity::createMobAttributes);
        EntityAttributeRegistry.register(DEER, DeerEntity::createMobAttributes);
        EntityAttributeRegistry.register(DOG, DogEntity::createMobAttributes);
        EntityAttributeRegistry.register(FLAMINGO, FlamingoEntity::createMobAttributes);
        EntityAttributeRegistry.register(HEDGEHOG, HedgehogEntity::createMobAttributes);
        EntityAttributeRegistry.register(MINISHEEP, MiniSheepEntity::createMobAttributes);
        EntityAttributeRegistry.register(OWL, OwlEntity::createMobAttributes);
        EntityAttributeRegistry.register(PELICAN, PelicanEntity::createMobAttributes);
        EntityAttributeRegistry.register(PENGUIN, PenguinEntity::createMobAttributes);
        EntityAttributeRegistry.register(RACCOON, RaccoonEntity::createMobAttributes);
        EntityAttributeRegistry.register(RED_WOLF, RedWolfEntity::createMobAttributes);
        EntityAttributeRegistry.register(SQUIRREL, SquirrelEntity::createMobAttributes);
        EntityAttributeRegistry.register(TURKEY, TurkeyEntity::createMobAttributes);
    }
}

