/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class BetterFollowOwnerGoal
extends Goal {
    public static final RandomSource RANDOM = RandomSource.create();
    protected final TamableAnimal tameable;
    protected final Level level;
    protected final double speed;
    protected final PathNavigation navigation;
    protected final float maxDistance;
    protected final float minDistance;
    protected final boolean leavesAllowed;
    protected LivingEntity owner;
    protected int updateCountdownTicks;
    protected float oldWaterPathfindingPenalty;

    public BetterFollowOwnerGoal(TamableAnimal tameable, double speed, float minDistance, float maxDistance, boolean leavesAllowed) {
        this.tameable = tameable;
        this.level = tameable.level();
        this.speed = speed;
        this.navigation = tameable.getNavigation();
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.leavesAllowed = leavesAllowed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(tameable.getNavigation() instanceof GroundPathNavigation) && !(tameable.getNavigation() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob tier for FollowOwnerGoal");
        }
    }

    public static int randomRange(int min, int max) {
        return RANDOM.nextInt(max - min) + min;
    }

    public static int randomBias(int min, int max) {
        int num = BetterFollowOwnerGoal.randomRange(min, max);
        int mid = max / 2 - min / 2;
        int halfMid = mid / 2;
        if (num > mid) {
            num -= RANDOM.nextInt(halfMid + 1);
        } else if (num < mid) {
            num += RANDOM.nextInt(halfMid + 1);
        }
        return num;
    }

    public boolean canUse() {
        LivingEntity livingEntity = this.tameable.getOwner();
        if (livingEntity == null) {
            return false;
        }
        if (livingEntity.isSpectator()) {
            return false;
        }
        if (this.tameable.isOrderedToSit()) {
            return false;
        }
        if (this.tameable.distanceToSqr((Entity)livingEntity) < (double)(this.minDistance * this.minDistance)) {
            return false;
        }
        this.owner = livingEntity;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.navigation.isDone()) {
            return false;
        }
        if (this.tameable.isOrderedToSit()) {
            return false;
        }
        return this.tameable.distanceToSqr((Entity)this.owner) > (double)(this.maxDistance * this.maxDistance);
    }

    public void start() {
        this.updateCountdownTicks = 0;
        this.oldWaterPathfindingPenalty = this.tameable.getPathfindingMalus(PathType.WATER);
        this.tameable.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.owner = null;
        this.navigation.stop();
        this.tameable.setPathfindingMalus(PathType.WATER, this.oldWaterPathfindingPenalty);
    }

    public void tick() {
        this.tameable.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.tameable.getMaxHeadXRot());
        if (--this.updateCountdownTicks <= 0) {
            this.updateCountdownTicks = 10;
            if (!this.tameable.isLeashed() && !this.tameable.isPassenger()) {
                if (this.tameable.distanceToSqr((Entity)this.owner) >= 144.0) {
                    this.tryTeleport();
                } else {
                    this.startFollowing();
                }
            }
        }
    }

    protected void startFollowing() {
        this.navigation.moveTo((Entity)this.owner, this.speed);
    }

    protected void tryTeleport() {
        BlockPos blockPos = this.owner.getOnPos();
        for (int i = 0; i < 10; ++i) {
            int j = BetterFollowOwnerGoal.randomRange(-3, 3);
            int k = BetterFollowOwnerGoal.randomRange(-1, 1);
            int l = BetterFollowOwnerGoal.randomRange(-3, 3);
            boolean didTeleport = this.tryTeleportTo(blockPos.getX() + j, blockPos.getY() + k, blockPos.getZ() + l);
            if (!didTeleport) continue;
            return;
        }
    }

    protected boolean tryTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.getX()) < 2.0 && Math.abs((double)z - this.owner.getZ()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.tameable.moveTo((double)x + 0.5, (double)y, (double)z + 0.5, this.tameable.xRotO, this.tameable.yRotO);
        this.navigation.stop();
        return true;
    }

    protected boolean canTeleportTo(BlockPos pos) {
        PathType pathNodeType = WalkNodeEvaluator.getPathTypeStatic((Mob)this.tameable, (BlockPos)pos.mutable());
        if (pathNodeType != PathType.WALKABLE) {
            return false;
        }
        BlockState blockState = this.level.getBlockState(pos.below());
        if (!this.leavesAllowed && blockState.getBlock() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockPos = pos.subtract((Vec3i)this.tameable.getOnPos());
        return this.level.noCollision((Entity)this.tameable, this.tameable.getBoundingBox().move(blockPos));
    }
}

