/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.satisfy.wildernature.core.registry.EntityTypeRegistry;
import net.satisfy.wildernature.core.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class PenguinEntity
extends Animal {
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;

    public void tick() {
        Entity entity;
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        if (this.isPassenger() && (entity = this.getVehicle()) instanceof Boat) {
            Boat boat = (Boat)entity;
            boat.setDeltaMovement(boat.getDeltaMovement().multiply(1.25, 1.0, 1.25));
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.random.nextInt(40) + 80;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected void updateWalkAnimation(float pPartialTick) {
        float f = this.getPose() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f, 0.2f);
    }

    public PenguinEntity(EntityType<? extends PenguinEntity> entityType, Level level) {
        super(entityType, level);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 14.0).add(Attributes.FOLLOW_RANGE, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.23f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.15));
        this.goalSelector.addGoal(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new BoatDrivingGoal((Mob)this, 0.5));
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.PENGUIN_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.PENGUIN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.PENGUIN_DEATH.get();
    }

    protected void playStepSound(BlockPos blockPos, BlockState blockState) {
        this.playSound(SoundEvents.CHICKEN_STEP, 0.15f, 1.0f);
    }

    @Nullable
    public PenguinEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (PenguinEntity)((EntityType)EntityTypeRegistry.PENGUIN.get()).create((Level)serverLevel);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ItemTags.FISHES);
    }

    public static class BoatDrivingGoal
    extends Goal {
        private final Mob entity;
        private Boat boat;
        private final double speed;

        public BoatDrivingGoal(Mob entity, double speed) {
            this.entity = entity;
            this.speed = speed;
        }

        public boolean canUse() {
            if (this.entity.isPassenger() && this.entity.getVehicle() instanceof Boat) {
                this.boat = (Boat)this.entity.getVehicle();
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.canUse() && !this.boat.isRemoved();
        }

        public void start() {
            this.boat.setYRot(this.entity.getYRot());
        }

        public void stop() {
            this.boat = null;
        }

        public void tick() {
            if (this.boat == null) {
                return;
            }
            if (this.isOnWater()) {
                float yaw = this.entity.getYRot();
                Vector3f moveDirection = new Vector3f((float)(-Math.sin(Math.toRadians(yaw))), 0.0f, (float)Math.cos(Math.toRadians(yaw)));
                this.boat.setDeltaMovement((double)moveDirection.x() * this.speed * 1.25, this.boat.getDeltaMovement().y(), (double)moveDirection.z() * this.speed * 1.25);
                this.boat.setPaddleState(moveDirection.x() != 0.0f || moveDirection.z() != 0.0f, moveDirection.x() != 0.0f || moveDirection.z() != 0.0f);
            } else {
                this.navigateToWater();
            }
        }

        private boolean isOnWater() {
            BlockPos pos = this.boat.blockPosition();
            BlockState blockState = this.entity.level().getBlockState(pos.below());
            return blockState.is(Blocks.WATER);
        }

        private void navigateToWater() {
            BlockPos boatPos = this.boat.blockPosition();
            for (int dx = -5; dx <= 5; ++dx) {
                for (int dz = -5; dz <= 5; ++dz) {
                    BlockPos pos = boatPos.offset(dx, 0, dz);
                    BlockState blockState = this.entity.level().getBlockState(pos);
                    if (!blockState.is(Blocks.WATER)) continue;
                    double directionX = (double)pos.getX() + 0.5 - this.boat.getX();
                    double directionZ = (double)pos.getZ() + 0.5 - this.boat.getZ();
                    Vector3f direction = new Vector3f((float)directionX, 0.0f, (float)directionZ).normalize();
                    this.boat.setDeltaMovement((double)direction.x() * this.speed, this.boat.getDeltaMovement().y, (double)direction.z() * this.speed);
                    return;
                }
            }
        }
    }
}

