/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.entity;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.satisfy.wildernature.core.entity.ai.RandomAction;
import net.satisfy.wildernature.core.entity.ai.RandomActionGoal;
import net.satisfy.wildernature.core.entity.animation.ServerAnimationDurations;
import net.satisfy.wildernature.core.registry.EntityTypeRegistry;
import net.satisfy.wildernature.core.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HedgehogEntity
extends Animal {
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public AnimationState sniffAnimationState = new AnimationState();
    private static final EntityDataAccessor<Boolean> SNIFFING = SynchedEntityData.defineId(HedgehogEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public HedgehogEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.13000000417232513).add(Attributes.MAX_HEALTH, 4.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.ROTTEN_FLESH}), true));
        this.goalSelector.addGoal(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.goalSelector.addGoal(6, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.goalSelector.addGoal(7, (Goal)new RandomActionGoal(new RandomAction(){

            @Override
            public boolean isInterruptable() {
                return false;
            }

            @Override
            public void onStart() {
                HedgehogEntity.this.setSniffing(true);
            }

            @Override
            public void onStop() {
                HedgehogEntity.this.setSniffing(false);
            }

            @Override
            public boolean isPossible() {
                return true;
            }

            @Override
            public int duration() {
                return (int)(ServerAnimationDurations.hedgehog_sniffing * 20.0f);
            }

            @Override
            public float chance() {
                return 0.005f;
            }

            @Override
            public AttributeInstance getAttribute(Attribute movementSpeed) {
                return HedgehogEntity.this.getAttribute(BuiltInRegistries.ATTRIBUTE.wrapAsHolder((Object)movementSpeed));
            }
        }));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.5, 0.5, 0.5));
            for (Entity entity : entities) {
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                if (!(player.fallDistance > 1.0f) || !(player.getY() > this.getY() + 1.0)) continue;
                this.level().addParticle((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                this.kill();
                player.hurt(this.level().damageSources().generic(), 3.0f);
                break;
            }
        }
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        this.sniffAnimationState.animateWhen(this.isSniffing(), this.tickCount);
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.random.nextInt(40) + 80;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    private boolean isSniffing() {
        return (Boolean)this.entityData.get(SNIFFING);
    }

    public void setSniffing(boolean sniffing) {
        this.entityData.set(SNIFFING, (Object)sniffing);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)EntityTypeRegistry.HEDGEHOG.get()).create((Level)serverLevel);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SNIFFING, (Object)false);
    }

    protected void updateWalkAnimation(float pPartialTick) {
        super.updateWalkAnimation(pPartialTick);
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.HEDGEHOG_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.HEDGEHOG_DEATH.get();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.HEDGEHOG_AMBIENT.get();
    }

    protected float getSoundVolume() {
        return 0.1f;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.ROTTEN_FLESH);
    }

    @NotNull
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.is(Items.ROTTEN_FLESH)) {
            if (this.isFood(itemstack) && this.getAge() == 0 && !this.level().isClientSide) {
                this.usePlayerItem(player, hand, itemstack);
                this.setInLove(player);
                return InteractionResult.SUCCESS;
            }
        } else if (itemstack.is(Items.MILK_BUCKET)) {
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
                player.addItem(new ItemStack((ItemLike)Items.BUCKET));
            }
            this.addEffect(new MobEffectInstance(MobEffects.POISON, 240, 1));
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }
}

