/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.satisfy.wildernature.core.item.AmmunitionItem;
import net.satisfy.wildernature.core.network.EntityPacketHandler;
import net.satisfy.wildernature.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class BulletEntity
extends Fireball {
    private static final double STOP_TRESHOLD = 0.01;
    private static final double GRAVITY = 0.05;
    private double damage = 1.0;
    private boolean ignoreInvulnerability = false;
    private double knockbackStrength = 0.0;
    private int ticksSinceFired;
    private Vec3 initialPosition;
    private int lifeTicks = 40;

    public BulletEntity(EntityType<? extends Fireball> entityType, Level level) {
        super(entityType, level);
    }

    public BulletEntity(Level worldIn, LivingEntity shooter) {
        this(worldIn, shooter, 0.0, 0.0, 0.0);
        this.setPos(shooter.getX(), shooter.getEyeY() - 0.1, shooter.getZ());
        this.initialPosition = new Vec3(shooter.getX(), shooter.getEyeY() - 0.1, shooter.getZ());
    }

    public BulletEntity(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType)EntityTypeRegistry.BULLET.get(), shooter, new Vec3(accelX, accelY, accelZ), worldIn);
        this.initialPosition = new Vec3(shooter.getX(), shooter.getEyeY() - 0.1, shooter.getZ());
    }

    public void tick() {
        double distanceTraveled;
        if (this.initialPosition == null) {
            this.initialPosition = this.position();
        }
        if (--this.lifeTicks <= 0) {
            this.discard();
            return;
        }
        ++this.ticksSinceFired;
        if (this.ticksSinceFired > 100 || this.getDeltaMovement().lengthSqr() < 0.01) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        if ((distanceTraveled = this.position().distanceTo(this.initialPosition)) > 20.0) {
            Vec3 movement = this.getDeltaMovement();
            this.setDeltaMovement(movement.add(0.0, -0.05, 0.0));
        }
        super.tick();
    }

    protected void onHitEntity(EntityHitResult raytrace) {
        super.onHitEntity(raytrace);
        if (!this.level().isClientSide) {
            boolean damaged;
            Entity target = raytrace.getEntity();
            Entity shooter = this.getOwner();
            AmmunitionItem bullet = (AmmunitionItem)this.getItem().getItem();
            int lastHurtResistant = target.invulnerableTime;
            if (this.ignoreInvulnerability) {
                target.invulnerableTime = 0;
            }
            if ((damaged = target.hurt(this.level().damageSources().indirectMagic((Entity)this, shooter), (float)bullet.modifyDamage(this.damage, this, target, shooter, this.level()))) && target instanceof LivingEntity) {
                Vec3 vec;
                LivingEntity livingTarget = (LivingEntity)target;
                if (this.knockbackStrength > 0.0 && (vec = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(this.knockbackStrength)).lengthSqr() > 0.0) {
                    livingTarget.push(vec.x, 0.1, vec.z);
                }
                if (this.ignoreInvulnerability) {
                    livingTarget.invulnerableTime = 0;
                }
            } else if (!damaged && this.ignoreInvulnerability) {
                target.invulnerableTime = lastHurtResistant;
            }
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!(this.level().isClientSide || this.noPhysics && result.getType() == HitResult.Type.BLOCK)) {
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("tickssincefired", this.ticksSinceFired);
        compound.putDouble("damage", this.damage);
        compound.putInt("lifeTicks", this.lifeTicks);
        if (this.ignoreInvulnerability) {
            compound.putBoolean("ignoreinvulnerability", true);
        }
        if (this.knockbackStrength != 0.0) {
            compound.putDouble("knockback", this.knockbackStrength);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.ticksSinceFired = compound.getInt("tickssincefired");
        this.damage = compound.getDouble("damage");
        this.lifeTicks = compound.getInt("lifeTicks");
        this.ignoreInvulnerability = compound.getBoolean("ignoreinvulnerability");
        this.knockbackStrength = compound.getDouble("knockback");
    }

    public double getDamage() {
        return this.damage;
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public void setIgnoreInvulnerability(boolean ignoreInvulnerability) {
        this.ignoreInvulnerability = ignoreInvulnerability;
    }

    public void setLifeTicks(int ticks) {
        this.lifeTicks = ticks;
    }

    public void shootFromRotation(Entity shooter, float xRot, float yRot, float p_37255_, float speed, float spread) {
        float f = -Mth.sin((float)(yRot * ((float)Math.PI / 180))) * Mth.cos((float)(xRot * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)((xRot + p_37255_) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(yRot * ((float)Math.PI / 180))) * Mth.cos((float)(xRot * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, speed, spread);
    }

    public boolean isPickable() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    protected float getInertia() {
        return 1.0f;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return EntityPacketHandler.createAddEntityPacket((Entity)this, serverEntity);
    }
}

