/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.block.entity.CompletionistBannerEntity;
import net.satisfy.wildernature.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionistBannerBlock
extends BaseEntityBlock {
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final MapCodec<CompletionistBannerBlock> CODEC = CompletionistBannerBlock.simpleCodec(CompletionistBannerBlock::new);

    public CompletionistBannerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.makeDefaultState();
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new CompletionistBannerEntity(blockPos, blockState);
    }

    protected void makeDefaultState() {
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ROTATION, (Comparable)Integer.valueOf(0)));
    }

    public boolean canSurvive(@NotNull BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        BlockState belowBlockState = levelReader.getBlockState(blockPos.below());
        return belowBlockState.isSolid();
    }

    public boolean isPossibleToRespawnInThis(BlockState blockState) {
        return true;
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        context.getClickedPos();
        Direction clickedFace = context.getClickedFace();
        if (clickedFace == Direction.UP || clickedFace == Direction.DOWN) {
            return (BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(Mth.floor((double)((double)((180.0f + context.getRotation()) * 16.0f / 360.0f) + 0.5)) & 0xF));
        }
        if (this == ObjectRegistry.WOLF_TRAPPER_BANNER.get()) {
            return (BlockState)((Block)ObjectRegistry.WOLF_TRAPPER_WALL_BANNER.get()).defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)clickedFace.getOpposite());
        }
        if (this == ObjectRegistry.BUNNY_STALKER_BANNER.get()) {
            return (BlockState)((Block)ObjectRegistry.BUNNY_STALKER_WALL_BANNER.get()).defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)clickedFace.getOpposite());
        }
        if (this == ObjectRegistry.COD_CATCHER_BANNER.get()) {
            return (BlockState)((Block)ObjectRegistry.COD_CATCHER_WALL_BANNER.get()).defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)clickedFace.getOpposite());
        }
        return (BlockState)((Block)ObjectRegistry.WOLF_TRAPPER_WALL_BANNER.get()).defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)clickedFace.getOpposite());
    }

    @NotNull
    public BlockState rotate(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.setValue((Property)ROTATION, (Comparable)Integer.valueOf(rotation.rotate(((Integer)blockState.getValue((Property)ROTATION)).intValue(), 16)));
    }

    @NotNull
    public BlockState mirror(BlockState blockState, Mirror mirror) {
        return (BlockState)blockState.setValue((Property)ROTATION, (Comparable)Integer.valueOf(mirror.mirror(((Integer)blockState.getValue((Property)ROTATION)).intValue(), 16)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ROTATION});
    }

    @NotNull
    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (direction == Direction.DOWN && !blockState.canSurvive((LevelReader)levelAccessor, blockPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public ResourceLocation getRenderTexture() {
        if (this == ObjectRegistry.WOLF_TRAPPER_BANNER.get()) {
            return WilderNature.identifier("textures/banner/wolf_trapper.png");
        }
        if (this == ObjectRegistry.BUNNY_STALKER_BANNER.get()) {
            return WilderNature.identifier("textures/banner/rabbit_hunter.png");
        }
        if (this == ObjectRegistry.BUNNY_STALKER_WALL_BANNER.get()) {
            return WilderNature.identifier("textures/banner/rabbit_hunter.png");
        }
        if (this == ObjectRegistry.COD_CATCHER_BANNER.get()) {
            return WilderNature.identifier("textures/banner/cod_catcher.png");
        }
        if (this == ObjectRegistry.COD_CATCHER_WALL_BANNER.get()) {
            return WilderNature.identifier("textures/banner/cod_catcher.png");
        }
        return WilderNature.identifier("textures/banner/wolf_trapper.png");
    }
}

