/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.block;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.wildernature.core.block.entity.BountyBoardBlockEntity;
import net.satisfy.wildernature.core.registry.ObjectRegistry;
import net.satisfy.wildernature.core.util.WilderNatureUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BountyBoardBlock
extends BaseEntityBlock {
    public static final EnumProperty<Part> PART = EnumProperty.create((String)"part", Part.class);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape SHAPE_BOTTOM_LEFT = BountyBoardBlock.makeBottomLeftShape();
    private static final VoxelShape SHAPE_BOTTOM_RIGHT = BountyBoardBlock.makeBottomRightShape();
    private static final VoxelShape SHAPE_TOP_LEFT = BountyBoardBlock.makeTopLeftShape();
    private static final VoxelShape SHAPE_TOP_RIGHT = BountyBoardBlock.makeTopRightShape();
    public static final MapCodec<BountyBoardBlock> CODEC = BountyBoardBlock.simpleCodec(BountyBoardBlock::new);
    public static final Map<Direction, Map<Part, VoxelShape>> SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            HashMap<Part, VoxelShape> partShapeMap = new HashMap<Part, VoxelShape>();
            partShapeMap.put(Part.BOTTOM_LEFT, WilderNatureUtil.rotateShape(Direction.NORTH, direction, SHAPE_BOTTOM_LEFT));
            partShapeMap.put(Part.BOTTOM_RIGHT, WilderNatureUtil.rotateShape(Direction.NORTH, direction, SHAPE_BOTTOM_RIGHT));
            partShapeMap.put(Part.TOP_LEFT, WilderNatureUtil.rotateShape(Direction.NORTH, direction, SHAPE_TOP_LEFT));
            partShapeMap.put(Part.TOP_RIGHT, WilderNatureUtil.rotateShape(Direction.NORTH, direction, SHAPE_TOP_RIGHT));
            map.put(direction, partShapeMap);
        }
    });

    public BountyBoardBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)((Object)Part.BOTTOM_LEFT))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    private static VoxelShape makeBottomLeftShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.4375, (double)0.125, (double)1.0, (double)0.5625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.5, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeBottomRightShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.0, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.5, (double)0.4375, (double)0.875, (double)1.0, (double)0.5625), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeTopLeftShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.4375, (double)1.0, (double)0.875, (double)0.5625), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeTopRightShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.4375, (double)1.0, (double)0.875, (double)0.5625), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction;
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        if (!this.canPlaceAt(world, pos, direction = context.getHorizontalDirection().getOpposite())) {
            return null;
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)Part.BOTTOM_LEFT))).setValue((Property)FACING, (Comparable)direction);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Player player;
        Direction direction = (Direction)state.getValue((Property)FACING);
        world.setBlock(pos.above(), (BlockState)((BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)Part.TOP_LEFT))).setValue((Property)FACING, (Comparable)direction), 3);
        world.setBlock(pos.relative(direction.getClockWise()), (BlockState)((BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)Part.BOTTOM_RIGHT))).setValue((Property)FACING, (Comparable)direction), 3);
        world.setBlock(pos.relative(direction.getClockWise()).above(), (BlockState)((BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)Part.TOP_RIGHT))).setValue((Property)FACING, (Comparable)direction), 3);
        world.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.playSound(null, pos, SoundEvents.CHERRY_WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (placer instanceof Player && !(player = (Player)placer).isCreative()) {
            stack.shrink(1);
        }
    }

    private boolean canPlaceAt(Level world, BlockPos pos, Direction direction) {
        return world.getBlockState(pos).canBeReplaced() && world.getBlockState(pos.above()).canBeReplaced() && world.getBlockState(pos.relative(direction.getClockWise())).canBeReplaced() && world.getBlockState(pos.relative(direction.getClockWise()).above()).canBeReplaced();
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        state.getBlock();
        newState.getBlock();
        super.onRemove(state, world, pos, newState, isMoving);
    }

    private BlockPos getBasePos(BlockState state, BlockPos pos) {
        Part part = (Part)((Object)state.getValue(PART));
        Direction direction = (Direction)state.getValue((Property)FACING);
        return switch (part.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> pos;
            case 2 -> pos.below();
            case 1 -> pos.relative(direction.getCounterClockWise(), 1);
            case 3 -> pos.relative(direction.getCounterClockWise(), 1).below();
        };
    }

    private void destroyAdjacentBlocks(Level world, BlockPos basePos) {
        BlockState blockstate = world.getBlockState(basePos);
        Direction facing = (Direction)blockstate.getValue((Property)FACING);
        world.removeBlock(basePos, false);
        world.removeBlock(basePos.above(), false);
        world.removeBlock(basePos.relative(facing.getClockWise(), 1), false);
        world.removeBlock(basePos.relative(facing.getClockWise(), 1).above(), false);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        Part part = (Part)((Object)state.getValue(PART));
        return SHAPE.get(direction).get((Object)part);
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide()) {
            BlockPos basePos = this.getBasePos(level.getBlockState(pos), pos);
            ItemStack stack = new ItemStack((ItemLike)ObjectRegistry.BOUNTY_BOARD.get());
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack));
            this.destroyAdjacentBlocks(level, basePos);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        if (blockPos != this.getBasePos(blockState, blockPos)) {
            return null;
        }
        return new BountyBoardBlockEntity(blockPos, blockState);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.translatable((String)"tooltip.wildernature.canbeplaced").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)"tooltip.wildernature.bountyboard").withStyle(ChatFormatting.GRAY));
    }

    public static enum Part implements StringRepresentable
    {
        BOTTOM_LEFT("bottom_left"),
        BOTTOM_RIGHT("bottom_right"),
        TOP_LEFT("top_left"),
        TOP_RIGHT("top_right");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

