/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.wildernature.core.block.WallDecorationBlock;
import net.satisfy.wildernature.core.registry.SoundRegistry;
import net.satisfy.wildernature.core.util.WilderNatureUtil;
import org.jetbrains.annotations.NotNull;

public class BisonTrophyBlock
extends WallDecorationBlock {
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.1875, (double)0.9375, (double)1.0, (double)0.8125, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.15625, (double)0.125, (double)0.125, (double)0.84375, (double)0.875, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.15625, (double)0.5625, (double)0.375, (double)0.15625, (double)0.75, (double)0.4375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.28125, (double)0.125, (double)-0.1875, (double)0.71875, (double)0.625, (double)0.125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.84375, (double)0.5625, (double)0.375, (double)1.15625, (double)0.75, (double)0.4375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.625, (double)0.5, (double)0.1875, (double)1.25, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.625, (double)0.5, (double)1.0, (double)1.25, (double)0.6875), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(direction, WilderNatureUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });
    private final Map<Player, Long> lastUseTime = new HashMap<Player, Long>();

    public BisonTrophyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.getValue((Property)FACING));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        if (!world.isClientSide) {
            Long lastUsed;
            long currentTime = System.currentTimeMillis();
            if (currentTime - (lastUsed = this.lastUseTime.getOrDefault(player, 0L)) < 180000L) {
                world.playSound(null, pos, SoundEvents.BEACON_POWER_SELECT, SoundSource.BLOCKS, 0.25f, 0.5f);
                return InteractionResult.FAIL;
            }
            this.lastUseTime.put(player, currentTime);
            world.playSound(null, pos, (SoundEvent)SoundRegistry.BISON_ANGRY.get(), SoundSource.BLOCKS, 0.25f, 1.0f);
            ServerLevel serverLevel = (ServerLevel)world;
            for (int radius = 0; radius <= 20; ++radius) {
                for (int angle = 0; angle < 360; angle += 10) {
                    double radians = Math.toRadians(angle);
                    double offsetX = (double)radius * Math.cos(radians);
                    double offsetZ = (double)radius * Math.sin(radians);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.CLOUD, (double)pos.getX() + 0.5 + offsetX, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5 + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            AABB area = new AABB(pos).inflate(20.0);
            List entities = world.getEntitiesOfClass(LivingEntity.class, area);
            for (LivingEntity entity : entities) {
                if (entity == player) continue;
                double dx = entity.getX() - (double)pos.getX();
                double dz = entity.getZ() - (double)pos.getZ();
                double distance = Math.sqrt(dx * dx + dz * dz);
                double strength = 2.0 / (distance + 1.0);
                entity.knockback(strength, dx, dz);
                entity.hurt(world.damageSources().hotFloor(), 1.0f);
            }
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }
}

