/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.client.model.entity.RaccoonModel;
import net.satisfy.wildernature.core.entity.RaccoonEntity;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class RaccoonRenderer
extends MobRenderer<RaccoonEntity, RaccoonModel<RaccoonEntity>> {
    private static final ResourceLocation RACCOON_TEXTURE = WilderNature.identifier("textures/entity/raccoon.png");
    private static final ResourceLocation RACOON_SLEEP_TEXTURE = WilderNature.identifier("textures/entity/raccoon.png");

    public RaccoonRenderer(EntityRendererProvider.Context context) {
        super(context, new RaccoonModel(context.bakeLayer(RaccoonModel.LAYER_LOCATION)), 0.7f);
    }

    protected void setupRotations(RaccoonEntity livingEntity, PoseStack poseStack, float f, float g, float h, float i) {
        super.setupRotations((LivingEntity)livingEntity, poseStack, f, g, h, i);
    }

    @NotNull
    public ResourceLocation getTextureLocation(RaccoonEntity entity) {
        return entity.isSleeping() ? RACOON_SLEEP_TEXTURE : RACCOON_TEXTURE;
    }

    public void render(RaccoonEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        if (pEntity.isBaby()) {
            pMatrixStack.scale(0.4f, 0.4f, 0.4f);
        }
        super.render((LivingEntity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }
}

