/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.entity.SquirrelEntity;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SquirrelModel
extends AgeableListModel<SquirrelEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WilderNature.identifier("squirrel"), "main");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart leftThigh;
    private final ModelPart leftFoot;
    private final ModelPart rightLeg;
    private final ModelPart rightThigh;
    private final ModelPart rightFoot;
    private final ModelPart tail;

    public SquirrelModel(ModelPart root) {
        super(true, 0.0f, 0.0f);
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.leftArm = this.body.getChild("leftArm");
        this.rightArm = this.body.getChild("rightArm");
        this.leftLeg = this.body.getChild("leftLeg");
        this.leftThigh = this.leftLeg.getChild("leftThigh");
        this.leftFoot = this.leftThigh.getChild("leftFoot");
        this.rightLeg = this.body.getChild("rightLeg");
        this.rightThigh = this.rightLeg.getChild("rightThigh");
        this.rightFoot = this.rightThigh.getChild("rightFoot");
        this.tail = this.body.getChild("tail");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(18, 13).addBox(-1.5f, -6.0f, -9.0f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(12, 13).addBox(1.5f, -7.0f, -6.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 13).addBox(-2.5f, -7.0f, -6.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 7).addBox(-0.5f, -2.0f, -9.0f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)22.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -6.0f, -4.0f, 5.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)23.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 25).addBox(-1.0f, -4.7929f, 5.7071f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 13).addBox(-1.0f, -10.7929f, 5.7071f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)-3.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = body.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(12, 28).addBox(-3.0f, -4.0f, -3.5f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = body.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(0, 0).addBox(2.0f, -4.0f, -3.5f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = body.addOrReplaceChild("rightLeg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition rightThigh = rightLeg.addOrReplaceChild("rightThigh", CubeListBuilder.create().texOffs(24, 25).addBox(-5.0f, -3.0f, 3.0f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)-1.0f, (float)-1.0f));
        PartDefinition rightFoot = rightThigh.addOrReplaceChild("rightFoot", CubeListBuilder.create().texOffs(13, 22).addBox(-12.0f, 1.0f, 2.0f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)-1.0f, (float)-1.0f));
        PartDefinition leftLeg = body.addOrReplaceChild("leftLeg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition leftThigh = leftLeg.addOrReplaceChild("leftThigh", CubeListBuilder.create().texOffs(26, 6).addBox(-5.0f, -3.0f, 2.0f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-1.0f, (float)0.0f));
        PartDefinition leftFoot = leftThigh.addOrReplaceChild("leftFoot", CubeListBuilder.create().texOffs(18, 0).addBox(-7.0f, 1.0f, 0.0f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-1.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(SquirrelEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.getAllParts().forEach(ModelPart::resetPose);
        this.head.resetPose();
        float swingCorrectionFactor = 0.1f;
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot += Mth.cos((float)((float)Math.toRadians(-45.0) + limbSwing)) * (swingCorrectionFactor * 0.4f) * limbSwingAmount;
        this.head.y += (-1.0f - Mth.cos((float)limbSwing)) * 0.0f * limbSwingAmount;
        this.head.z += 1.0f * limbSwingAmount;
        if (entity.isBaby()) {
            this.head.y -= -10.0f;
            this.head.z -= -1.5f;
        }
        this.body.xRot += (float)((Math.toRadians(10.0) - (double)Mth.cos((float)((float)Math.toRadians(-30.0) + limbSwing))) * (double)(swingCorrectionFactor * 3.5f) * (double)limbSwingAmount);
        this.body.y += (-1.0f - Mth.cos((float)limbSwing)) * 2.0f * limbSwingAmount;
        this.leftArm.xRot += (float)((Math.toRadians(-15.0) - (double)Mth.cos((float)((float)Math.toRadians(-35.0) + limbSwing))) * (double)(swingCorrectionFactor * 7.5f) * (double)limbSwingAmount);
        this.leftArm.yRot += (float)Math.toRadians(-5.0);
        this.leftArm.zRot += (float)((Math.toRadians(-15.0) - (double)Mth.cos((float)limbSwing)) * (double)(swingCorrectionFactor * 2.0f) * (double)limbSwingAmount);
        this.leftArm.z += (0.5f + Mth.cos((float)limbSwing)) * (swingCorrectionFactor * 0.05f) * limbSwingAmount;
        this.rightArm.xRot += (float)((Math.toRadians(-15.0) - (double)Mth.cos((float)((float)Math.toRadians(-45.0) + limbSwing))) * (double)(swingCorrectionFactor * 7.5f) * (double)limbSwingAmount);
        this.rightArm.yRot += (float)Math.toRadians(-5.0);
        this.rightArm.zRot += (float)((Math.toRadians(15.0) - (double)Mth.cos((float)limbSwing)) * (double)(swingCorrectionFactor * 2.0f) * (double)limbSwingAmount);
        this.rightArm.z += (0.5f + Mth.cos((float)((float)Math.toRadians(-25.0) + limbSwing))) * (swingCorrectionFactor * 0.05f) * limbSwingAmount;
        this.leftThigh.xRot += (float)((Math.toRadians(45.0) - (double)Mth.cos((float)((float)Math.toRadians(-45.0) + limbSwing))) * (double)(swingCorrectionFactor * 6.5f) * (double)limbSwingAmount);
        this.leftThigh.y += -3.0f * (swingCorrectionFactor * 7.0f) * limbSwingAmount;
        this.leftThigh.z += Mth.cos((float)((float)Math.toRadians(-35.0) + limbSwing)) * (swingCorrectionFactor * 0.1f) * limbSwingAmount;
        this.leftFoot.xRot += (float)((Math.toRadians(25.0) + (double)Mth.cos((float)((float)Math.toRadians(-125.0) + limbSwing))) * (double)(swingCorrectionFactor * 6.0f) * (double)limbSwingAmount);
        this.leftFoot.y += -1.0f * (swingCorrectionFactor * 2.0f) * limbSwingAmount;
        this.leftFoot.z += (-0.5f + Mth.cos((float)limbSwing)) * (swingCorrectionFactor * 0.025f) * limbSwingAmount;
        this.rightLeg.y += -1.0f * swingCorrectionFactor * limbSwingAmount;
        this.rightThigh.xRot += (float)((Math.toRadians(45.0) - (double)Mth.cos((float)((float)Math.toRadians(-25.0) + limbSwing))) * (double)(swingCorrectionFactor * 6.5f) * (double)limbSwingAmount);
        this.rightThigh.y += -2.0f * (swingCorrectionFactor * 7.0f) * limbSwingAmount;
        this.rightThigh.z += Mth.cos((float)((float)Math.toRadians(-35.0) + limbSwing)) * (swingCorrectionFactor * 0.1f) * limbSwingAmount;
        this.rightFoot.xRot += (float)((Math.toRadians(15.0) + (double)Mth.cos((float)((float)Math.toRadians(-85.0) + limbSwing))) * (double)(swingCorrectionFactor * 6.0f) * (double)limbSwingAmount);
        this.rightFoot.y += -1.0f * (swingCorrectionFactor * 2.0f) * limbSwingAmount;
        this.rightFoot.z += (-0.5f + Mth.cos((float)limbSwing)) * (swingCorrectionFactor * 0.025f) * limbSwingAmount;
        this.tail.xRot += (float)((Math.toRadians(-40.0) - (double)Mth.cos((float)((float)Math.toRadians(-120.0) + limbSwing))) * (double)(swingCorrectionFactor * 1.8f) * (double)limbSwingAmount);
        this.tail.z += Mth.cos((float)((float)Math.toRadians(-100.0) + limbSwing)) * (swingCorrectionFactor * 0.03f) * limbSwingAmount;
    }

    @NotNull
    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    @NotNull
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }
}

